/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class CastSummonVexes
extends Ability {
    public static final int CD_MAX_SECONDS = 60;
    public static final int VEX_DURATION_SECONDS = 30;

    public CastSummonVexes() {
        super(UnitAction.CAST_SUMMON_VEXES, 1200, 0.0f, 0.0f, true, false);
        this.autocastEnableAction = UnitAction.CAST_SUMMON_VEXES_AUTOCAST_ENABLE;
        this.autocastDisableAction = UnitAction.CAST_SUMMON_VEXES_AUTOCAST_DISABLE;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof EvokerUnit)) {
            return null;
        }
        EvokerUnit evokerUnit = (EvokerUnit)unit;
        return new AbilityButton("Summon Vexes", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/vex.png"), hotkey, () -> {
            if (evokerUnit.getCastSummonVexesGoal() != null) {
                return evokerUnit.getCastSummonVexesGoal().isCasting() || this.isAutocasting(unit);
            }
            return false;
        }, () -> !ResearchClient.hasResearch(ProductionItems.RESEARCH_EVOKER_VEXES), () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.CAST_SUMMON_VEXES), () -> this.toggleAutocast(unit), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.summon_vexes", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.summon_vexes.tooltip1", (Object[])new Object[]{60}), (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.summon_vexes.tooltip2", (Object[])new Object[]{3}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.summon_vexes.tooltip3", (Object[])new Object[]{30}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.autocast", (Object[])new Object[0]), (Style)Style.f_131099_)), (Ability)this, unit);
    }

    @Override
    public void setCooldown(float cooldown, Unit unit) {
        EvokerUnit evokerUnit = (EvokerUnit)unit;
        if (evokerUnit.hasVigorEnchant()) {
            cooldown *= 0.7f;
        }
        super.setCooldown(cooldown, unit);
    }

    @Override
    public void setToMaxCooldown(Unit unit) {
        EvokerUnit evokerUnit = (EvokerUnit)unit;
        if (evokerUnit.hasVigorEnchant()) {
            this.setCooldown((int)(this.cooldownMax * 0.7f), unit);
        } else {
            this.setCooldown(this.cooldownMax, unit);
        }
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((EvokerUnit)unitUsing).getCastSummonVexesGoal().setAbility(this);
        ((EvokerUnit)unitUsing).getCastSummonVexesGoal().startCasting();
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((EvokerUnit)unitUsing).getCastSummonVexesGoal().setAbility(this);
        ((EvokerUnit)unitUsing).getCastSummonVexesGoal().startCasting();
    }
}

