/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.piglin;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ThrowTNT
extends HeroAbility {
    public static final int RANGE = 12;
    public float explosionPower = 2.0f;
    public static int LESS_COOLDOWN_PER_100_RESOURCES = 132;
    public static int MANA_REFUND_PER_100_RESOURCES = 5;

    public ThrowTNT() {
        super(3, 40, UnitAction.THROW_TNT, 400, 12.0f, 0.0f, true);
    }

    @Override
    public boolean isCasting(Unit unit) {
        PiglinMerchantUnit piglinMerchantUnit;
        GenericTargetedSpellGoal goal;
        if (unit instanceof PiglinMerchantUnit && (goal = (piglinMerchantUnit = (PiglinMerchantUnit)unit).getCastTNTGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public boolean rankUp(HeroUnit hero) {
        if (super.rankUp(hero)) {
            this.updateStatsForRank(hero);
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank(HeroUnit hero) {
        if (this.getRank(hero) == 1) {
            this.explosionPower = 2.0f;
        } else if (this.getRank(hero) == 2) {
            this.explosionPower = 3.0f;
        } else if (this.getRank(hero) == 3) {
            this.explosionPower = 4.0f;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Throw TNT", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/tnt.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.THROW_TNT, () -> this.getRank(hero) == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.THROW_TNT), null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Throw TNT", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/tnt.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt", (Object[])new Object[0]) + " " + this.rankString(hero), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.stats", (Object[])new Object[]{Math.round(this.explosionPower * 6.67f), Float.valueOf(this.cooldownMax / 20.0f), 12, this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.tooltip2", (Object[])new Object[]{LESS_COOLDOWN_PER_100_RESOURCES / 20, MANA_REFUND_PER_100_RESOURCES})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.tooltip2", (Object[])new Object[]{LESS_COOLDOWN_PER_100_RESOURCES / 20, MANA_REFUND_PER_100_RESOURCES})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.rank1", (Object[])new Object[0]), this.getRank(hero) == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.rank2", (Object[])new Object[0]), this.getRank(hero) == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.rank3", (Object[])new Object[0]), this.getRank(hero) == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((PiglinMerchantUnit)unitUsing).getCastTNTGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastTNTGoal().setTarget(targetBp);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((PiglinMerchantUnit)unitUsing).getCastTNTGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastTNTGoal().setTarget(targetEntity);
    }
}

