/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.villager;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;

public class BattleRagePassive
extends HeroAbility {
    public float maxHpRegen = 1.2f;
    public float manaPerDmgTaken = 0.4f;

    public BattleRagePassive() {
        super(3, 0, UnitAction.NONE, 0, 0.0f, 0.0f, false);
    }

    @Override
    public boolean rankUp(HeroUnit hero) {
        if (super.rankUp(hero)) {
            this.updateStatsForRank(hero);
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank(HeroUnit hero) {
        if (this.getRank(hero) == 1) {
            this.maxHpRegen = 1.2f;
            this.manaPerDmgTaken = 0.4f;
        } else if (this.getRank(hero) == 2) {
            this.maxHpRegen = 1.8f;
            this.manaPerDmgTaken = 0.6f;
        } else if (this.getRank(hero) == 3) {
            this.maxHpRegen = 2.4f;
            this.manaPerDmgTaken = 0.8f;
        }
    }

    public double getHpRegen(HeroUnit hero) {
        float healthRatio = 1.0f - ((LivingEntity)hero).m_21223_() / ((LivingEntity)hero).m_21233_();
        return MyMath.round(healthRatio * this.maxHpRegen, 1);
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Battle Rage", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/redstone_block.png"), hotkey, () -> false, () -> this.getRank(hero) == 0, () -> true, null, null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Battle Rage", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/redstone_block.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage", (Object[])new Object[0]) + " " + this.rankString(hero), true), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage.tooltip1", (Object[])new Object[]{Float.valueOf(this.maxHpRegen)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage.tooltip2", (Object[])new Object[]{Float.valueOf(this.manaPerDmgTaken)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage.tooltip3", (Object[])new Object[]{this.getHpRegen(hero)})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage.tooltip1", (Object[])new Object[]{Float.valueOf(this.maxHpRegen)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage.tooltip2", (Object[])new Object[]{Float.valueOf(this.manaPerDmgTaken)})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage.rank1", (Object[])new Object[0]), this.getRank(hero) == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage.rank2", (Object[])new Object[0]), this.getRank(hero) == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.battle_rage.rank3", (Object[])new Object[0]), this.getRank(hero) == 2));
    }
}

