/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingAction;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.building.production.ActiveProduction;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class BuildingClientboundPacket {
    public static final ResourceLocation EMPTY = ResourceLocation.fromNamespaceAndPath((String)"", (String)"");
    public BuildingAction action;
    public BlockPos buildingPos;
    public ResourceLocation itemKey;
    public String itemName;
    public Rotation rotation;
    public String ownerName;
    public int blocksPlaced;
    public int numQueuedBlocks;
    public boolean isDiagonalBridge;
    public int upgradeLevel;
    public boolean isBuilt;
    public PortalPlacement.PortalType portalType;
    public BlockPos portalDestination;
    public boolean forPlayerLoggingIn;

    public static void placeBuilding(BlockPos buildingPos, Building building, Rotation rotation, String ownerName, int numQueuedBlocks, boolean isDiagonalBridge, int upgradeLevel, boolean isBuilt, PortalPlacement.PortalType portalType, BlockPos portalDestination, boolean forPlayerLoggingIn) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(building instanceof CustomBuilding ? BuildingAction.PLACE_CUSTOM : BuildingAction.PLACE, building instanceof CustomBuilding ? EMPTY : ReignOfNetherRegistries.BUILDING.m_7981_((Object)building), building.name, buildingPos, rotation, ownerName, 0, numQueuedBlocks, isDiagonalBridge, upgradeLevel, isBuilt, portalType, portalDestination, forPlayerLoggingIn));
    }

    public static void syncBuilding(BlockPos buildingPos, int blocksPlaced, String ownerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.SYNC_BLOCKS_AND_OWNER, EMPTY, "", buildingPos, Rotation.NONE, ownerName, blocksPlaced, 0, false, 0, false, PortalPlacement.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void startProduction(BlockPos buildingPos, ProductionItem item) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.START_PRODUCTION, ReignOfNetherRegistries.PRODUCTION_ITEM.m_7981_((Object)item), "", buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, PortalPlacement.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void cancelProduction(BlockPos buildingPos, ProductionItem item, boolean frontItem) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(frontItem ? BuildingAction.CANCEL_PRODUCTION : BuildingAction.CANCEL_BACK_PRODUCTION, ReignOfNetherRegistries.PRODUCTION_ITEM.m_7981_((Object)item), "", buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, PortalPlacement.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void changePortal(BlockPos buildingPos, PortalPlacement.PortalType type) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.CHANGE_PORTAL, EMPTY, "", buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, type, new BlockPos(0, 0, 0), false));
    }

    public static void clearQueue(BlockPos buildingPos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.CLEAR_PRODUCTION, EMPTY, "", buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, PortalPlacement.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void completeProduction(BlockPos buildingPos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.COMPLETE_PRODUCTION, EMPTY, "", buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, PortalPlacement.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public BuildingClientboundPacket(BuildingAction action, ResourceLocation itemKey, String itemName, BlockPos buildingPos, Rotation rotation, String ownerName, int blocksPlaced, int numQueuedBlocks, boolean isDiagonalBridge, int upgradeLevel, boolean isBuilt, PortalPlacement.PortalType portalType, BlockPos portalDestination, boolean forPlayerLoggingIn) {
        this.action = action;
        this.itemKey = itemKey;
        this.itemName = itemName;
        this.buildingPos = buildingPos;
        this.rotation = rotation;
        this.ownerName = ownerName;
        this.blocksPlaced = blocksPlaced;
        this.numQueuedBlocks = numQueuedBlocks;
        this.isDiagonalBridge = isDiagonalBridge;
        this.isBuilt = isBuilt;
        this.upgradeLevel = upgradeLevel;
        this.portalType = portalType;
        this.portalDestination = portalDestination;
        this.forPlayerLoggingIn = forPlayerLoggingIn;
    }

    public BuildingClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (BuildingAction)buffer.m_130066_(BuildingAction.class);
        this.itemKey = buffer.m_130281_();
        this.itemName = buffer.m_130277_();
        this.buildingPos = buffer.m_130135_();
        this.rotation = (Rotation)buffer.m_130066_(Rotation.class);
        this.ownerName = buffer.m_130277_();
        this.blocksPlaced = buffer.readInt();
        this.numQueuedBlocks = buffer.readInt();
        this.isDiagonalBridge = buffer.readBoolean();
        this.isBuilt = buffer.readBoolean();
        this.upgradeLevel = buffer.readInt();
        this.portalType = (PortalPlacement.PortalType)buffer.m_130066_(PortalPlacement.PortalType.class);
        this.portalDestination = buffer.m_130135_();
        this.forPlayerLoggingIn = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130085_(this.itemKey);
        buffer.m_130070_(this.itemName);
        buffer.m_130064_(this.buildingPos);
        buffer.m_130068_((Enum)this.rotation);
        buffer.m_130070_(this.ownerName);
        buffer.writeInt(this.blocksPlaced);
        buffer.writeInt(this.numQueuedBlocks);
        buffer.writeBoolean(this.isDiagonalBridge);
        buffer.writeBoolean(this.isBuilt);
        buffer.writeInt(this.upgradeLevel);
        buffer.m_130068_((Enum)this.portalType);
        buffer.m_130064_(this.portalDestination);
        buffer.writeBoolean(this.forPlayerLoggingIn);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BuildingPlacement building = null;
            if (this.action != BuildingAction.PLACE && this.action != BuildingAction.PLACE_CUSTOM && (building = BuildingUtils.findBuilding(true, this.buildingPos)) == null) {
                if (this.action == BuildingAction.SYNC_BLOCKS_AND_OWNER) {
                    BuildingServerboundPacket.requestReplacement(this.buildingPos);
                }
                return;
            }
            switch (this.action) {
                case PLACE: {
                    BuildingClientEvents.placeBuilding((Building)ReignOfNetherRegistries.BUILDING.m_7745_(this.itemKey), this.buildingPos, this.rotation, this.ownerName, this.numQueuedBlocks, this.isDiagonalBridge, this.upgradeLevel, this.isBuilt, this.portalType, this.portalDestination, this.forPlayerLoggingIn);
                    break;
                }
                case PLACE_CUSTOM: {
                    BuildingClientEvents.placeBuilding(CustomBuildingClientEvents.getCustomBuilding(this.itemName), this.buildingPos, this.rotation, this.ownerName, this.numQueuedBlocks, this.isDiagonalBridge, this.upgradeLevel, this.isBuilt, this.portalType, this.portalDestination, this.forPlayerLoggingIn);
                    break;
                }
                case SYNC_BLOCKS_AND_OWNER: {
                    BuildingClientEvents.syncBuilding(building, this.blocksPlaced, this.ownerName);
                    break;
                }
                case START_PRODUCTION: {
                    ((ProductionPlacement)building).startProductionItem((ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(this.itemKey));
                    break;
                }
                case CANCEL_PRODUCTION: {
                    ((ProductionPlacement)building).cancelProductionItem((ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(this.itemKey), true);
                    break;
                }
                case CANCEL_BACK_PRODUCTION: {
                    ((ProductionPlacement)building).cancelProductionItem((ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(this.itemKey), false);
                    break;
                }
                case CHANGE_PORTAL: {
                    if (!(building instanceof PortalPlacement)) break;
                    PortalPlacement portal = (PortalPlacement)building;
                    portal.changeStructure(this.portalType);
                    break;
                }
                case CLEAR_PRODUCTION: {
                    if (!(building instanceof ProductionPlacement)) break;
                    ProductionPlacement pBuilding = (ProductionPlacement)building;
                    if (pBuilding.productionQueue.isEmpty()) break;
                    ActiveProduction pItem = pBuilding.productionQueue.get(0);
                    if (!pItem.completed) {
                        pItem.completed = true;
                        pItem.item.onComplete.accept(pBuilding.level, pBuilding);
                    }
                    pBuilding.productionQueue.clear();
                    break;
                }
                case COMPLETE_PRODUCTION: {
                    if (!(building instanceof ProductionPlacement)) break;
                    ProductionPlacement pBuilding = (ProductionPlacement)building;
                    if (pBuilding.productionQueue.isEmpty()) break;
                    ActiveProduction pItem = pBuilding.productionQueue.get(0);
                    if (!pItem.completed) {
                        pItem.completed = true;
                        pItem.item.onComplete.accept(pBuilding.level, pBuilding);
                    }
                    pBuilding.productionQueue.remove(pItem);
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

