/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientboundPacket;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingSave;
import com.solegendary.reignofnether.building.BuildingSaveData;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.NetherZoneSaveData;
import com.solegendary.reignofnether.building.buildings.monsters.Laboratory;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.building.buildings.placements.BridgePlacement;
import com.solegendary.reignofnether.building.buildings.placements.DungeonPlacement;
import com.solegendary.reignofnether.building.buildings.placements.FlameSanctuaryPlacement;
import com.solegendary.reignofnether.building.buildings.placements.IronGolemPlacement;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.buildings.villagers.Castle;
import com.solegendary.reignofnether.building.buildings.villagers.Library;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingServerEvents;
import com.solegendary.reignofnether.fogofwar.FrozenChunkClientboundPacket;
import com.solegendary.reignofnether.nether.NetherBlocks;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BuildingServerEvents {
    private static final int BUILDING_SYNC_TICKS_MAX = 20;
    private static int buildingSyncTicks = 20;
    private static final int TNT_BUILDING_BASE_DAMAGE = 20;
    private static final int MAX_SCAFFOLD_DEPTH = 5;
    private static ServerLevel serverLevel = null;
    private static final ArrayList<BuildingPlacement> buildings = new ArrayList();
    public static final ArrayList<NetherZone> netherZones = new ArrayList();
    public static final Random random = new Random();
    private static final int SAVE_TICKS_MAX = 600;
    private static int saveTicks = 0;
    private static final float MIN_NETHER_BLOCKS_PERCENT = 0.8f;

    public static ServerLevel getServerLevel() {
        return serverLevel;
    }

    public static ArrayList<BuildingPlacement> getBuildings() {
        return buildings;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent evt) {
        ServerLevel level;
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (++saveTicks >= 600 && (level = evt.getServer().m_129880_(Level.f_46428_)) != null) {
            BuildingServerEvents.saveBuildings(level);
            saveTicks = 0;
        }
    }

    public static void saveBuildings(ServerLevel level) {
        BuildingSaveData buildingData = BuildingSaveData.getInstance((LevelAccessor)serverLevel);
        buildingData.buildings.clear();
        BuildingServerEvents.getBuildings().forEach(b -> {
            BlockPos blockPos;
            PortalPlacement portal;
            PortalPlacement.PortalType portalType = null;
            if (b instanceof PortalPlacement) {
                portal = (PortalPlacement)b;
                portalType = portal.getPortalType();
            }
            ArrayList<BuildingSave> arrayList = buildingData.buildings;
            BlockPos blockPos2 = b.originPos;
            Building building = b.getBuilding();
            String string = b.ownerName;
            Rotation rotation = b.rotation;
            if (b instanceof ProductionPlacement) {
                ProductionPlacement pb = (ProductionPlacement)b;
                blockPos = pb.getFinalRallyPoint();
            } else {
                blockPos = b.originPos;
            }
            arrayList.add(new BuildingSave(blockPos2, (Level)level, building, string, rotation, blockPos, b.isDiagonalBridge, b.isBuilt, b.getUpgradeLevel(), portalType, b instanceof PortalPlacement && (portal = (PortalPlacement)b).hasDestination() ? portal.destination : new BlockPos(0, 0, 0)));
        });
        buildingData.save();
        level.m_8895_().m_78151_();
    }

    public static void saveNetherZones(ServerLevel level) {
        NetherZoneSaveData netherData = NetherZoneSaveData.getInstance((LevelAccessor)level);
        netherData.netherZones.clear();
        netherData.netherZones.addAll(netherZones);
        netherData.save();
        level.m_8895_().m_78151_();
    }

    @SubscribeEvent
    public static void loadBuildingsAndNetherZones(ServerStartedEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            CustomBuildingServerEvents.loadBuildings(level);
            BuildingSaveData buildingData = BuildingSaveData.getInstance((LevelAccessor)level);
            NetherZoneSaveData netherData = NetherZoneSaveData.getInstance((LevelAccessor)level);
            ArrayList placedNZs = new ArrayList();
            BuildingServerEvents.getBuildings().clear();
            buildingData.buildings.forEach(b -> {
                BuildingPlacement building = BuildingUtils.getNewBuildingPlacement(b.building, (Level)level, b.originPos, b.rotation, b.ownerName, b.isDiagonalBridge);
                if (building != null) {
                    building.isBuilt = b.isBuilt;
                    BuildingServerEvents.getBuildings().add(building);
                    if (building instanceof ProductionPlacement) {
                        ProductionPlacement pb = (ProductionPlacement)building;
                        pb.setRallyPoint(b.rallyPoint);
                    }
                    if (b.upgradeLevel > 0) {
                        if (building.getBuilding() instanceof Castle) {
                            building.changeStructure("castle_with_flag");
                        } else if (building.getBuilding() instanceof Laboratory) {
                            building.changeStructure("laboratory_lightning");
                        } else if (building instanceof PortalPlacement) {
                            PortalPlacement portal = (PortalPlacement)building;
                            if (!(building.getBuilding() instanceof NeutralTransportPortal)) {
                                portal.changeStructure(b.portalType);
                            }
                            if (b.portalDestination != null && !b.portalDestination.equals((Object)new BlockPos(0, 0, 0))) {
                                portal.destination = b.portalDestination;
                            }
                        } else if (building.getBuilding() instanceof Library) {
                            building.changeStructure("library_grand");
                        } else if (building instanceof BeaconPlacement) {
                            BeaconPlacement beacon = (BeaconPlacement)building;
                            beacon.changeStructure(b.upgradeLevel);
                        }
                    }
                    if (building instanceof NetherConvertingBuilding) {
                        NetherConvertingBuilding ncb = (NetherConvertingBuilding)((Object)building);
                        for (NetherZone nz : netherData.netherZones) {
                            if (!building.isPosInsideBuilding(nz.getOrigin())) continue;
                            ncb.setNetherZone(nz);
                            placedNZs.add(nz.getOrigin());
                            ReignOfNether.LOGGER.info("loaded netherzone for: " + b.building.name + "|" + b.originPos);
                            break;
                        }
                    }
                    ReignOfNether.LOGGER.info("loaded building in serverevents: " + b.building.name + "|" + b.originPos);
                }
            });
            netherData.netherZones.forEach(nz -> {
                if (!placedNZs.contains(nz.getOrigin())) {
                    netherZones.add((NetherZone)nz);
                    ReignOfNether.LOGGER.info("loaded orphaned netherzone: " + nz.getOrigin());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            BuildingServerEvents.saveNetherZones(level);
            BuildingServerEvents.saveBuildings(level);
        }
    }

    @Nullable
    public static BuildingPlacement placeBuilding(Building building, BlockPos pos, Rotation rotation, String ownerName, int[] builderUnitIds, boolean queue, boolean isDiagonalBridge) {
        BuildingPlacement newBuilding = BuildingUtils.getNewBuildingPlacement(building, (Level)serverLevel, pos, rotation, ownerName, isDiagonalBridge);
        boolean buildingExists = buildings.stream().anyMatch(b -> b.originPos.equals((Object)pos));
        if (newBuilding != null && !buildingExists) {
            if (newBuilding instanceof IronGolemPlacement) {
                int currentPop = UnitServerEvents.getCurrentPopulation(serverLevel, ownerName);
                int popSupply = BuildingServerEvents.getTotalPopulationSupply(ownerName);
                boolean canAffordPop = ResourcesServerEvents.resourcesList.stream().anyMatch(r -> r.ownerName.equals(ownerName) && currentPop + ResourceCosts.IRON_GOLEM.population <= popSupply);
                if (!canAffordPop) {
                    ResourcesClientboundPacket.warnInsufficientPopulation(ownerName);
                    return null;
                }
            }
            if (newBuilding.canAfford(ownerName)) {
                if (((GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRuleRegistrar.SLANTED_BUILDING)).m_46223_() && !(newBuilding instanceof BridgePlacement)) {
                    BuildingUtils.clearBuildingArea(newBuilding);
                }
                buildings.add(newBuilding);
                newBuilding.forceChunk(true);
                int minY = BuildingUtils.getMinCorner(newBuilding.blocks).m_123342_();
                if (!(newBuilding instanceof BridgePlacement)) {
                    for (BuildingBlock block2 : newBuilding.blocks) {
                        if (block2.getBlockPos().m_123342_() != minY || block2.getBlockState().m_60795_()) continue;
                        BuildingServerEvents.placeScaffoldingUnder(block2, newBuilding);
                    }
                }
                newBuilding.blocks.stream().filter(block -> block.getBlockPos().m_123342_() <= minY + (newBuilding.getBuilding().foundationYLayers - 1) && newBuilding.getBuilding().startingBlockTypes.contains(block.getBlockState().m_60734_())).forEach(newBuilding::addToBlockPlaceQueue);
                BuildingClientboundPacket.placeBuilding(pos, building, rotation, ownerName, newBuilding.blockPlaceQueue.size(), isDiagonalBridge, 0, false, PortalPlacement.PortalType.BASIC, pos, false);
                ResourcesServerEvents.addSubtractResources(new Resources(ownerName, -newBuilding.getBuilding().cost.food, -newBuilding.getBuilding().cost.wood, -newBuilding.getBuilding().cost.ore));
                if (ownerName.isEmpty() || ownerName.equals("Enemy")) {
                    newBuilding.selfBuilding = true;
                }
                BuildingServerEvents.assignBuilderUnits(builderUnitIds, queue, newBuilding);
                UnitServerEvents.getAllUnits().stream().filter(entity -> {
                    Unit unit;
                    return entity instanceof Unit && (unit = (Unit)entity).getOwnerName().equals(ownerName) && newBuilding.isPosInsideBuilding(entity.m_20097_().m_7494_().m_7494_()) && (unit.getMoveGoal().getMoveTarget() == null || newBuilding.isPosInsideBuilding(unit.getMoveGoal().getMoveTarget()));
                }).forEach(entity -> BuildingServerEvents.moveNonBuildersAwayFromBuildingFoundations(entity, builderUnitIds, newBuilding));
            } else if (!PlayerServerEvents.isBot(ownerName)) {
                BuildingServerEvents.warnInsufficientResources(newBuilding);
            }
            if (SandboxServer.isAnyoneASandboxPlayer() && builderUnitIds.length == 0) {
                newBuilding.getBuilding().shouldDestroyOnReset = false;
                BuildingServerEvents.saveBuildings(BuildingServerEvents.getServerLevel());
            }
            return newBuilding;
        }
        return null;
    }

    private static void placeScaffoldingUnder(BuildingBlock block, BuildingPlacement newBuilding) {
        BlockPos bpBelow;
        BlockPos basePos = block.getBlockPos();
        int yBelow = 0;
        while (yBelow > -5 && !MiscUtil.isSolidBlocking(newBuilding.level, bpBelow = basePos.m_7918_(0, --yBelow, 0))) {
        }
        if (yBelow <= -5) {
            return;
        }
        for (int y = yBelow + 1; y < 0; ++y) {
            BlockPos scaffoldPos = basePos.m_7918_(0, y, 0);
            BuildingBlock scaffold = new BuildingBlock(scaffoldPos, Blocks.f_50616_.m_49966_());
            newBuilding.getScaffoldBlocks().add(scaffold);
            newBuilding.addToBlockPlaceQueue(scaffold);
        }
    }

    private static void assignBuilderUnits(int[] builderUnitIds, boolean queue, BuildingPlacement newBuilding) {
        for (int id : builderUnitIds) {
            Entity entity = serverLevel.m_6815_(id);
            if (!(entity instanceof WorkerUnit)) continue;
            WorkerUnit workerUnit = (WorkerUnit)entity;
            if (queue) {
                if (workerUnit.getBuildRepairGoal().queuedBuildings.isEmpty()) {
                    ((Unit)entity).resetBehaviours();
                    WorkerUnit.resetBehaviours(workerUnit);
                }
                workerUnit.getBuildRepairGoal().queuedBuildings.add(newBuilding);
                if (workerUnit.getBuildRepairGoal().getBuildingTarget() != null) continue;
                workerUnit.getBuildRepairGoal().startNextQueuedBuilding();
                continue;
            }
            ((Unit)entity).resetBehaviours();
            WorkerUnit.resetBehaviours(workerUnit);
            workerUnit.getBuildRepairGoal().setBuildingTarget(newBuilding);
        }
    }

    private static void warnInsufficientResources(BuildingPlacement newBuilding) {
        ResourcesClientboundPacket.warnInsufficientResources(newBuilding.ownerName, ResourcesServerEvents.canAfford(newBuilding.ownerName, ResourceName.FOOD, newBuilding.getBuilding().cost.food), ResourcesServerEvents.canAfford(newBuilding.ownerName, ResourceName.WOOD, newBuilding.getBuilding().cost.wood), ResourcesServerEvents.canAfford(newBuilding.ownerName, ResourceName.ORE, newBuilding.getBuilding().cost.ore));
    }

    private static void moveNonBuildersAwayFromBuildingFoundations(LivingEntity entity, int[] builderUnitIds, BuildingPlacement newBuilding) {
        if (Arrays.stream(builderUnitIds).noneMatch(id -> id == entity.m_19879_())) {
            UnitServerEvents.addActionItem(((Unit)entity).getOwnerName(), UnitAction.MOVE, -1, new int[]{entity.m_19879_()}, newBuilding.getClosestGroundPos(entity.m_20097_(), 2), new BlockPos(0, 0, 0));
        }
    }

    public static void cancelBuilding(BuildingPlacement building, String playerName) {
        NetherConvertingBuilding nb;
        if (building == null) {
            return;
        }
        if (building.isBuilt && !SandboxServer.isSandboxPlayer(playerName) && BuildingUtils.getTotalCompletedBuildingsOwned(false, building.ownerName) == 1) {
            return;
        }
        buildings.remove(building);
        if (building instanceof NetherConvertingBuilding && (nb = (NetherConvertingBuilding)((Object)building)).getZone() != null) {
            nb.getZone().startRestoring();
            BuildingServerEvents.saveNetherZones(serverLevel);
        }
        FrozenChunkClientboundPacket.setBuildingDestroyedServerside(building.originPos);
        if (!building.isBuilt || SurvivalServerEvents.isEnabled()) {
            float buildPercent = building.getBlocksPlacedPercent();
            int food = Math.round((float)building.getBuilding().cost.food * (1.0f - buildPercent));
            int wood = Math.round((float)building.getBuilding().cost.wood * (1.0f - buildPercent));
            int ore = Math.round((float)building.getBuilding().cost.ore * (1.0f - buildPercent));
            if (building.isBuilt && SurvivalServerEvents.isEnabled()) {
                food = Math.round((float)building.getBuilding().cost.food * 0.5f * buildPercent);
                wood = Math.round((float)building.getBuilding().cost.wood * 0.5f * buildPercent);
                ore = Math.round((float)building.getBuilding().cost.ore * 0.5f * buildPercent);
            }
            if (food > 0 || wood > 0 || ore > 0) {
                Resources res = new Resources(building.ownerName, food, wood, ore);
                ResourcesServerEvents.addSubtractResources(res);
                ResourcesClientboundPacket.showFloatingText(res, building.centrePos);
            }
        }
        building.destroy((ServerLevel)building.getLevel());
    }

    public static int getTotalPopulationSupply(String ownerName) {
        if (ResearchServerEvents.playerHasCheat(ownerName, "foodforthought")) {
            return UnitServerEvents.maxPopulation;
        }
        int totalPopulationSupply = 0;
        for (BuildingPlacement building : buildings) {
            if (!building.ownerName.equals(ownerName) || !building.isBuilt) continue;
            totalPopulationSupply += building.getBuilding().cost.population;
        }
        return Math.min(UnitServerEvents.maxPopulation, totalPopulationSupply);
    }

    public static Relationship getUnitToBuildingRelationship(Unit unit, BuildingPlacement building) {
        if (unit.getOwnerName().equals(building.ownerName)) {
            return Relationship.OWNED;
        }
        return Relationship.HOSTILE;
    }

    /*
     * Unable to fully structure code
     */
    private static void syncBuildingPlacements() {
        for (BuildingPlacement building : BuildingServerEvents.buildings) {
            v0 = building.originPos;
            v1 = building.getBuilding();
            v2 = building.rotation;
            v3 = building.ownerName;
            v4 = building.blockPlaceQueue.size();
            if (!(building instanceof BridgePlacement)) ** GOTO lbl-1000
            bridge = (BridgePlacement)building;
            if (bridge.isDiagonalBridge) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            v6 = building.getUpgradeLevel();
            v7 = building.isBuilt;
            if (building instanceof PortalPlacement) {
                p = (PortalPlacement)building;
                v8 = p.getPortalType();
            } else {
                v8 = PortalPlacement.PortalType.BASIC;
            }
            BuildingClientboundPacket.placeBuilding(v0, v1, v2, v3, v4, v5, v6, v7, v8, building instanceof PortalPlacement != false && (p = (PortalPlacement)building).hasDestination() != false ? p.destination : new BlockPos(0, 0, 0), true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void syncBuildingPlacement(BlockPos pos) {
        block4: {
            var1_1 = BuildingServerEvents.buildings.iterator();
            if (!var1_1.hasNext()) break block4;
            building = var1_1.next();
            if (!building.originPos.equals((Object)pos)) break block4;
            v0 = building.originPos;
            v1 = building.getBuilding();
            v2 = building.rotation;
            v3 = building.ownerName;
            v4 = building.blockPlaceQueue.size();
            if (!(building instanceof BridgePlacement)) ** GOTO lbl-1000
            bridge = (BridgePlacement)building;
            if (bridge.isDiagonalBridge) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            v6 = building.getUpgradeLevel();
            v7 = building.isBuilt;
            if (building instanceof PortalPlacement) {
                p = (PortalPlacement)building;
                v8 = p.getPortalType();
            } else {
                v8 = PortalPlacement.PortalType.BASIC;
            }
            BuildingClientboundPacket.placeBuilding(v0, v1, v2, v3, v4, v5, v6, v7, v8, building instanceof PortalPlacement != false && (p = (PortalPlacement)building).hasDestination() != false ? p.destination : new BlockPos(0, 0, 0), true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (!PlayerServerEvents.rtsSyncingEnabled) {
            return;
        }
        MinecraftServer server = evt.getEntity().m_9236_().m_7654_();
        if (server == null || !server.m_6982_()) {
            CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS).execute(BuildingServerEvents::syncBuildingPlacements);
        } else {
            BuildingServerEvents.syncBuildingPlacements();
        }
    }

    @SubscribeEvent
    public static void onPlayerBlockBreak(BlockEvent.BreakEvent evt) {
        if (!evt.getLevel().m_5776_()) {
            for (BuildingPlacement building : buildings) {
                if (!building.isPosPartOfBuilding(evt.getPos(), true)) continue;
                building.onBlockBreak((ServerLevel)evt.getLevel(), evt.getPos(), true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(MobSpawnEvent.FinalizeSpawn evt) {
        if (evt.getSpawnType() == MobSpawnType.SPAWNER && evt.getSpawner() != null && evt.getSpawner().getSpawnerBlockEntity() != null) {
            BlockEntity be = evt.getSpawner().getSpawnerBlockEntity();
            BlockPos bp = evt.getSpawner().getSpawnerBlockEntity().m_58899_();
            if (BuildingUtils.findBuilding(false, bp) instanceof DungeonPlacement || BuildingUtils.findBuilding(false, bp) instanceof FlameSanctuaryPlacement) {
                evt.getEntity().m_146870_();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || evt.level.m_5776_() || evt.level.m_46472_() != Level.f_46428_) {
            return;
        }
        serverLevel = (ServerLevel)evt.level;
        if (--buildingSyncTicks <= 0) {
            buildingSyncTicks = 20;
            for (BuildingPlacement buildingPlacement : buildings) {
                BuildingClientboundPacket.syncBuilding(buildingPlacement.originPos, buildingPlacement.getBlocksPlaced(), buildingPlacement.ownerName);
            }
        }
        List<BuildingPlacement> buildingsToDestroy = buildings.stream().filter(BuildingPlacement::shouldBeDestroyed).toList();
        buildings.removeIf(b -> {
            if (b.shouldBeDestroyed()) {
                NetherConvertingBuilding nb;
                if (b instanceof NetherConvertingBuilding && (nb = (NetherConvertingBuilding)((Object)b)).getZone() != null) {
                    nb.getZone().startRestoring();
                    BuildingServerEvents.saveNetherZones(serverLevel);
                }
                FrozenChunkClientboundPacket.setBuildingDestroyedServerside(b.originPos);
                return true;
            }
            return false;
        });
        for (BuildingPlacement building : buildingsToDestroy) {
            building.destroy(serverLevel);
        }
        for (BuildingPlacement building : buildings) {
            building.tick((Level)serverLevel);
        }
        for (NetherZone netherConversionZone : netherZones) {
            netherConversionZone.tick(serverLevel);
        }
        int n = netherZones.size();
        netherZones.removeIf(NetherZone::isDone);
        int nzSizeAfter = netherZones.size();
        if (n != nzSizeAfter) {
            BuildingServerEvents.saveNetherZones(serverLevel);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate evt) {
        Explosion exp = evt.getExplosion();
        GhastUnit ghastUnit = null;
        CreeperUnit creeperUnit = null;
        PillagerUnit pillagerUnit = null;
        Entity entity = evt.getExplosion().getExploder();
        if (entity instanceof CreeperUnit) {
            CreeperUnit cUnit;
            creeperUnit = cUnit = (CreeperUnit)entity;
        } else {
            entity = evt.getExplosion().getExploder();
            if (entity instanceof PillagerUnit) {
                PillagerUnit pUnit;
                pillagerUnit = pUnit = (PillagerUnit)entity;
            } else {
                LargeFireball fireball;
                entity = evt.getExplosion().getExploder();
                if (entity instanceof LargeFireball && (entity = (fireball = (LargeFireball)entity).m_19749_()) instanceof GhastUnit) {
                    GhastUnit gUnit;
                    ghastUnit = gUnit = (GhastUnit)entity;
                }
            }
        }
        if (exp.getExploder() == null && exp.getExploder() == null && ghastUnit == null) {
            evt.getAffectedEntities().clear();
        }
        if (creeperUnit != null || ghastUnit != null || pillagerUnit != null || exp.getExploder() instanceof PrimedTnt) {
            HashSet<BuildingPlacement> affectedBuildings = new HashSet<BuildingPlacement>();
            for (BlockPos bp2 : evt.getAffectedBlocks()) {
                BuildingPlacement building = BuildingUtils.findBuilding(false, bp2);
                if (building == null || SurvivalServerEvents.isEnabled() && ghastUnit != null && "Enemy".equals(ghastUnit.getOwnerName()) && "Enemy".equals(building.ownerName)) continue;
                affectedBuildings.add(building);
            }
            for (BuildingPlacement building : affectedBuildings) {
                int atkDmg = 0;
                if (ghastUnit != null) {
                    atkDmg = (int)ghastUnit.getUnitAttackDamage();
                    building.lastAttacker = ghastUnit;
                } else if (creeperUnit != null) {
                    atkDmg = (int)creeperUnit.getUnitAttackDamage();
                    if (creeperUnit.m_7090_()) {
                        atkDmg = (int)((float)atkDmg * 1.7f);
                    }
                    building.lastAttacker = creeperUnit;
                } else if (pillagerUnit != null) {
                    atkDmg = (int)pillagerUnit.getUnitAttackDamage() / 2;
                    building.lastAttacker = pillagerUnit;
                } else if (exp.getExploder() instanceof PrimedTnt) {
                    atkDmg = 20;
                }
                if (atkDmg <= 0) continue;
                if (building instanceof GarrisonableBuilding) {
                    GarrisonableBuilding garr = (GarrisonableBuilding)((Object)building);
                    for (LivingEntity le : garr.getOccupants()) {
                        le.m_6469_(exp.m_46077_(), (float)random.nextInt(atkDmg + 1) / 2.0f);
                    }
                }
                if (building instanceof BridgePlacement) {
                    atkDmg /= 2;
                }
                building.destroyRandomBlocks(atkDmg);
            }
        }
        if (!((GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRuleRegistrar.DO_UNIT_GRIEFING)).m_46223_()) {
            evt.getAffectedBlocks().removeIf(bp -> {
                BlockState bs = evt.getLevel().m_8055_(bp);
                return !(bs.m_60734_() instanceof LeavesBlock) && !(bs.m_60734_() instanceof TntBlock);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent evt) {
        BuildingPlacement building = BuildingUtils.findBuilding(evt.getEntity().m_9236_().m_5776_(), evt.getEntity().m_20097_());
        if (building != null) {
            PortalPlacement portal;
            ServerPlayer player;
            evt.setCanceled(true);
            Entity entity = evt.getEntity();
            if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_5833_() && (AlliancesServerEvents.isAllied(player.m_7755_().getString(), building.ownerName) || building.getBuilding() instanceof NeutralTransportPortal || player.m_7755_().getString().equals(building.ownerName)) && building instanceof PortalPlacement && (portal = (PortalPlacement)building).hasDestination()) {
                player.m_6021_((double)portal.destination.m_123341_(), (double)portal.destination.m_123342_(), (double)portal.destination.m_123343_());
                building.level.m_5594_(null, building.centrePos, SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
                building.level.m_5594_(null, portal.destination, SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onCropTrample(BlockEvent.FarmlandTrampleEvent evt) {
        if (BuildingUtils.isPosInsideAnyBuilding(evt.getEntity().m_9236_().m_5776_(), evt.getPos())) {
            evt.setCanceled(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void replaceClientBuilding(BlockPos buildingPos) {
        if (!PlayerServerEvents.rtsSyncingEnabled) {
            return;
        }
        for (BuildingPlacement building : BuildingServerEvents.buildings) {
            if (!building.originPos.equals((Object)buildingPos)) continue;
            v0 = building.originPos;
            v1 = building.getBuilding();
            v2 = building.rotation;
            v3 = building.ownerName;
            v4 = building.blockPlaceQueue.size();
            if (!(building instanceof BridgePlacement)) ** GOTO lbl-1000
            bridge = (BridgePlacement)building;
            if (bridge.isDiagonalBridge) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            v6 = building.getUpgradeLevel();
            v7 = building.isBuilt;
            if (building instanceof PortalPlacement) {
                p = (PortalPlacement)building;
                v8 = p.getPortalType();
            } else {
                v8 = PortalPlacement.PortalType.BASIC;
            }
            BuildingClientboundPacket.placeBuilding(v0, v1, v2, v3, v4, v5, v6, v7, v8, building instanceof PortalPlacement != false && (p = (PortalPlacement)building).getPortalType() == PortalPlacement.PortalType.TRANSPORT ? p.destination : new BlockPos(0, 0, 0), false);
            return;
        }
    }

    public static boolean isOnNetherBlocks(List<BuildingBlock> blocks, BlockPos originPos, ServerLevel level) {
        int netherBlocksBelow = 0;
        int blocksBelow = 0;
        for (BuildingBlock block : blocks) {
            if (block.getBlockPos().m_123342_() != originPos.m_123342_() + 1 || level == null) continue;
            BlockPos bp = block.getBlockPos();
            BlockState bs = block.getBlockState();
            if (!bs.m_280296_()) continue;
            ++blocksBelow;
            if (!NetherBlocks.isNetherBlock((Level)level, bp.m_7495_())) continue;
            ++netherBlocksBelow;
        }
        if (blocksBelow <= 0) {
            return false;
        }
        return (float)netherBlocksBelow / (float)blocksBelow > 0.8f;
    }

    public static boolean playerHasFinishedBuilding(Building building, String playerName) {
        for (BuildingPlacement bpl : buildings) {
            if (!bpl.getBuilding().isTypeOf(building) || !bpl.isBuilt || !bpl.ownerName.equals(playerName)) continue;
            return true;
        }
        return false;
    }
}

