/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.DarknessProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Mausoleum
extends ProductionBuilding {
    public static final String buildingName = "Mausoleum";
    public static final String structureName = "mausoleum";
    public static final ResourceCost cost = ResourceCosts.MAUSOLEUM;
    public static final int nightRange = 80;
    public static final int nightRangeReduced = 40;
    private final Set<BlockPos> nightBorderBps = new HashSet<BlockPos>();

    public Mausoleum() {
        super(structureName, cost, true);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_152559_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/deepslate_tiles.png");
        this.foundationYLayers = 4;
        this.buildTimeModifier = 0.274f;
        this.canAcceptResources = true;
        this.startingBlockTypes.add(Blocks.f_50069_);
        this.startingBlockTypes.add(Blocks.f_50194_);
        this.startingBlockTypes.add(Blocks.f_50222_);
        this.startingBlockTypes.add(Blocks.f_50194_);
        this.productions.add(ProductionItems.ZOMBIE_VILLAGER, Keybindings.keyQ);
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        int nRange = 80;
        if (level.m_5776_() && BuildingClientEvents.playerHasFinishedBuilding(this, ownerName) || !level.m_5776_() && BuildingServerEvents.playerHasFinishedBuilding(this, ownerName)) {
            nRange = 40;
        }
        return new DarknessProductionBuilding(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), true, nRange, false, true);
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new BuildingPlaceButton(name, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/deepslate_tiles.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.MAUSOLEUM, () -> false, () -> true, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.mausoleum", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPop(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.mausoleum.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.mausoleum.tooltip2", (Object[])new Object[]{80}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.mausoleum.tooltip4", (Object[])new Object[]{40}), (Style)Style.f_131099_)), this);
    }
}

