/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.neutral;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class CapturableBeacon
extends Beacon {
    public static final String buildingName = "The Beacon";
    public static final String structureName = "beacon_t5";
    public static final ResourceCost cost = ResourceCost.Building(0, 0, 0, 0);

    public CapturableBeacon() {
        ((Building)this).structureName = structureName;
        ((Building)this).cost = cost;
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50273_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/netherite_beacon.png");
        this.buildTimeModifier = 1.0f;
        this.capturable = true;
        this.invulnerable = true;
        this.shouldDestroyOnReset = false;
        this.selfBuilding = true;
        this.startingBlockTypes.add(Blocks.f_50721_);
        this.explodeChance = 0.2f;
    }

    @Override
    public ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocksFromNbt(structureName, level);
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        return new BuildingPlaceButton(buildingName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/netherite_beacon.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == this, TutorialClientEvents::isEnabled, () -> BuildingClientEvents.getBuildings().stream().filter(b -> b.getBuilding() instanceof CapturableBeacon).toList().isEmpty(), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.capturable_beacon", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.capturable_beacon.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.capturable_beacon.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.capturable_beacon.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }
}

