/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingPlacement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;

public class FarmPlacement
extends BuildingPlacement {
    private final ArrayList<FarmCropBlock> farmBlocks = new ArrayList();
    private static final int TICK_CROPS_INTERVAL = 10;
    private static final int TPS = 20;
    private static final int STEM_GROW_TICKS = 260;
    private static final int GOURD_GROW_TICKS = 900;
    private static final int CROP_GROW_TICKS = 260;
    private static final int NETHER_WART_GROW_TICKS = 700;
    private static final int ICE_CHECK_TICKS_MAX = 100;
    private int ticksToNextIceCheck = 100;

    public FarmPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
        for (BuildingBlock bb : blocks) {
            if (!List.of(Blocks.f_50093_, Blocks.f_50135_).contains(bb.getBlockState().m_60734_())) continue;
            this.farmBlocks.add(new FarmCropBlock(bb.getBlockPos().m_7494_()));
        }
    }

    private void tickCrops() {
        for (FarmCropBlock farmBlock : this.farmBlocks) {
            BlockState grownState;
            int newAge;
            int age;
            CropBlock cropBlock;
            BlockState bs = this.level.m_8055_(farmBlock.bp);
            Block block = bs.m_60734_();
            if (block instanceof CropBlock && ((cropBlock = (CropBlock)block) == Blocks.f_50092_ || cropBlock == Blocks.f_50249_ || cropBlock == Blocks.f_50250_)) {
                farmBlock.tickAge += 10;
                age = (Integer)bs.m_61143_((Property)BlockStateProperties.f_61409_);
                if (farmBlock.tickAge >= 260) {
                    newAge = Math.min(7, age + 1);
                    grownState = (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(newAge));
                    this.level.m_7731_(farmBlock.bp, grownState, 2);
                    farmBlock.tickAge = 0;
                }
            }
            if (block instanceof StemBlock) {
                StemBlock stemBlock = (StemBlock)block;
                farmBlock.tickAge += 10;
                age = (Integer)bs.m_61143_((Property)BlockStateProperties.f_61409_);
                if (age >= 7 && farmBlock.tickAge >= 900) {
                    this.growGourd(stemBlock, farmBlock.bp);
                    farmBlock.tickAge = 0;
                    continue;
                }
                if (age >= 7 || farmBlock.tickAge < 260) continue;
                newAge = Math.min(7, age + 1);
                grownState = (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(newAge));
                this.level.m_7731_(farmBlock.bp, grownState, 2);
                farmBlock.tickAge = 0;
                continue;
            }
            if (!(block instanceof NetherWartBlock)) continue;
            farmBlock.tickAge += 10;
            age = (Integer)bs.m_61143_((Property)BlockStateProperties.f_61407_);
            if (farmBlock.tickAge < 700) continue;
            newAge = Math.min(3, age + 1);
            grownState = (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(newAge));
            this.level.m_7731_(farmBlock.bp, grownState, 2);
            farmBlock.tickAge = 0;
        }
    }

    private void growGourd(StemBlock stemBlock, BlockPos bp) {
        ArrayList<Direction> dirs = new ArrayList<Direction>(List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST));
        Collections.shuffle(dirs);
        for (Direction dir : dirs) {
            BlockPos bpAdj = bp.m_121945_(dir);
            BlockState bs = this.level.m_8055_(bpAdj.m_7495_());
            if (!this.level.m_46859_(bpAdj) || !bs.canSustainPlant((BlockGetter)this.level, bpAdj.m_7495_(), Direction.UP, (IPlantable)stemBlock.m_57056_()) && !bs.m_60713_(Blocks.f_50093_) && !bs.m_204336_(BlockTags.f_144274_)) continue;
            this.level.m_46597_(bpAdj, stemBlock.m_57056_().m_49966_());
            this.level.m_46597_(bp, (BlockState)stemBlock.m_57056_().m_7810_().m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir));
            return;
        }
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (!tickLevel.m_5776_()) {
            --this.ticksToNextIceCheck;
            if (this.ticksToNextIceCheck <= 0) {
                for (BuildingBlock bb : this.blocks) {
                    if (tickLevel.m_8055_(bb.getBlockPos()).m_60734_() != Blocks.f_50126_) continue;
                    tickLevel.m_46597_(bb.getBlockPos(), Blocks.f_49990_.m_49966_());
                }
                this.ticksToNextIceCheck = 100;
            }
        }
        if (!this.level.m_5776_() && this.tickAge % 10L == 0L) {
            this.tickCrops();
        }
    }

    private class FarmCropBlock {
        public int tickAge = 0;
        public BlockPos bp;

        public FarmCropBlock(BlockPos bp) {
            this.bp = bp;
        }
    }
}

