/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import org.joml.Vector3d;

public class HealingFountainPlacement
extends BuildingPlacement
implements RangeIndicator {
    private final ArrayList<BuildingBlock> waterBlocks;
    public static final int RANGE = 20;
    private final Set<BlockPos> borderBps = new HashSet<BlockPos>();

    public HealingFountainPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
        List<BuildingBlock> wbs = blocks.stream().filter(b -> b.getBlockPos().m_123342_() < this.centrePos.m_123342_() && b.getBlockState().m_60734_() == Blocks.f_49990_).toList();
        this.waterBlocks = new ArrayList<BuildingBlock>(wbs);
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        List<LivingEntity> nearbyEntities = MiscUtil.getEntitiesWithinRange(new Vector3d((double)this.centrePos.m_123341_(), (double)this.centrePos.m_123342_(), (double)this.centrePos.m_123343_()), 20.0f, LivingEntity.class, this.level);
        for (LivingEntity le : nearbyEntities) {
            if (!this.isBuilt || this.tickAgeAfterBuilt % 20L != 0L) continue;
            le.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20, 0));
            le.m_5634_(Math.min(1.0f, le.m_21233_() / 100.0f));
        }
        if (!this.waterBlocks.isEmpty() && this.isBuilt) {
            Collections.shuffle(this.waterBlocks);
            int col = 16262179;
            BlockPos bp = this.waterBlocks.get(0).getBlockPos();
            double d0 = (double)(col >> 16 & 0xFF) / 255.0;
            double d1 = (double)(col >> 8 & 0xFF) / 255.0;
            double d2 = (double)(col >> 0 & 0xFF) / 255.0;
            this.level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)bp.m_123341_(), (double)(bp.m_123342_() + 1), (double)bp.m_123343_(), d0, d1, d2);
        }
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.borderBps.clear();
        this.borderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, 18, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.borderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return true;
    }
}

