/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingAction;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingServerboundPacket;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.text.WordUtils;

public class CustomBuilding
extends Building {
    public Vec3i structureSize;
    public final CompoundTag structureNbt;
    public Set<Block> portraitBlockOptions;

    public CustomBuilding(String structureName, Vec3i structureSize, Block portraitBlock, CompoundTag nbt) {
        super(structureName, ResourceCost.Building(0, 0, 0, 0), false);
        this.name = WordUtils.capitalize((String)structureName.replace("minecraft:", "").replace("reignofnether:", "").replace("_", " "));
        this.structureSize = structureSize;
        this.structureNbt = nbt;
        this.portraitBlock = portraitBlock;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/command_block_front.png");
        this.startingBlockTypes.addAll(BuildingBlockData.getBuildingBlocksFromNbt(this.structureNbt).stream().filter(bb -> bb.getBlockPos().m_123342_() == 0).map(bb -> bb.getBlockState().m_60734_()).toList());
        this.portraitBlockOptions = BuildingBlockData.getBuildingBlocksFromNbt(this.structureNbt).stream().map(bb -> bb.getBlockState().m_60734_()).collect(Collectors.toSet());
    }

    @Override
    public ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocksFromNbt(this.structureNbt);
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        BuildingPlaceButton button = new BuildingPlaceButton(this.name, MiscUtil.getTextureForBlock(this.portraitBlock), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == this, () -> false, () -> true, List.of(MiscUtil.fcs(this.name, true), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings_info.building_menu", (Object[])new Object[0]))), this);
        button.onRightClick = () -> CustomBuildingClientEvents.setCustomBuildingToEdit(this);
        return button;
    }

    public String getPortraitBlockRegistryKey() {
        return BuiltInRegistries.f_256975_.m_7981_((Object)this.portraitBlock).toString();
    }

    public void setIconAndPortrait(String blockRegistryKey) {
        this.portraitBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(blockRegistryKey));
    }

    public void cycleIconAndPortrait(boolean reverse) {
        ArrayList<Block> blockOptions = new ArrayList<Block>(this.portraitBlockOptions.stream().filter(b -> !b.m_49966_().m_60795_()).toList());
        if (reverse) {
            Collections.reverse(blockOptions);
        }
        boolean foundCurrentPortrait = false;
        boolean changedPortrait = false;
        for (Block block : blockOptions) {
            if (foundCurrentPortrait) {
                this.portraitBlock = block;
                changedPortrait = true;
                break;
            }
            if (block != this.portraitBlock) continue;
            foundCurrentPortrait = true;
        }
        if (!changedPortrait) {
            this.portraitBlock = blockOptions.get(0);
        }
        CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_PORTRAIT_BLOCK, this.name, this.getPortraitBlockRegistryKey());
    }
}

