/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingAction;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingServerEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class CustomBuildingServerboundPacket {
    public CustomBuildingAction action;
    public String buildingName;
    public boolean boolValue;
    public int intValue;
    public String strValue;

    public static void deregisterBuilding(String buildingName) {
        PacketHandler.INSTANCE.sendToServer((Object)new CustomBuildingServerboundPacket(CustomBuildingAction.DEREGISTER, buildingName, false, 0, ""));
    }

    public static void customiseBuilding(CustomBuildingAction action, String buildingName, boolean boolValue) {
        PacketHandler.INSTANCE.sendToServer((Object)new CustomBuildingServerboundPacket(action, buildingName, boolValue, 0, ""));
    }

    public static void customiseBuilding(CustomBuildingAction action, String buildingName, int intValue) {
        PacketHandler.INSTANCE.sendToServer((Object)new CustomBuildingServerboundPacket(action, buildingName, false, intValue, ""));
    }

    public static void customiseBuilding(CustomBuildingAction action, String buildingName, String strValue) {
        PacketHandler.INSTANCE.sendToServer((Object)new CustomBuildingServerboundPacket(action, buildingName, false, 0, strValue));
    }

    public CustomBuildingServerboundPacket(CustomBuildingAction action, String buildingName, boolean boolValue, int intValue, String strValue) {
        this.action = action;
        this.buildingName = buildingName;
        this.boolValue = boolValue;
        this.intValue = intValue;
        this.strValue = strValue;
    }

    public CustomBuildingServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (CustomBuildingAction)buffer.m_130066_(CustomBuildingAction.class);
        this.buildingName = buffer.m_130277_();
        this.boolValue = buffer.readBoolean();
        this.intValue = buffer.readInt();
        this.strValue = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.buildingName);
        buffer.writeBoolean(this.boolValue);
        buffer.writeInt(this.intValue);
        buffer.m_130070_(this.strValue);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            if (!SandboxServer.isAnyoneASandboxPlayer()) {
                return;
            }
            CustomBuilding customBuilding = CustomBuildingServerEvents.getCustomBuilding(this.buildingName);
            if (customBuilding != null) {
                switch (this.action) {
                    case DEREGISTER: {
                        CustomBuildingServerEvents.deregisterCustomBuilding(this.buildingName);
                        break;
                    }
                    case SET_PORTRAIT_BLOCK: {
                        customBuilding.setIconAndPortrait(this.strValue);
                        break;
                    }
                    case SET_CAPTURABLE: {
                        customBuilding.capturable = this.boolValue;
                        break;
                    }
                    case SET_INVULNERABLE: {
                        customBuilding.invulnerable = this.boolValue;
                    }
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

