/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.essentialpartnermod.loader;

public class RelocationChecks {
    public static void verifyRelocation() {
        if (RelocationChecks.isDevelopment() || RelocationChecks.isStandalone()) {
            return;
        }
        String originalPackage = "gg;essential;partnermod".replace(";", ".");
        String actualPackage = RelocationChecks.class.getName();
        if ((actualPackage = actualPackage.substring(0, actualPackage.length() - ".loader.RelocationChecks".length())).equals(originalPackage)) {
            RelocationChecks.error();
        }
        if (RelocationChecks.class.getResource("/" + actualPackage.replace('.', '/') + "/container.jarx") == null) {
            RelocationChecks.error();
        }
        if (RelocationChecks.class.getResource("/" + actualPackage.replace('.', '/') + "/EssentialPartnerMod.class") != null) {
            RelocationChecks.error();
        }
    }

    private static boolean isDevelopment() {
        String target = System.getenv("target");
        if (target == null) {
            return false;
        }
        return target.equalsIgnoreCase("fmluserdevclient");
    }

    private static boolean isStandalone() {
        Package pkg = RelocationChecks.class.getPackage();
        if (pkg == null) {
            return false;
        }
        return "EssentialPartnerModIntegration".equals(pkg.getImplementationTitle()) && "ModCore Inc.".equals(pkg.getImplementationVendor());
    }

    private static void error() {
        throw new RuntimeException("The Essential Partner Integration mod has not been relocated properly! Please check the README.");
    }
}

