/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.essentialpartnermod.modal;

import com.solegendary.reignofnether.essentialpartnermod.Draw;
import com.solegendary.reignofnether.essentialpartnermod.Tooltip;
import com.solegendary.reignofnether.essentialpartnermod.modal.ButtonColor;
import net.minecraft.client.Minecraft;

public class ModalButton {
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final ButtonColor color;
    public final String text;
    private final Runnable onClick;
    private String tooltip;

    public ModalButton(int x, int y, int width, int height, ButtonColor color, String text, Runnable onClick) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.text = text;
        this.onClick = onClick;
    }

    public ModalButton(int x, int y, int width, ButtonColor color, String text, Runnable onClick) {
        this(x, y, width, 19, color, text, onClick);
    }

    public void draw(Draw draw) {
        boolean hovered = draw.hovered(this.x, this.y, this.width, this.height);
        draw.rect(this.x + 1, this.y + 1, this.x + 1 + this.width, this.y + 1 + this.height, this.color.getShadowColor(hovered));
        draw.rect(this.x, this.y, this.x + this.width, this.y + this.height, this.color.getHighlightColor(hovered));
        draw.rect(this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1, this.color.getButtonColor(hovered));
        if (!this.text.isEmpty()) {
            int textX = this.x + this.width / 2 - Minecraft.m_91087_().f_91062_.m_92895_(this.text) / 2;
            draw.string(this.text, textX, this.y + 6, -1710619, -16777216);
        }
        if (this.tooltip != null && !this.tooltip.isEmpty() && hovered) {
            Draw.deferred(d -> Tooltip.drawTooltip(d, this.tooltip, Tooltip.Position.ABOVE, this.x, this.y, this.width, this.height));
        }
    }

    public void onClick() {
        this.onClick.run();
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }
}

