/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hero;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hero.HeroAction;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class HeroClientboundPacket {
    HeroAction action;
    int unitId;
    float value;
    int abilityIndex;

    public static void setExperience(int unitId, int value) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HeroClientboundPacket(HeroAction.SET_EXPERIENCE, unitId, value, 0));
    }

    public static void setSkillPoints(int unitId, int value) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HeroClientboundPacket(HeroAction.SET_SKILL_POINTS, unitId, value, 0));
    }

    public static void setCharges(int unitId, int value) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HeroClientboundPacket(HeroAction.SET_CHARGES, unitId, value, 0));
    }

    public static void setAbilityRank(int unitId, int rank, int abilityIndex) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HeroClientboundPacket(HeroAction.SET_ABILITY_RANK, unitId, rank, abilityIndex));
    }

    public static void setMana(int unitId, float value) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HeroClientboundPacket(HeroAction.SET_MANA, unitId, value, 0));
    }

    public static void setMaxMana(int unitId, float value) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HeroClientboundPacket(HeroAction.SET_MAX_MANA, unitId, value, 0));
    }

    public static void activateAbilityClientside(int unitId, int abilityIndex) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HeroClientboundPacket(HeroAction.ACTIVATE_ABILITY_CLIENTSIDE, unitId, 0.0f, abilityIndex));
    }

    public static void deactivateAbilityClientside(int unitId, int abilityIndex) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HeroClientboundPacket(HeroAction.DEACTIVATE_ABILITY_CLIENTSIDE, unitId, 0.0f, abilityIndex));
    }

    public HeroClientboundPacket(HeroAction action, int unitId, float value, int abilityIndex) {
        this.action = action;
        this.unitId = unitId;
        this.value = value;
        this.abilityIndex = abilityIndex;
    }

    public HeroClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (HeroAction)buffer.m_130066_(HeroAction.class);
        this.unitId = buffer.readInt();
        this.value = buffer.readFloat();
        this.abilityIndex = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.writeInt(this.unitId);
        buffer.writeFloat(this.value);
        buffer.writeInt(this.abilityIndex);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            HeroUnit hero = null;
            for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                if (entity.m_19879_() != this.unitId || !(entity instanceof HeroUnit)) continue;
                hero = (HeroUnit)entity;
            }
            if (hero != null) {
                switch (this.action) {
                    case SET_EXPERIENCE: {
                        hero.setExperience((int)this.value);
                        break;
                    }
                    case SET_SKILL_POINTS: {
                        hero.setSkillPoints((int)this.value);
                        break;
                    }
                    case SET_CHARGES: {
                        hero.setChargesFromSaveData((int)this.value);
                        break;
                    }
                    case SET_ABILITY_RANK: {
                        List<HeroAbility> abls = hero.getHeroAbilities();
                        if (abls.size() > this.abilityIndex) {
                            abls.get(this.abilityIndex).setRank(hero, (int)this.value);
                        }
                        for (HeroAbility abl : abls) {
                            abl.updateStatsForRank(hero);
                        }
                        hero.updateAbilityButtons();
                        break;
                    }
                    case SET_MANA: {
                        hero.setMana(this.value);
                        break;
                    }
                    case SET_MAX_MANA: {
                        hero.setMaxMana(this.value);
                        break;
                    }
                    case ACTIVATE_ABILITY_CLIENTSIDE: {
                        hero.activateAbilityClientside(this.abilityIndex);
                        break;
                    }
                    case DEACTIVATE_ABILITY_CLIENTSIDE: {
                        hero.deactivateAbilityClientside(this.abilityIndex);
                    }
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

