/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hero;

import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import java.util.Random;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HeroExperienceOrb
extends ExperienceOrb {
    private int age = 0;
    public static final float RANGE = 20.0f;
    private static final Random RANDOM = new Random();
    private LivingEntity followingHero = null;
    private boolean isNeutral = false;

    public HeroExperienceOrb(EntityType<? extends ExperienceOrb> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static HeroExperienceOrb newOrb(Level pLevel, HeroUnit heroUnit, boolean isNeutral, double pX, double pY, double pZ, int pValue) {
        HeroExperienceOrb expOrb = new HeroExperienceOrb((EntityType<? extends ExperienceOrb>)((EntityType)EntityRegistrar.HERO_EXPERIENCE_ORB.get()), pLevel);
        expOrb.followingHero = (LivingEntity)heroUnit;
        expOrb.isNeutral = isNeutral;
        expOrb.m_6034_(pX, pY, pZ);
        expOrb.m_146922_((float)(RANDOM.nextDouble() * 360.0));
        expOrb.m_20334_(RANDOM.nextDouble() * 0.2 - 0.1, RANDOM.nextDouble() * 0.2, RANDOM.nextDouble() * 0.2 - 0.1);
        expOrb.f_20770_ = pValue;
        expOrb.m_20242_(true);
        return expOrb;
    }

    public void m_8119_() {
        this.f_19862_ = false;
        this.f_19863_ = false;
        this.m_9236_().m_46473_().m_6180_("entityBaseTick");
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_146871_();
        this.f_19803_ = false;
        this.m_9236_().m_46473_().m_7238_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.followingHero != null) {
            Vec3 vec3 = new Vec3(this.followingHero.m_20185_() - this.m_20185_(), this.followingHero.m_20186_() + (double)this.followingHero.m_20192_() / 2.0 - this.m_20186_(), this.followingHero.m_20189_() - this.m_20189_()).m_82541_();
            double dist = this.m_20182_().m_82554_(this.followingHero.m_20182_());
            double speed = Math.max(Math.min(1.0, dist * 0.001), (double)0.01f);
            Vec3 newDeltaMovement = this.m_20184_().m_82549_(vec3.m_82490_(speed));
            double nextDist = this.m_20182_().m_82549_(newDeltaMovement).m_82554_(this.followingHero.m_20182_());
            if (nextDist > dist) {
                this.m_20256_(this.m_20184_().m_82490_(0.8));
            } else {
                this.m_20256_(newDeltaMovement);
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.checkTouchedHero();
        ++this.age;
        if (this.age >= 1200 || this.followingHero == null || this.followingHero.m_21224_()) {
            this.m_146870_();
        }
    }

    private void checkTouchedHero() {
        AABB aabb;
        if (this.followingHero != null && !this.followingHero.m_21224_() && !this.m_9236_().m_5776_() && (aabb = this.followingHero.m_20191_().m_82377_(0.5, 0.25, 0.5)).m_82390_(this.m_20182_())) {
            this.followingHero.m_7938_((Entity)this, this.f_147072_);
            if (!(this.f_147072_ <= 0 || this.isNeutral && ((HeroUnit)this.followingHero).getHeroLevel() >= 5)) {
                ((HeroUnit)this.followingHero).addExperience(this.f_20770_ * 10);
            }
            this.m_146870_();
        }
    }

    public void m_6123_(Player pEntity) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }
}

