/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.buildings.placements.SculkCatalystPlacement;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.healthbars.HealthBarClientEvents;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.LanguageUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PortraitRendererBuilding {
    public int frameWidth = 60;
    public int frameHeight = 60;
    public int xBlock = 31;
    public int yBlock = 25;

    public RectZone render(GuiGraphics guiGraphics, int x, int y, BuildingPlacement building) {
        Object name;
        Relationship rs = BuildingClientEvents.getPlayerToBuildingRelationship(building);
        Building building2 = building.getBuilding();
        if (building2 instanceof CustomBuilding) {
            CustomBuilding customBuilding = (CustomBuilding)building2;
            name = customBuilding.name;
        } else {
            ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)building.getBuilding());
            name = LanguageUtil.getTranslation("buildings." + (building.getFaction() != null && building.getFaction() != Faction.NONE ? building.getFaction().name().toLowerCase() : "neutral") + "." + key.m_135827_() + "." + key.m_135815_(), new Object[0]);
        }
        if (building.getUpgradeLevel() > 0) {
            name = building.getUpgradedName();
        }
        if (!building.isBuilt) {
            name = (String)name + " (" + (int)(building.getBlocksPlacedPercent() * 100.0f) + "%)";
        }
        if (rs != Relationship.OWNED && !building.ownerName.isBlank()) {
            name = (String)name + " (" + building.ownerName + ")";
        }
        if (building instanceof SculkCatalystPlacement) {
            SculkCatalystPlacement sc = (SculkCatalystPlacement)building;
            if (building.isBuilt) {
                name = (String)name + " (" + sc.getNightRange() + "/50 range)";
            }
        }
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, (String)name, x + 4, y - 9, -1);
        int bgCol = PlayerColors.getPlayerPortraitDisplayColorHex(building.ownerName);
        MyRenderer.renderFrameWithBg(guiGraphics, x, y, this.frameWidth, this.frameHeight, bgCol);
        this.drawBlockOnScreen(x, y, building.getBuilding().portraitBlock, 5.5f);
        HealthBarClientEvents.renderForBuilding(guiGraphics.m_280168_(), building, (float)x + (float)this.frameWidth / 2.0f, y + this.frameHeight - 15, this.frameWidth - 9, HealthBarClientEvents.RenderMode.GUI_PORTRAIT);
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, building.getHealth() + "/" + building.getMaxHealth(), x + this.frameWidth / 2, y + this.frameHeight - 13, -1);
        return RectZone.getZoneByLW(x, y, this.frameWidth, this.frameHeight);
    }

    public void drawBlockOnScreen(int x, int y, Block block, float blockScale) {
        ItemStack item = new ItemStack((ItemLike)block);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x + this.xBlock), (float)(y + this.yBlock), 100.0f);
        poseStack.m_85841_(blockScale, -blockScale, blockScale);
        RenderSystem.applyModelViewMatrix();
        float angle = System.currentTimeMillis() / 100L % 360L;
        Quaternionf quaternion = Axis.f_252529_.m_252977_(25.0f);
        Quaternionf quaternion2 = Axis.f_252436_.m_252977_(angle);
        quaternion.mul((Quaternionfc)quaternion2);
        PoseStack blockPoseStack = new PoseStack();
        blockPoseStack.m_85836_();
        blockPoseStack.m_252781_(quaternion);
        blockPoseStack.m_85841_(8.0f, 8.0f, 8.0f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Minecraft.m_91087_().m_91291_().m_269128_(item, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, blockPoseStack, (MultiBufferSource)bufferSource, null, 0);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }
}

