/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mixin;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public class BaseSpawnerMixin {
    @Shadow
    private SpawnData f_45444_;
    @Shadow
    private int f_45442_;
    private static final int SPAWN_RANGE = 6;
    private static final int SPAWN_COUNT = 3;
    private static final int MAX_NEARBY_NEUTRAL_UNITS = 1;
    private static final int SPAWN_DELAY = 600;
    private static final int ACTIVATION_RANGE = 30;

    @Shadow
    private void m_151350_(Level pLevel, BlockPos pPos) {
    }

    @Shadow
    private SpawnData m_253144_(@Nullable Level pLevel, RandomSource pRandom, BlockPos pPos) {
        return null;
    }

    @Shadow
    private boolean m_151343_(Level pLevel, BlockPos pPos) {
        return true;
    }

    @Inject(method={"delay"}, at={@At(value="HEAD")})
    private void delayNoRandom(Level pLevel, BlockPos pPos, CallbackInfo ci) {
        this.f_45442_ = 600;
    }

    @Inject(method={"isNearPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    public void isNearPlayer(Level pLevel, BlockPos pPos, CallbackInfoReturnable<Boolean> cir) {
        if (this.reignofnether$isValidNeutralUnitSpawner(pLevel, pPos)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean reignofnether$isValidNeutralUnitSpawner(Level level, BlockPos pPos) {
        return !BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), pPos) && this.f_45444_ != null && this.f_45444_.m_186567_().m_7916_().contains("reignofnether");
    }

    @Unique
    private int reignofnether$getMaxNearbyNeutralUnits(Entity entity, int nearbySameTypeSpawners) {
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            if (unit.getCost().population >= 5) {
                return 1 + nearbySameTypeSpawners;
            }
        }
        return 1 + nearbySameTypeSpawners * 3;
    }

    @Inject(method={"serverTick"}, at={@At(value="HEAD")}, cancellable=true)
    public void serverTick(ServerLevel pServerLevel, BlockPos pPos, CallbackInfo ci) {
        if (this.reignofnether$isValidNeutralUnitSpawner((Level)pServerLevel, pPos)) {
            ci.cancel();
            if (this.f_45442_ == -1) {
                this.m_151350_((Level)pServerLevel, pPos);
            }
            if (this.f_45442_ > 0) {
                --this.f_45442_;
            } else {
                ArrayList<Pair> spawnedEntities = new ArrayList<Pair>();
                RandomSource randomsource = pServerLevel.m_213780_();
                SpawnData spawndata = this.m_253144_((Level)pServerLevel, randomsource, pPos);
                CompoundTag compoundtag = spawndata.m_186567_();
                int nearbySameTypeSpawners = 0;
                for (int x = -3; x <= 3; ++x) {
                    for (int y = -3; y <= 3; ++y) {
                        for (int z = -3; z <= 3; ++z) {
                            BlockEntity blockEntity;
                            if (x == 0 && y == 0 && z == 0 || !((blockEntity = pServerLevel.m_7702_(pPos.m_7918_(x, y, z))) instanceof SpawnerBlockEntity)) continue;
                            SpawnerBlockEntity sbe = (SpawnerBlockEntity)blockEntity;
                            if (sbe.m_59801_().f_45444_ == null || !sbe.m_59801_().f_45444_.m_186567_().m_7916_().equals(this.f_45444_.m_186567_().m_7916_())) continue;
                            ++nearbySameTypeSpawners;
                        }
                    }
                }
                List<Unit> nearbyUnits = MiscUtil.getEntitiesWithinRange(new Vector3d((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_()), 30.0f, Mob.class, (Level)pServerLevel).stream().filter(mob -> {
                    boolean bl;
                    if (mob instanceof Unit) {
                        Unit unit = (Unit)mob;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }).map(mob -> (Unit)mob).toList();
                for (int i = 0; i < 3; ++i) {
                    double d2;
                    double d1;
                    double d0;
                    Optional optional = EntityType.m_20637_((CompoundTag)compoundtag);
                    if (optional.isEmpty()) {
                        this.m_151350_((Level)pServerLevel, pPos);
                        return;
                    }
                    ListTag listtag = compoundtag.m_128437_("Pos", 6);
                    int j = listtag.size();
                    int collisionRetries = 0;
                    do {
                        d0 = j >= 1 ? listtag.m_128772_(0) : (double)pPos.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * 6.0 + 0.5;
                        d1 = j >= 2 ? listtag.m_128772_(1) : (double)(pPos.m_123342_() + randomsource.m_188503_(3) - 1);
                        d2 = j >= 3 ? listtag.m_128772_(2) : (double)pPos.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * 6.0 + 0.5;
                    } while (!pServerLevel.m_45772_(((EntityType)optional.get()).m_20585_(d0, d1, d2)) && ++collisionRetries < 5);
                    if (!pServerLevel.m_45772_(((EntityType)optional.get()).m_20585_(d0, d1, d2))) continue;
                    BlockPos blockpos = BlockPos.m_274561_((double)d0, (double)d1, (double)d2);
                    if (!spawndata.m_186574_().isPresent() ? !SpawnPlacements.m_217074_((EntityType)((EntityType)optional.get()), (ServerLevelAccessor)pServerLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockpos, (RandomSource)pServerLevel.m_213780_()) : !((EntityType)optional.get()).m_20674_().m_21609_() && pServerLevel.m_46791_() == Difficulty.PEACEFUL) continue;
                    Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)pServerLevel, e -> {
                        e.m_7678_(e.m_20185_(), e.m_20186_(), e.m_20189_(), e.m_146908_(), e.m_146909_());
                        return e;
                    });
                    if (entity == null) {
                        this.m_151350_((Level)pServerLevel, pPos);
                        return;
                    }
                    List<Unit> nearbyNeutralUnitsOfType = nearbyUnits.stream().filter(u -> u.getOwnerName().isBlank() && entity.m_7755_().equals(((Entity)u).m_7755_())).toList();
                    List<Unit> nearbyNonNeutralUnits = nearbyUnits.stream().filter(u -> !u.getOwnerName().isBlank()).toList();
                    if (nearbyNeutralUnitsOfType.size() >= this.reignofnether$getMaxNearbyNeutralUnits(entity, nearbySameTypeSpawners) || !nearbyNonNeutralUnits.isEmpty()) {
                        this.m_151350_((Level)pServerLevel, pPos);
                        return;
                    }
                    spawnedEntities.add(new Pair((Object)entity, (Object)new Vector3d(d0, d1, d2)));
                }
                for (Pair pair : spawnedEntities) {
                    Entity entity = (Entity)pair.getFirst();
                    BlockPos blockpos = BlockPos.m_274561_((double)((Vector3d)pair.getSecond()).x, (double)((Vector3d)pair.getSecond()).y, (double)((Vector3d)pair.getSecond()).z);
                    entity.m_7678_(((Vector3d)pair.getSecond()).x, ((Vector3d)pair.getSecond()).y, ((Vector3d)pair.getSecond()).z, randomsource.m_188501_() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        Unit unit;
                        Mob mob2 = (Mob)entity;
                        if (entity instanceof Unit && (unit = (Unit)entity).getSunlightEffect() == Unit.SunlightEffect.FIRE && !ForgeEventFactory.checkSpawnPositionSpawner((Mob)mob2, (ServerLevelAccessor)pServerLevel, (MobSpawnType)MobSpawnType.SPAWNER, (SpawnData)spawndata, (BaseSpawner)((BaseSpawner)this))) continue;
                        MobSpawnEvent.FinalizeSpawn event = ForgeEventFactory.onFinalizeSpawnSpawner((Mob)mob2, (ServerLevelAccessor)pServerLevel, (DifficultyInstance)pServerLevel.m_6436_(entity.m_20183_()), (SpawnGroupData)null, (CompoundTag)compoundtag, (BaseSpawner)((BaseSpawner)this));
                        if (event != null && spawndata.m_186567_().m_128440_() == 1 && spawndata.m_186567_().m_128425_("id", 8)) {
                            ((Mob)entity).m_6518_((ServerLevelAccessor)pServerLevel, event.getDifficulty(), event.getSpawnType(), event.getSpawnData(), event.getSpawnTag());
                            if (entity instanceof Unit) {
                                Unit unit2 = (Unit)entity;
                                unit2.setAnchor(entity.m_20097_());
                            }
                        }
                    }
                    if (!pServerLevel.m_8860_(entity)) {
                        this.m_151350_((Level)pServerLevel, pPos);
                        return;
                    }
                    pServerLevel.m_46796_(2004, pPos, 0);
                    pServerLevel.m_142346_(entity, GameEvent.f_157810_, blockpos);
                    if (!(entity instanceof Unit)) continue;
                    Unit unit = (Unit)entity;
                    if (unit.getCost().population < 5) continue;
                    break;
                }
                this.m_151350_((Level)pServerLevel, pPos);
            }
        }
    }
}

