/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.player;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.hero.HeroClientEvents;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.hud.buttons.HelperButtons;
import com.solegendary.reignofnether.hud.playerdisplay.PlayerDisplayClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.registrars.SoundRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.sounds.SoundClientEvents;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.survival.SurvivalClientEvents;
import com.solegendary.reignofnether.time.TimeClientEvents;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerClientEvents {
    public static long rtsGameTicks = 0L;
    private static final Minecraft MC = Minecraft.m_91087_();
    public static boolean rtsLocked = false;
    public static boolean canStartRTS = true;
    public static final List<RTSPlayer> rtsPlayers = Collections.synchronizedList(new ArrayList());
    public static BlockState lastUsedBlockState = null;

    public static boolean isRTSPlayer() {
        for (RTSPlayer rtsPlayer : rtsPlayers) {
            if (PlayerClientEvents.MC.f_91074_ == null || !rtsPlayer.name.equals(PlayerClientEvents.MC.f_91074_.m_7755_().getString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRTSPlayer(String playerName) {
        for (RTSPlayer rtsPlayer : rtsPlayers) {
            if (!rtsPlayer.name.equals(playerName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static RTSPlayer getRTSPlayer(String playerName) {
        for (RTSPlayer rtsPlayer : rtsPlayers) {
            if (!rtsPlayer.name.equals(playerName)) continue;
            return rtsPlayer;
        }
        return null;
    }

    public static Faction getFaction() {
        for (RTSPlayer rtsPlayer : rtsPlayers) {
            if (PlayerClientEvents.MC.f_91074_ == null || !rtsPlayer.name.equals(PlayerClientEvents.MC.f_91074_.m_7755_().getString())) continue;
            return rtsPlayer.faction;
        }
        return Faction.NONE;
    }

    public static RTSPlayer getPlayer(String playerName) {
        for (RTSPlayer rtsPlayer : rtsPlayers) {
            if (!rtsPlayer.name.equals(playerName)) continue;
            return rtsPlayer;
        }
        return null;
    }

    public static Integer getPlayerId(String playerName) {
        RTSPlayer player = PlayerClientEvents.getPlayer(playerName);
        if (player == null) {
            return null;
        }
        return player.id;
    }

    public static Integer getPlayerIndex(String playerName) {
        RTSPlayer player = PlayerClientEvents.getPlayer(playerName);
        if (player == null) {
            return null;
        }
        return rtsPlayers.indexOf(player);
    }

    public static int getPlayerMapColorId(String playerName) {
        RTSPlayer player = PlayerClientEvents.getPlayer(playerName);
        if (player == null) {
            return 0;
        }
        return player.startPosColorId;
    }

    public static Faction getPlayerFaction(String playerName) {
        RTSPlayer player = PlayerClientEvents.getPlayer(playerName);
        if (player == null) {
            return Faction.NONE;
        }
        return player.faction;
    }

    public static String getPlayerName() {
        return PlayerClientEvents.MC.f_91074_ != null ? PlayerClientEvents.MC.f_91074_.m_7755_().getString() : "";
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterClientCommandsEvent evt) {
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-camera").executes(command -> {
            OrthoviewClientEvents.tryToToggleEnable();
            return 1;
        }));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-surrender").executes(command -> {
            PlayerServerboundPacket.surrender();
            return 1;
        }));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-reset").executes(command -> {
            if (PlayerClientEvents.MC.f_91074_ != null && PlayerClientEvents.MC.f_91074_.m_20310_(4)) {
                PlayerServerboundPacket.resetRTS();
                return 1;
            }
            return 0;
        }));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-hard-reset").executes(command -> {
            if (PlayerClientEvents.MC.f_91074_ != null && PlayerClientEvents.MC.f_91074_.m_20310_(4)) {
                PlayerServerboundPacket.resetRTSHard();
                return 1;
            }
            return 0;
        }));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-syncing").then(Commands.m_82127_((String)"enable").executes(command -> {
            if (PlayerClientEvents.MC.f_91074_ != null && PlayerClientEvents.MC.f_91074_.m_20310_(4)) {
                PlayerServerboundPacket.enableRTSSyncing();
                return 1;
            }
            return 0;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-syncing").then(Commands.m_82127_((String)"disable").executes(command -> {
            if (PlayerClientEvents.MC.f_91074_ != null && PlayerClientEvents.MC.f_91074_.m_20310_(4)) {
                PlayerServerboundPacket.disableRTSSyncing();
                return 1;
            }
            return 0;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-help").executes(command -> {
            if (PlayerClientEvents.MC.f_91074_ != null) {
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.toggle_fow", (Object[])new Object[]{"/rts-fog enable/disable"}));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.surrender", (Object[])new Object[]{"/rts-surrender"}));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.reset", (Object[])new Object[]{"/rts-reset"}));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.hard_reset", (Object[])new Object[]{"/rts-hard-reset"}));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.lock", (Object[])new Object[]{"/rts-lock enable/disable"}));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.ally", (Object[])new Object[]{"/ally"}));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.disband", (Object[])new Object[]{"/disband"}));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.send_resources", (Object[])new Object[]{"/sendfood | wood | ore <playername> <amount>"}));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"commands.reignofnether.camera", (Object[])new Object[]{"/rts-camera"}));
            }
            return 1;
        }));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-controls").executes(command -> {
            if (PlayerClientEvents.MC.f_91074_ != null) {
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.toggle_cam"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.refresh_chunks"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.toggle_fps_tps"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.deselect"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.command"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.create_group"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.recenter_map"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.select_same"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.destroy"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.rotate_cam"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.zoom"));
                PlayerClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"controls.reignofnether.rotate"));
            }
            return 1;
        }));
    }

    public static void defeat(String playerName) {
        if (PlayerClientEvents.MC.f_91074_ == null) {
            return;
        }
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (!building.ownerName.equals(playerName)) continue;
            building.ownerName = "";
        }
        if (PlayerClientEvents.isRTSPlayer()) {
            PlayerDisplayClientEvents.resetDisplay();
        }
        PlayerClientEvents.removeRTSPlayer(playerName);
        ResourcesClientEvents.resourcesList.removeIf(r -> r.ownerName.equals(playerName));
        if (!PlayerClientEvents.MC.f_91074_.m_7755_().getString().equals(playerName)) {
            return;
        }
        if (!SandboxClientEvents.isSandboxPlayer(playerName)) {
            PlayerClientEvents.MC.f_91065_.m_168714_((Component)Component.m_237115_((String)"titles.reignofnether.defeated"));
            PlayerClientEvents.MC.f_91074_.m_5496_((SoundEvent)SoundRegistrar.DEFEAT.get(), 0.5f, 1.0f);
        }
        ResearchClient.removeAllResearch();
        ResearchClient.removeAllCheats();
        HudClientEvents.controlGroups.clear();
    }

    public static void victory(String playerName) {
        if (PlayerClientEvents.MC.f_91074_ == null || !PlayerClientEvents.MC.f_91074_.m_7755_().getString().equals(playerName)) {
            return;
        }
        PlayerClientEvents.MC.f_91065_.m_168714_((Component)Component.m_237115_((String)"titles.reignofnether.victorious"));
        PlayerClientEvents.MC.f_91074_.m_5496_((SoundEvent)SoundRegistrar.VICTORY.get(), 0.5f, 1.0f);
    }

    public static void addRTSPlayer(String playerName, Faction faction, Long id, int startPosColorId) {
        if (!PlayerClientEvents.isRTSPlayer(playerName)) {
            rtsPlayers.add(RTSPlayer.getNewPlayer(playerName, faction, id.intValue(), startPosColorId));
            if (PlayerClientEvents.MC.f_91074_ != null && PlayerClientEvents.MC.f_91074_.m_7755_().getString().equals(playerName)) {
                GameruleClient.gamerulesMenuOpen = false;
                if (!SandboxClientEvents.isSandboxPlayer()) {
                    MC.m_91397_().m_120186_();
                    ResearchClient.removeAllCheats();
                }
            }
        }
    }

    public static void removeRTSPlayer(String playerName) {
        boolean removed = rtsPlayers.removeIf(p -> p.name.equals(playerName));
        if (removed && PlayerClientEvents.MC.f_91074_ != null && PlayerClientEvents.MC.f_91074_.m_7755_().getString().equals(playerName)) {
            SoundClientEvents.stopFadeableMusicInstance();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent evt) {
        if (PlayerClientEvents.MC.f_91074_ != null && evt.getEntity().m_19879_() == PlayerClientEvents.MC.f_91074_.m_19879_()) {
            PlayerClientEvents.resetRTS(true);
            UnitClientEvents.getAllUnits().clear();
            BuildingClientEvents.getBuildings().clear();
            FogOfWarClientEvents.movedToCapitol = false;
            FogOfWarClientEvents.frozenChunks.clear();
            FogOfWarClientEvents.semiFrozenChunks.clear();
            OrthoviewClientEvents.unlockCam();
            HeroClientEvents.fallenHeroes.clear();
            PlayerDisplayClientEvents.resetDisplay();
            PlayerColors.reset();
            CustomBuildingClientEvents.customBuildings.clear();
            CustomBuildingClientEvents.setCustomBuildingToEdit(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (PlayerClientEvents.MC.f_91074_ != null && evt.getEntity().m_19879_() == PlayerClientEvents.MC.f_91074_.m_19879_()) {
            FogOfWarClientEvents.updateFogChunks();
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut evt) {
        if (PlayerClientEvents.MC.f_91074_ != null && evt.getPlayer() != null && evt.getPlayer().m_19879_() == PlayerClientEvents.MC.f_91074_.m_19879_()) {
            PlayerClientEvents.resetRTS(true);
            UnitClientEvents.getAllUnits().clear();
            BuildingClientEvents.getBuildings().clear();
            FogOfWarClientEvents.movedToCapitol = false;
            FogOfWarClientEvents.frozenChunks.clear();
            FogOfWarClientEvents.semiFrozenChunks.clear();
            HeroClientEvents.fallenHeroes.clear();
            PlayerDisplayClientEvents.resetDisplay();
            PlayerColors.reset();
            CustomBuildingClientEvents.customBuildings.clear();
        }
    }

    @SubscribeEvent
    public static void onClientLogin(ClientPlayerNetworkEvent.LoggingIn evt) {
        if (PlayerClientEvents.MC.f_91074_ != null && evt.getPlayer().m_19879_() == PlayerClientEvents.MC.f_91074_.m_19879_()) {
            FogOfWarClientEvents.updateFogChunks();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            ++rtsGameTicks;
        }
    }

    @SubscribeEvent
    public static void onScreenOpen(ScreenEvent.Opening evt) {
        if (OrthoviewClientEvents.isEnabled() && (evt.getScreen() instanceof CreativeModeInventoryScreen || evt.getScreen() instanceof InventoryScreen)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render evt) {
        if (OrthoviewClientEvents.isEnabled() && Keybindings.tab.isDown() && PlayerClientEvents.MC.f_91073_ != null) {
            if (!MC.m_91090_()) {
                PlayerClientEvents.MC.f_91065_.m_93088_().m_94556_(true);
                PlayerClientEvents.MC.f_91065_.m_93088_().m_280406_(evt.getGuiGraphics(), MC.m_91268_().m_85445_(), PlayerClientEvents.MC.f_91073_.m_6188_(), null);
            } else {
                PlayerClientEvents.MC.f_91065_.m_93088_().m_94556_(false);
            }
        }
    }

    public static void syncRtsGameTime(Long gameTicks) {
        rtsGameTicks = gameTicks;
    }

    public static void resetRTS(boolean hardReset) {
        boolean isSandbox = SandboxClientEvents.isSandboxPlayer();
        rtsPlayers.clear();
        HelperButtons.updateButtons();
        SoundClientEvents.stopFadeableMusicInstance();
        HudClientEvents.controlGroups.clear();
        UnitClientEvents.getSelectedUnits().clear();
        UnitClientEvents.getPreselectedUnits().clear();
        if (!isSandbox) {
            UnitClientEvents.getAllUnits().removeIf(u -> {
                Unit unit;
                return hardReset || u instanceof Unit && !Unit.hasAnchor(unit = (Unit)u);
            });
        }
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            if (!(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            unit.setOwnerName("");
        }
        UnitClientEvents.idleWorkerIds.clear();
        ResearchClient.removeAllResearch();
        ResearchClient.removeAllCheats();
        BuildingClientEvents.getSelectedBuildings().clear();
        if (!isSandbox) {
            BuildingClientEvents.getBuildings().removeIf(b -> b.getBuilding().shouldDestroyOnReset || hardReset);
        }
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            building.ownerName = "";
        }
        ResourcesClientEvents.resourcesList.clear();
        ClientGameModeHelper.gameMode = ClientGameModeHelper.DEFAULT_GAMEMODE;
        ClientGameModeHelper.gameModeLocked = false;
        SurvivalClientEvents.reset();
        StartPosClientEvents.resetAll();
        HeroClientEvents.fallenHeroes.clear();
        AlliancesClient.playersWithAlliedControl.clear();
        PlayerColors.reset();
        PlayerDisplayClientEvents.resetDisplay();
        TimeClientEvents.resetBloodMoon();
        CustomBuildingClientEvents.setCustomBuildingToEdit(null);
    }

    public static void setRTSLock(boolean lock) {
        rtsLocked = lock;
    }

    public static void setCanStartRTS(boolean canStart) {
        canStartRTS = canStart;
    }

    public static void syncBeaconOwnerTicks(String playerName, long ticks) {
        for (int i = 0; i < rtsPlayers.size(); ++i) {
            if (!PlayerClientEvents.rtsPlayers.get((int)i).name.equals(playerName)) continue;
            PlayerClientEvents.rtsPlayers.get((int)i).beaconOwnerTicks = (int)ticks;
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        if (PlayerClientEvents.MC.f_91073_ != null) {
            lastUsedBlockState = PlayerClientEvents.MC.f_91073_.m_8055_(evt.getPos());
        }
    }
}

