/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.player;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.fogofwar.FogOfWarServerEvents;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.Collections;

public class RTSPlayer {
    public String name;
    public int id;
    public int ticksWithoutCapitol = 0;
    public Faction faction;
    public int beaconOwnerTicks = 0;
    public int startPosColorId = 0;

    private RTSPlayer(String playerName, Faction faction, int id) {
        this.name = playerName;
        this.id = id;
        this.faction = faction;
    }

    private RTSPlayer(String playerName, Faction faction, int id, int startPosColorId) {
        this.name = playerName;
        this.id = id;
        this.faction = faction;
        this.startPosColorId = startPosColorId;
    }

    private RTSPlayer(String name, Faction faction) {
        int minId = 0;
        if (!PlayerServerEvents.rtsPlayers.isEmpty()) {
            minId = Collections.min(PlayerServerEvents.rtsPlayers.stream().map(r -> r.id).toList());
        }
        this.id = minId >= 0 ? -1 : minId - 1;
        this.faction = faction;
        this.name = name;
    }

    private RTSPlayer(String name, int id, int ticksWithoutCapitol, Faction faction, int beaconOwnerTicks) {
        this.name = name;
        this.id = id;
        this.ticksWithoutCapitol = ticksWithoutCapitol;
        this.faction = faction;
        this.beaconOwnerTicks = beaconOwnerTicks;
    }

    public static RTSPlayer getFromSave(String name, int id, int ticksWithoutCapitol, Faction faction, int beaconOwnerTicks) {
        return new RTSPlayer(name, id, ticksWithoutCapitol, faction, beaconOwnerTicks);
    }

    public static RTSPlayer getNewPlayer(String playerName, Faction faction, int id) {
        return new RTSPlayer(playerName, faction, id);
    }

    public static RTSPlayer getNewPlayer(String playerName, Faction faction, int id, int startPosColorId) {
        return new RTSPlayer(playerName, faction, id, startPosColorId);
    }

    public static RTSPlayer getNewBot(String name, Faction faction) {
        return new RTSPlayer(name, faction);
    }

    public boolean isBot() {
        return this.id < 0;
    }

    public void serverTick() {
        int numBuildingsOwned = BuildingServerEvents.getBuildings().stream().filter(b -> b.ownerName.equals(this.name)).toList().size();
        int numCapitolsOwned = BuildingServerEvents.getBuildings().stream().filter(b -> b.ownerName.equals(this.name) && b.isCapitol).toList().size();
        if (numBuildingsOwned > 0 && numCapitolsOwned == 0) {
            if (this.ticksWithoutCapitol < 1200) {
                ++this.ticksWithoutCapitol;
                if (this.ticksWithoutCapitol == 1200) {
                    if (FogOfWarServerEvents.isEnabled()) {
                        PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.revealed", false, this.name);
                    }
                    FogOfWarClientboundPacket.revealOrHidePlayer(true, this.name);
                }
            }
        } else {
            this.ticksWithoutCapitol = 0;
        }
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (!(building instanceof BeaconPlacement)) continue;
            BeaconPlacement beacon = (BeaconPlacement)building;
            if (!beacon.isBuilt || !building.ownerName.equals(this.name) || beacon.getUpgradeLevel() != 5) continue;
            ++this.beaconOwnerTicks;
            if (this.beaconOwnerTicks != Beacon.getTicksToWin(beacon.getLevel()) / 4 && this.beaconOwnerTicks != Beacon.getTicksToWin(beacon.getLevel()) / 2 && this.beaconOwnerTicks != Beacon.getTicksToWin(beacon.getLevel()) * 3 / 4 && this.beaconOwnerTicks != Beacon.getTicksToWin(beacon.getLevel()) - 1200) continue;
            beacon.sendWarning("time_warning");
        }
    }

    public boolean isRevealed() {
        return this.ticksWithoutCapitol >= 1200;
    }
}

