/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.research.ResearchClient;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ResearchClientboundPacket {
    public String playerName;
    public String itemName;
    public boolean add;
    public boolean isCheat;
    public int value;

    public static void addCheat(String playerName, String itemName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResearchClientboundPacket(playerName, itemName, true, true, 0));
    }

    public static void addCheatWithValue(String playerName, String itemName, int value) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResearchClientboundPacket(playerName, itemName, true, true, value));
    }

    public static void removeCheat(String playerName, String itemName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResearchClientboundPacket(playerName, itemName, false, true, 0));
    }

    public static void addResearch(String playerName, String itemName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResearchClientboundPacket(playerName, itemName, true, false, 0));
    }

    public ResearchClientboundPacket(String playerName, String itemName, boolean add, boolean isCheat, int value) {
        this.playerName = playerName;
        this.itemName = itemName;
        this.add = add;
        this.isCheat = isCheat;
        this.value = value;
    }

    public ResearchClientboundPacket(FriendlyByteBuf buffer) {
        this.playerName = buffer.m_130277_();
        this.itemName = buffer.m_130277_();
        this.add = buffer.readBoolean();
        this.isCheat = buffer.readBoolean();
        this.value = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerName);
        buffer.m_130070_(this.itemName);
        buffer.writeBoolean(this.add);
        buffer.writeBoolean(this.isCheat);
        buffer.writeInt(this.value);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_().f_91074_.m_7755_().getString().equals(this.playerName)) {
                if (this.isCheat) {
                    if (this.value > 0) {
                        ResearchClient.addCheatWithValue(this.itemName, this.value);
                    } else if (this.add) {
                        ResearchClient.addCheat(this.itemName);
                    } else {
                        ResearchClient.removeCheat(this.itemName);
                    }
                } else if (this.add) {
                    ResearchClient.addResearch(this.playerName, ResourceLocation.m_135820_((String)this.itemName));
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

