/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProdDupeRule;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.StartProductionButton;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchBeaconLevel2
extends ProductionItem {
    public static final String itemName = "Gold Beacon";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_BEACON_LEVEL2;

    public ResearchBeaconLevel2() {
        super(cost, ProdDupeRule.DISALLOW_FOR_BUILDING);
        this.onComplete = (level, placement) -> {
            if (placement instanceof BeaconPlacement) {
                BeaconPlacement beacon = (BeaconPlacement)placement;
                beacon.changeStructure(2);
                if (!level.m_5776_()) {
                    beacon.sendWarning("upgraded_warning");
                }
            }
        };
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    @Override
    public StartProductionButton getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new StartProductionButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/gold_block.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame_bronze.png"), hotkey, () -> {
            BeaconPlacement beacon;
            return this.itemIsBeingProducedAt(prodBuilding) || prodBuilding instanceof BeaconPlacement && (beacon = (BeaconPlacement)prodBuilding).getUpgradeLevel() != 1;
        }, () -> true, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.beacon_level2", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.beacon_level2.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.beacon_level_win", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public StopProductionButton getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new StopProductionButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/gold_block.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame_bronze.png"), prodBuilding, this, first);
    }
}

