/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProdDupeRule;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.building.production.StartProductionButton;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;

public class ResearchBruteShields
extends ProductionItem {
    public static final String itemName = "Shield Tactics";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_BRUTE_SHIELDS;

    public ResearchBruteShields() {
        super(cost, ProdDupeRule.DISALLOW);
        this.onComplete = (level, placement) -> {
            if (level.m_5776_()) {
                ResearchClient.addResearch(placement.ownerName, ProductionItems.RESEARCH_BRUTE_SHIELDS);
            } else {
                ResearchServerEvents.addResearch(placement.ownerName, ProductionItems.RESEARCH_BRUTE_SHIELDS);
                for (LivingEntity unit : UnitServerEvents.getAllUnits()) {
                    BruteUnit vUnit;
                    if (!(unit instanceof BruteUnit) || !(vUnit = (BruteUnit)unit).getOwnerName().equals(placement.ownerName)) continue;
                    vUnit.setupEquipmentAndUpgradesServer();
                }
            }
        };
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    @Override
    public StartProductionButton getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new StartProductionButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/shield.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame_bronze.png"), hotkey, () -> ProductionItems.RESEARCH_BRUTE_SHIELDS.itemIsBeingProduced(prodBuilding.ownerName) || ResearchClient.hasResearch(ProductionItems.RESEARCH_BRUTE_SHIELDS), () -> true, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.brute_shields", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.brute_shields.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.brute_shields.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.brute_shields.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public StopProductionButton getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new StopProductionButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/shield.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame_bronze.png"), prodBuilding, this, first);
    }
}

