/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.sounds;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SoundClientboundPacket {
    SoundAction soundAction;
    BlockPos bp;
    String playerName;
    float volume;

    public static void playSoundAtPos(SoundAction soundAction, BlockPos bp) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SoundClientboundPacket(soundAction, bp, "", 1.0f));
    }

    public static void playSoundAtPos(SoundAction soundAction, BlockPos bp, float volume) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SoundClientboundPacket(soundAction, bp, "", volume));
    }

    public static void playSoundForAllPlayers(SoundAction soundAction) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SoundClientboundPacket(soundAction, new BlockPos(0, 0, 0), "", 1.0f));
    }

    public static void playSoundForAllPlayers(SoundAction soundAction, float volume) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SoundClientboundPacket(soundAction, new BlockPos(0, 0, 0), "", volume));
    }

    public static void playSoundForPlayer(SoundAction soundAction, String name) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SoundClientboundPacket(soundAction, new BlockPos(0, 0, 0), name, 1.0f));
    }

    public static void playSoundForPlayer(SoundAction soundAction, String name, float volume) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SoundClientboundPacket(soundAction, new BlockPos(0, 0, 0), name, volume));
    }

    public SoundClientboundPacket(SoundAction soundAction, BlockPos bp, String playerName, float volume) {
        this.soundAction = soundAction;
        this.bp = bp;
        this.playerName = playerName;
        this.volume = volume;
    }

    public SoundClientboundPacket(FriendlyByteBuf buffer) {
        this.soundAction = (SoundAction)buffer.m_130066_(SoundAction.class);
        this.bp = buffer.m_130135_();
        this.playerName = buffer.m_130277_();
        this.volume = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.soundAction);
        buffer.m_130064_(this.bp);
        buffer.m_130070_(this.playerName);
        buffer.writeFloat(this.volume);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.bp.equals((Object)new BlockPos(0, 0, 0))) {
                if (this.playerName.isBlank()) {
                    SoundClientEvents.playSoundForLocalPlayer(this.soundAction, this.volume);
                } else {
                    SoundClientEvents.playSoundIfPlayer(this.soundAction, this.playerName, this.volume);
                }
            } else {
                SoundClientEvents.playSoundAtPos(this.soundAction, this.bp, this.volume);
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

