/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival;

import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.survival.SurvivalServerboundPacket;
import com.solegendary.reignofnether.survival.Wave;
import com.solegendary.reignofnether.survival.WaveDifficulty;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class SurvivalClientEvents {
    public static int lastWaveNumber = 0;
    public static int waveNumber = 1;
    public static boolean isEnabled = false;
    public static WaveDifficulty difficulty = WaveDifficulty.BEGINNER;
    private static Minecraft MC = Minecraft.m_91087_();

    public static int getMinutesPerDay() {
        return switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case WaveDifficulty.BEGINNER -> 20;
            case WaveDifficulty.EASY -> 15;
            case WaveDifficulty.MEDIUM -> 12;
            case WaveDifficulty.HARD -> 9;
            case WaveDifficulty.EXTREME -> 6;
        };
    }

    public static void setWaveNumber(long number) {
        lastWaveNumber = waveNumber;
        waveNumber = (int)number;
    }

    public static void setRandomSeed(long number) {
        Wave.randomSeed = number;
        Wave.reseedWaves();
    }

    public static void reset() {
        isEnabled = false;
        waveNumber = 1;
    }

    public static void enable(WaveDifficulty diff) {
        if (SurvivalClientEvents.MC.f_91074_ == null) {
            return;
        }
        difficulty = diff;
        isEnabled = true;
    }

    public static Button getNextWaveButton() {
        return new Button("Next Survival Wave", 14, switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case WaveDifficulty.BEGINNER -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/wooden_sword.png");
            case WaveDifficulty.EASY -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/stone_sword.png");
            case WaveDifficulty.MEDIUM -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/iron_sword.png");
            case WaveDifficulty.HARD -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/diamond_sword.png");
            case WaveDifficulty.EXTREME -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/netherite_sword.png");
        }, (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            if (waveNumber < 30 && ResearchClient.hasCheat("thereisnospoon")) {
                SurvivalServerboundPacket.setWaveNumber(++waveNumber);
            }
        }, () -> {
            if (waveNumber > 1 && ResearchClient.hasCheat("thereisnospoon")) {
                SurvivalServerboundPacket.setWaveNumber(--waveNumber);
            }
        }, SurvivalClientEvents.getWaveTooltip());
    }

    private static String str(String string) {
        Wave wave = Wave.getWave(waveNumber);
        String localePrefix = switch (wave.faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> "units.villagers.reignofnether.";
            case Faction.MONSTERS -> "units.monsters.reignofnether.";
            case Faction.PIGLINS -> "units.piglins.reignofnether.";
            case Faction.NONE -> "";
        };
        return I18n.m_118938_((String)(localePrefix + string), (Object[])new Object[0]);
    }

    private static FormattedCharSequence slimeFcs() {
        Wave wave = Wave.getWave(waveNumber);
        String research = wave.highestUnitTier >= 6 ? " [" + I18n.m_118938_((String)"research.reignofnether.slime_conversion", (Object[])new Object[0]) + "]" : "";
        return FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"units.monsters.reignofnether.slime", (Object[])new Object[0]) + " " + I18n.m_118938_((String)"units.monsters.reignofnether.slime.size", (Object[])new Object[]{wave.highestUnitTier}) + research), (Style)Style.f_131099_);
    }

    private static FormattedCharSequence magmaCubeFcs() {
        Wave wave = Wave.getWave(waveNumber);
        String research = wave.highestUnitTier >= 6 ? " [" + I18n.m_118938_((String)"research.reignofnether.cube_magma", (Object[])new Object[0]) + "]" : "";
        return FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"units.piglins.reignofnether.magma_cube", (Object[])new Object[0]) + " " + I18n.m_118938_((String)"units.monsters.reignofnether.slime.size", (Object[])new Object[]{wave.highestUnitTier}) + research), (Style)Style.f_131099_);
    }

    private static String research(String string) {
        return " [" + I18n.m_118938_((String)("research.reignofnether." + string), (Object[])new Object[0]) + "]";
    }

    private static String armoured(int plus) {
        Wave wave = Wave.getWave(waveNumber);
        String str = " (" + I18n.m_118938_((String)"hud.units.reignofnether.armoured", (Object[])new Object[0]);
        str = str + new String(new char[plus]).replace("\u0000", "+");
        return str + ")";
    }

    private static String enchant(String string) {
        return " [" + I18n.m_118938_((String)("hud.enchant.reignofnether." + string), (Object[])new Object[0]) + "]";
    }

    private static String faction(Faction faction) {
        return switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> I18n.m_118938_((String)"hud.faction.reignofnether.villager", (Object[])new Object[0]);
            case Faction.MONSTERS -> I18n.m_118938_((String)"hud.faction.reignofnether.monster", (Object[])new Object[0]);
            case Faction.PIGLINS -> I18n.m_118938_((String)"hud.faction.reignofnether.piglin", (Object[])new Object[0]);
            case Faction.NONE -> I18n.m_118938_((String)"hud.faction.reignofnether.random", (Object[])new Object[0]);
        };
    }

    public static List<FormattedCharSequence> getWaveTooltip() {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        Wave wave = Wave.getWave(waveNumber);
        tooltip.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"survival.reignofnether.next_wave", (Object[])new Object[]{wave.number, wave.highestUnitTier, SurvivalClientEvents.faction(wave.faction)}), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        tooltip.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.survival5", (Object[])new Object[]{difficulty, SurvivalClientEvents.getMinutesPerDay()}), (Style)Style.f_131099_));
        tooltip.add(FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_));
        if (wave.faction == Faction.MONSTERS) {
            if (wave.highestUnitTier == 1) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("zombie_piglin")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("zombie")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("skeleton")));
            }
            if (wave.highestUnitTier == 2) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("zombie_piglin")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("zombie") + "/" + SurvivalClientEvents.str("husk")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("skeleton") + "/" + SurvivalClientEvents.str("stray")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("spider")));
                tooltip.add(SurvivalClientEvents.slimeFcs());
            }
            if (wave.highestUnitTier == 3) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("zombie_piglin")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("husk") + "/" + SurvivalClientEvents.str("drowned")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("skeleton") + "/" + SurvivalClientEvents.str("stray")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("poison_spider")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("spider_jockey")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("creeper")));
                tooltip.add(SurvivalClientEvents.slimeFcs());
            }
            if (wave.highestUnitTier == 4) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("husk") + "/" + SurvivalClientEvents.str("drowned") + SurvivalClientEvents.armoured(0)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("stray") + SurvivalClientEvents.armoured(0)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("poison_spider")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("spider_jockey")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("creeper")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("enderman")));
                tooltip.add(SurvivalClientEvents.slimeFcs());
            }
            if (wave.highestUnitTier == 5) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("drowned") + SurvivalClientEvents.armoured(1)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("stray") + SurvivalClientEvents.armoured(1)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("poison_spider_jockey")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("creeper")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("enderman")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("warden")));
                tooltip.add(SurvivalClientEvents.slimeFcs());
            }
            if (wave.highestUnitTier >= 6) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("drowned") + SurvivalClientEvents.armoured(2)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("stray") + SurvivalClientEvents.armoured(2)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("poison_spider_jockey")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("charged_creeper")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("enderman")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("warden")));
                tooltip.add(SurvivalClientEvents.slimeFcs());
            }
        } else if (wave.faction == Faction.PIGLINS) {
            if (wave.highestUnitTier == 1) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("brute")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("headhunter")));
            }
            if (wave.highestUnitTier == 2) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("brute")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("headhunter")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("hoglin")));
                tooltip.add(SurvivalClientEvents.magmaCubeFcs());
            }
            if (wave.highestUnitTier == 3) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("brute")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("headhunter")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("hoglin")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("blaze")));
                tooltip.add(SurvivalClientEvents.magmaCubeFcs());
            }
            if (wave.highestUnitTier == 4) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("brute") + SurvivalClientEvents.research("brute_shields") + SurvivalClientEvents.armoured(0)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("headhunter") + SurvivalClientEvents.research("heavy_tridents") + SurvivalClientEvents.armoured(0)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("hoglin")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("hoglin_rider")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("blaze")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("wither_skeleton")));
                tooltip.add(SurvivalClientEvents.magmaCubeFcs());
            }
            if (wave.highestUnitTier == 5) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("brute") + SurvivalClientEvents.research("brute_shields") + SurvivalClientEvents.armoured(1)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("headhunter") + SurvivalClientEvents.research("heavy_tridents") + SurvivalClientEvents.armoured(1)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("hoglin")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("hoglin_rider")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("blaze")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("wither_skeleton")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("ghast")));
                tooltip.add(SurvivalClientEvents.magmaCubeFcs());
            }
            if (wave.highestUnitTier >= 6) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("brute") + SurvivalClientEvents.research("brute_shields") + SurvivalClientEvents.armoured(2)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("headhunter") + SurvivalClientEvents.research("heavy_tridents") + SurvivalClientEvents.armoured(2)));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("hoglin")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("hoglin_rider")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("blaze")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("wither_skeleton")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("ghast") + SurvivalClientEvents.research("soul_fireballs")));
                tooltip.add(SurvivalClientEvents.magmaCubeFcs());
            }
        } else if (wave.faction == Faction.VILLAGERS) {
            if (wave.highestUnitTier == 1) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("militia")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("vindicator")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("pillager")));
            }
            if (wave.highestUnitTier == 2) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("militia")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("vindicator") + SurvivalClientEvents.enchant("maiming")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("pillager")));
            }
            if (wave.highestUnitTier == 3) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("militia")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("vindicator") + SurvivalClientEvents.enchant("maiming")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("pillager") + SurvivalClientEvents.enchant("quickshot")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("iron_golem")));
            }
            if (wave.highestUnitTier == 4) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("militia")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("vindicator") + SurvivalClientEvents.enchant("sharpness")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("pillager") + SurvivalClientEvents.enchant("quickshot")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("iron_golem")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("evoker")));
            }
            if (wave.highestUnitTier == 5) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("vindicator") + SurvivalClientEvents.enchant("sharpness")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("pillager") + SurvivalClientEvents.enchant("multishot")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("iron_golem")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("evoker")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("ravager")));
            }
            if (wave.highestUnitTier >= 6) {
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("vindicator") + SurvivalClientEvents.enchant("sharpness")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("pillager") + SurvivalClientEvents.enchant("multishot")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("iron_golem")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("evoker") + SurvivalClientEvents.enchant("vigor")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("ravager")));
                tooltip.add(MiscUtil.fcs(SurvivalClientEvents.str("ravager_artillery") + " + " + SurvivalClientEvents.str("captain")));
            }
        } else if (wave.faction == Faction.NONE) {
            tooltip.add(FormattedCharSequence.m_13714_((String)"???", (Style)Style.f_131099_));
        }
        return tooltip;
    }
}

