/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.ability.heroAbilities.monster.SoulSiphonPassive;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.buildings.placements.SculkCatalystPlacement;
import com.solegendary.reignofnether.building.buildings.villagers.IronGolemBuilding;
import com.solegendary.reignofnether.building.production.ActiveProduction;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hero.HeroServerEvents;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.registrars.MobEffectRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.unit.HeroUnitSaveData;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.TargetResourcesSave;
import com.solegendary.reignofnether.unit.TargetResourcesSaveData;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitActionItem;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.ConvertableUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitConvertClientboundPacket;
import com.solegendary.reignofnether.unit.packets.UnitIdleWorkerClientBoundPacket;
import com.solegendary.reignofnether.unit.packets.UnitSyncClientboundPacket;
import com.solegendary.reignofnether.unit.packets.UnitSyncMobEffectsClientboundPacket;
import com.solegendary.reignofnether.unit.packets.UnitSyncWorkerClientBoundPacket;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.monsters.DrownedUnit;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import com.solegendary.reignofnether.unit.units.monsters.SlimeUnit;
import com.solegendary.reignofnether.unit.units.piglins.BlazeUnit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.unit.units.piglins.GruntUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.piglins.MagmaCubeUnit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.unit.units.villagers.MilitiaUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnitProfession;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorUnit;
import com.solegendary.reignofnether.unit.units.villagers.WitchUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector3d;

public class UnitServerEvents {
    public static boolean improvedPathfinding = true;
    private static final int UNIT_SYNC_TICKS_MAX = 20;
    private static int unitSyncTicks = 20;
    public static int maxPopulation = 150;
    private static final List<UnitActionItem> unitActionSlowQueue = Collections.synchronizedList(new ArrayList());
    private static final List<UnitActionItem> unitActionFastQueue = Collections.synchronizedList(new ArrayList());
    private static final ArrayList<LivingEntity> allUnits = new ArrayList();
    private static final ArrayList<Pair<Integer, ChunkAccess>> forcedUnitChunks = new ArrayList();
    public static final ArrayList<TargetResourcesSave> savedTargetResources = new ArrayList();
    private static final int SAVE_TICKS_MAX = 600;
    private static int saveTicks = 0;
    private static int lastHuntedAnimalId = -1;
    public static ArrayList<Integer> knockbackIgnoreIds = new ArrayList();

    public static ArrayList<LivingEntity> getAllUnits() {
        return allUnits;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent evt) {
        ServerLevel level;
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (++saveTicks >= 600 && (level = evt.getServer().m_129880_(Level.f_46428_)) != null) {
            UnitServerEvents.saveGatherTargets(level);
            saveTicks = 0;
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            UnitServerEvents.saveFallenHeroUnits(level);
            UnitServerEvents.saveGatherTargets(level);
        }
    }

    public static void saveFallenHeroUnits(ServerLevel level) {
        HeroUnitSaveData data = HeroUnitSaveData.getInstance((LevelAccessor)level);
        data.heroUnits.clear();
        data.heroUnits.addAll(HeroServerEvents.fallenHeroes);
        data.save();
        level.m_8895_().m_78151_();
        ReignOfNether.LOGGER.info("Saved " + UnitServerEvents.getAllUnits().size() + " fallen hero units");
    }

    public static void saveGatherTargets(ServerLevel level) {
        TargetResourcesSaveData data = TargetResourcesSaveData.getInstance((LevelAccessor)level);
        data.targetData.clear();
        AtomicInteger numWorkersSaved = new AtomicInteger();
        UnitServerEvents.getAllUnits().forEach(e -> {
            if (e instanceof WorkerUnit) {
                WorkerUnit wUnit = (WorkerUnit)e;
                if (wUnit.getGatherResourceGoal().data.hasData()) {
                    wUnit.getGatherResourceGoal().data.unitUUID = e.m_20149_();
                    data.targetData.add(wUnit.getGatherResourceGoal().data);
                    numWorkersSaved.addAndGet(1);
                } else if (wUnit.getGatherResourceGoal().saveData.hasData()) {
                    wUnit.getGatherResourceGoal().saveData.unitUUID = e.m_20149_();
                    data.targetData.add(wUnit.getGatherResourceGoal().saveData);
                    numWorkersSaved.addAndGet(1);
                }
            }
        });
        data.save();
        level.m_8895_().m_78151_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            HeroUnitSaveData heroData = HeroUnitSaveData.getInstance((LevelAccessor)level);
            HeroServerEvents.fallenHeroes.addAll(heroData.heroUnits);
            ReignOfNether.LOGGER.info("Loaded " + heroData.heroUnits.size() + " hero units in serverevents");
            ArrayList<TargetResourcesSave> arrayList = savedTargetResources;
            synchronized (arrayList) {
                TargetResourcesSaveData data = TargetResourcesSaveData.getInstance((LevelAccessor)level);
                savedTargetResources.addAll(data.targetData);
                ReignOfNether.LOGGER.info("Loaded " + data.targetData.size() + " gatherTargets in serverevents");
            }
        }
    }

    public static void convertAllToUnit(String ownerName, ServerLevel level, Predicate<LivingEntity> entityCondition, EntityType<? extends Unit> entityType) {
        ArrayList<Integer> oldIds = new ArrayList<Integer>();
        ArrayList<Integer> newIds = new ArrayList<Integer>();
        ArrayList<LivingEntity> unitsToConvert = new ArrayList<LivingEntity>();
        for (LivingEntity unit : UnitServerEvents.getAllUnits()) {
            if (!entityCondition.test(unit)) continue;
            unitsToConvert.add(unit);
        }
        for (LivingEntity unit : unitsToConvert) {
            if (!(unit instanceof ConvertableUnit)) continue;
            ConvertableUnit cUnit = (ConvertableUnit)unit;
            oldIds.add(unit.m_19879_());
            LivingEntity newEntity = cUnit.convertToUnit(entityType);
            if (newEntity == null) continue;
            newIds.add(newEntity.m_19879_());
        }
        if (oldIds.size() == newIds.size() && oldIds.size() > 0) {
            UnitConvertClientboundPacket.syncConvertedUnits(ownerName, oldIds, newIds);
        }
    }

    public static int getCurrentPopulation(ServerLevel level, String ownerName) {
        int currentPopulation = 0;
        for (LivingEntity entity : allUnits) {
            Unit unit;
            if (!(entity instanceof Unit) || !(unit = (Unit)entity).getOwnerName().equals(ownerName)) continue;
            currentPopulation += unit.getCost().population;
        }
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (!building.ownerName.equals(ownerName)) continue;
            if (building instanceof ProductionPlacement) {
                ProductionPlacement prodPlacement = (ProductionPlacement)building;
                for (ActiveProduction prodItem : prodPlacement.productionQueue) {
                    currentPopulation += prodItem.item.getCost((boolean)false, (String)ownerName).population;
                }
                continue;
            }
            if (!(building.getBuilding() instanceof IronGolemBuilding)) continue;
            currentPopulation += ResourceCosts.IRON_GOLEM.population;
        }
        return currentPopulation;
    }

    public static void addActionItem(String ownerName, UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos, BlockPos selectedBuildingPos) {
        UnitServerEvents.addActionItem(ownerName, action, unitId, unitIds, preselectedBlockPos, selectedBuildingPos, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addActionItem(String ownerName, UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos, BlockPos selectedBuildingPos, boolean shiftQueue) {
        if (shiftQueue) {
            List<UnitActionItem> list = unitActionSlowQueue;
            synchronized (list) {
                for (int actionableUnitId : unitIds) {
                    unitActionSlowQueue.add(new UnitActionItem(ownerName, action, unitId, new int[]{actionableUnitId}, preselectedBlockPos, selectedBuildingPos));
                }
            }
        }
        List<UnitActionItem> list = unitActionSlowQueue;
        synchronized (list) {
            for (int actionableUnitId : unitIds) {
                unitActionSlowQueue.removeIf(uai -> uai.getUnitIds().length > 0 && uai.getUnitIds()[0] == actionableUnitId);
            }
        }
        list = unitActionFastQueue;
        synchronized (list) {
            UnitActionItem uai2 = new UnitActionItem(ownerName, action, unitId, unitIds, preselectedBlockPos, selectedBuildingPos);
            if (unitActionFastQueue.isEmpty() || !unitActionFastQueue.get(0).equals(uai2) || action != UnitAction.MOVE) {
                unitActionFastQueue.add(uai2);
            }
        }
    }

    public static Relationship getUnitToEntityRelationship(Unit unit, Entity entity) {
        ItemEntity item;
        Entity entity2;
        String ownerName1 = unit.getOwnerName();
        String ownerName2 = "";
        if (entity instanceof ItemEntity && (entity2 = (item = (ItemEntity)entity).m_19749_()) instanceof Unit) {
            Unit unitItemOwner = (Unit)entity2;
            ownerName2 = unitItemOwner.getOwnerName();
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            ownerName2 = player.m_7755_().getString();
        } else if (entity instanceof Unit) {
            ownerName2 = ((Unit)entity).getOwnerName();
        } else {
            return Relationship.NEUTRAL;
        }
        if (AlliancesServerEvents.isAllied(ownerName1, ownerName2)) {
            return Relationship.FRIENDLY;
        }
        if (ownerName1.equals(ownerName2)) {
            return Relationship.FRIENDLY;
        }
        if (ownerName1.isBlank() || ownerName2.isBlank()) {
            return Relationship.NEUTRAL;
        }
        return Relationship.HOSTILE;
    }

    public static Relationship getUnitToBuildingRelationship(Unit unit, BuildingPlacement building) {
        String buildingOwnerName;
        String unitOwnerName = unit.getOwnerName();
        if (unitOwnerName.equals(buildingOwnerName = building.ownerName)) {
            return Relationship.OWNED;
        }
        if (buildingOwnerName.isBlank() || unitOwnerName.isBlank()) {
            return Relationship.NEUTRAL;
        }
        if (AlliancesServerEvents.isAllied(unitOwnerName, buildingOwnerName)) {
            return Relationship.FRIENDLY;
        }
        return Relationship.HOSTILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent evt) {
        Entity entity;
        Entity entity2;
        if (evt.getEntity() instanceof Unit && (entity2 = evt.getEntity()) instanceof Mob) {
            Mob mob = (Mob)entity2;
            mob.m_6863_(false);
            mob.m_21441_(BlockPathTypes.WATER, -1.0f);
            mob.m_21441_(BlockPathTypes.DANGER_FIRE, 1.0f);
            mob.m_21441_(BlockPathTypes.DAMAGE_FIRE, 1.0f);
            mob.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
            mob.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            mob.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
            mob.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
        }
        if ((entity = evt.getEntity()) instanceof Unit) {
            Unit unit = (Unit)entity;
            entity = evt.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity entity3 = (LivingEntity)entity;
                if (!evt.getLevel().f_46443_) {
                    allUnits.add(entity3);
                    if (unit instanceof WorkerUnit) {
                        WorkerUnit wUnit = (WorkerUnit)((Object)unit);
                        ArrayList<TargetResourcesSave> arrayList = savedTargetResources;
                        synchronized (arrayList) {
                            savedTargetResources.removeIf(sr -> {
                                if (sr.unitUUID.equals(entity3.m_20149_())) {
                                    wUnit.getGatherResourceGoal().saveData = sr;
                                    wUnit.getGatherResourceGoal().loadState();
                                    ReignOfNether.LOGGER.info("loaded gatherTarget in serverevents: " + sr.gatherTarget);
                                    return true;
                                }
                                return false;
                            });
                        }
                    }
                    ((Unit)entity3).setupEquipmentAndUpgradesServer();
                    ChunkAccess chunk = evt.getLevel().m_46865_(entity3.m_20097_());
                    ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)evt.getLevel()), (String)"reignofnether", (Entity)entity3, (int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_, (boolean)true, (boolean)true);
                    forcedUnitChunks.add((Pair<Integer, ChunkAccess>)new Pair((Object)entity3.m_19879_(), (Object)chunk));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveLevelEvent evt) {
        Entity entity;
        if (evt.getEntity() instanceof Unit && (entity = evt.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (!evt.getLevel().f_46443_) {
                allUnits.removeIf(e -> e.m_19879_() == entity2.m_19879_());
                UnitSyncClientboundPacket.sendLeavePacket(entity2);
            }
        }
        ArrayList<LivingEntity> arrayList = allUnits;
        synchronized (arrayList) {
            try {
                Entity entity3 = evt.getEntity();
                if (entity3 instanceof Unit) {
                    Unit unit = (Unit)entity3;
                    int unitsOwned = allUnits.stream().filter(u -> {
                        Unit unit1;
                        return u instanceof Unit && (unit1 = (Unit)u).getOwnerName().equals(unit.getOwnerName());
                    }).toList().size();
                    if (!SandboxServer.isSandboxPlayer(unit.getOwnerName()) && unitsOwned == 0 && PlayerServerEvents.isRTSPlayer(unit.getOwnerName()) && BuildingUtils.getTotalCompletedBuildingsOwned(false, unit.getOwnerName()) == 0) {
                        PlayerServerEvents.defeat(unit.getOwnerName(), Component.m_237115_((String)"server.reignofnether.lost_all").getString());
                    }
                }
            }
            catch (ConcurrentModificationException e2) {
                System.out.println("Caught ConcurrentModificationException in UnitServerEvents EntityLeaveLevelEvent: " + e2.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent evt) {
        Entity serverLevel22;
        Unit unitKilled;
        Entity entityType;
        boolean slimeInfected;
        LivingEntity livingEntity;
        for (BuildingPlacement buildingPlacement : BuildingServerEvents.getBuildings()) {
            BlockPos bp;
            if (!(buildingPlacement instanceof SculkCatalystPlacement)) continue;
            SculkCatalystPlacement sc = (SculkCatalystPlacement)buildingPlacement;
            if (!(evt.getEntity().m_20238_(Vec3.m_82512_((Vec3i)sc.centrePos)) < 100.0)) continue;
            Level level = evt.getEntity().m_9236_();
            if (level.m_8055_(bp = evt.getEntity().m_20097_()).m_60734_() == Blocks.f_152481_) {
                level.m_46597_(bp, Blocks.f_50493_.m_49966_());
            }
            if (level.m_8055_(bp.m_7494_()).m_60734_() instanceof IPlantable) {
                level.m_46961_(bp.m_7494_(), false);
            }
            for (int x = -3; x <= 3; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -3; z <= 3; ++z) {
                        BlockPos bp2 = bp.m_7918_(x, y, z);
                        BlockState bs = level.m_8055_(bp2);
                        if (bp2.m_123333_((Vec3i)bp) > 3 || bs.m_60734_() != Blocks.f_152481_) continue;
                        level.m_46597_(bp2, Blocks.f_50493_.m_49966_());
                    }
                }
            }
        }
        LivingEntity livingEntity2 = evt.getEntity();
        if (livingEntity2 instanceof Unit) {
            Unit unit = (Unit)livingEntity2;
            List<ItemStack> list = unit.getItems();
            for (ItemStack itemStack : list) {
                evt.getEntity().m_19983_(itemStack);
            }
        }
        if ((livingEntity = evt.getEntity()) instanceof CreeperUnit) {
            CreeperUnit creeperUnit = (CreeperUnit)livingEntity;
            if (!PlayerServerEvents.rtsPlayers.isEmpty()) {
                creeperUnit.m_32315_();
            }
        }
        LivingEntity lastHurtByMob = evt.getEntity().m_21188_();
        boolean bl = evt.getEntity().m_21221_().containsKey(MobEffectRegistrar.ZOMBIE_INFECTED.get()) || lastHurtByMob instanceof DrownedUnit;
        boolean bl2 = slimeInfected = evt.getEntity().m_21221_().containsKey(MobEffects.f_19604_) || lastHurtByMob instanceof SlimeUnit && !(lastHurtByMob instanceof MagmaCubeUnit);
        if (lastHurtByMob instanceof Unit) {
            Unit unit = (Unit)lastHurtByMob;
            if (bl || slimeInfected) {
                Level y;
                entityType = null;
                if (bl) {
                    if (evt.getEntity() instanceof GruntUnit || evt.getEntity() instanceof BruteUnit || evt.getEntity() instanceof HeadhunterUnit) {
                        entityType = (EntityType)EntityRegistrar.ZOMBIE_PIGLIN_UNIT.get();
                    } else if (evt.getEntity() instanceof HoglinUnit) {
                        entityType = (EntityType)EntityRegistrar.ZOGLIN_UNIT.get();
                    } else if (evt.getEntity() instanceof VillagerUnit) {
                        entityType = (EntityType)EntityRegistrar.ZOMBIE_VILLAGER_UNIT.get();
                    } else if (evt.getEntity() instanceof VindicatorUnit || evt.getEntity() instanceof PillagerUnit || evt.getEntity() instanceof EvokerUnit || evt.getEntity() instanceof WitchUnit) {
                        entityType = (EntityType)EntityRegistrar.DROWNED_UNIT.get();
                    }
                }
                if (slimeInfected && entityType == null) {
                    entityType = (EntityType)EntityRegistrar.SLIME_UNIT.get();
                }
                if (entityType != null && (y = evt.getEntity().m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel22 = (ServerLevel)y;
                    Entity entity = entityType.m_262455_(serverLevel22, (CompoundTag)null, null, evt.getEntity().m_20097_(), MobSpawnType.SPAWNER, true, false);
                    if (entity instanceof SlimeUnit) {
                        SlimeUnit sUnit = (SlimeUnit)entity;
                        LivingEntity livingEntity3 = evt.getEntity();
                        if (livingEntity3 instanceof Unit) {
                            Unit originalEntity = (Unit)livingEntity3;
                            sUnit.m_7839_(Mth.m_14045_((int)(originalEntity.getCost().population - 1), (int)1, (int)5), true);
                        }
                    }
                    if (entity instanceof Unit) {
                        Unit convertedUnit = (Unit)entity;
                        convertedUnit.setOwnerName(unit.getOwnerName());
                        entity.m_146922_(evt.getEntity().m_146908_());
                    }
                }
            }
        }
        if ((entityType = evt.getSource().m_7639_()) instanceof VillagerUnit) {
            VillagerUnit vUnit = (VillagerUnit)entityType;
            if (ResourceSources.isHuntableAnimal(evt.getEntity())) {
                vUnit.incrementHunterExp();
                if (!(evt.getEntity() instanceof Chicken)) {
                    vUnit.incrementHunterExp();
                }
            }
        }
        if ((entityType = evt.getEntity()) instanceof Unit && (unitKilled = (Unit)entityType).getOwnerName().isEmpty() && (serverLevel22 = evt.getSource().m_7639_()) instanceof Unit) {
            Unit unit = (Unit)serverLevel22;
            ResourceCost cost = unitKilled.getCost();
            Resources resources = new Resources(unit.getOwnerName(), (int)((float)cost.food * 0.25f), (int)((float)cost.wood * 0.25f), (int)((float)cost.ore * 0.25f));
            if (resources.getTotalValue() > 0) {
                ResourcesClientboundPacket.showFloatingText(resources, evt.getEntity().m_20097_());
                ResourcesServerEvents.addSubtractResources(resources);
            }
        }
        if (!(evt.getEntity() instanceof NecromancerUnit) && !evt.getEntity().m_9236_().m_5776_()) {
            Vec3 pos = evt.getEntity().m_20182_();
            List necromancers = MiscUtil.getEntitiesWithinRange(new Vector3d(pos.f_82479_, pos.f_82480_, pos.f_82481_), (float)SoulSiphonPassive.RANGE, NecromancerUnit.class, evt.getEntity().m_9236_()).stream().toList();
            for (NecromancerUnit necromancerUnit : necromancers) {
                SoulSiphonPassive soulSiphon = necromancerUnit.getSoulSiphon();
                if (soulSiphon == null) continue;
                soulSiphon.checkAndGainSouls(evt.getEntity(), necromancers.size(), necromancerUnit);
                AbilityClientboundPacket.doAbility(necromancerUnit.m_19879_(), UnitAction.SOUL_SIPHON_UPDATE, necromancerUnit.souls);
            }
        }
    }

    @SubscribeEvent
    public static void onDropItem(LivingDropsEvent evt) {
        Object object;
        if (ResourceSources.isHuntableAnimal(evt.getEntity()) && !evt.getSource().m_269533_(DamageTypeTags.f_268731_) && (object = evt.getSource().m_7639_()) instanceof Unit) {
            Mob mob;
            Unit unit = (Unit)object;
            if (evt.getSource().m_7639_() instanceof WorkerUnit && (object = evt.getSource().m_7639_()) instanceof Mob && (mob = (Mob)object).m_21531_() && !Unit.atMaxResources(unit)) {
                evt.setCanceled(true);
                if (lastHuntedAnimalId != evt.getEntity().m_19879_()) {
                    for (ItemStack itemStack : ResourceSources.getFoodItemsFromAnimal((Animal)evt.getEntity())) {
                        ResourceSource res = ResourceSources.getFromItem(itemStack.m_41720_());
                        if (res == null) continue;
                        unit.getItems().add(itemStack);
                        if (!(unit instanceof VillagerUnit)) continue;
                        VillagerUnit vUnit = (VillagerUnit)unit;
                        vUnit.incrementHunterExp();
                        if (evt.getEntity() instanceof Chicken) continue;
                        vUnit.incrementHunterExp();
                    }
                    if (Unit.atThresholdResources(unit)) {
                        unit.getReturnResourcesGoal().returnToClosestBuilding();
                    }
                } else {
                    lastHuntedAnimalId = evt.getEntity().m_19879_();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || evt.level.m_5776_() || evt.level.m_46472_() != Level.f_46428_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)evt.level;
        if (--unitSyncTicks <= 0) {
            unitSyncTicks = 20;
            UnitIdleWorkerClientBoundPacket.sendIdleWorkerPacket();
            for (LivingEntity entity : allUnits) {
                MobEffect me2;
                if (entity instanceof Unit) {
                    VillagerUnit vUnit;
                    Unit unit = (Unit)entity;
                    UnitSyncClientboundPacket.sendSyncResourcesPacket(unit);
                    UnitSyncClientboundPacket.sendSyncStatsPacket(entity);
                    for (MobEffect me2 : List.of(MobEffects.f_19606_, (MobEffect)MobEffectRegistrar.STUN.get())) {
                        MobEffectInstance mei = entity.m_21124_(me2);
                        if (mei != null) {
                            UnitSyncMobEffectsClientboundPacket.addEffectClientside(entity, mei);
                            continue;
                        }
                        UnitSyncMobEffectsClientboundPacket.removeEffectClientside(entity, me2);
                    }
                    if (unit.getAnchor() != null) {
                        UnitSyncClientboundPacket.sendSyncAnchorPosPacket(entity, unit.getAnchor());
                    } else {
                        UnitSyncClientboundPacket.sendRemoveAnchorPosPacket(entity);
                    }
                    if (entity instanceof VillagerUnit && (vUnit = (VillagerUnit)entity).isVeteran()) {
                        UnitSyncClientboundPacket.makeVillagerVeteran((LivingEntity)vUnit);
                    }
                }
                if (entity instanceof WorkerUnit) {
                    UnitSyncWorkerClientBoundPacket.sendSyncWorkerPacket(entity);
                }
                boolean chunkNeedsUpdate = false;
                ChunkAccess newChunk = evt.level.m_46865_(entity.m_20097_());
                me2 = forcedUnitChunks.iterator();
                while (me2.hasNext()) {
                    Pair<Integer, ChunkAccess> forcedChunk = me2.next();
                    int id = (Integer)forcedChunk.getFirst();
                    ChunkAccess chunk = (ChunkAccess)forcedChunk.getSecond();
                    if (id != entity.m_19879_() || chunk.m_7697_().f_45578_ == newChunk.m_7697_().f_45578_ && chunk.m_7697_().f_45579_ == newChunk.m_7697_().f_45579_) continue;
                    ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)evt.level), (String)"reignofnether", (Entity)entity, (int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_, (boolean)false, (boolean)true);
                    chunkNeedsUpdate = true;
                }
                if (!chunkNeedsUpdate) continue;
                forcedUnitChunks.removeIf(p -> ((Integer)p.getFirst()).intValue() == entity.m_19879_());
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)evt.level), (String)"reignofnether", (Entity)entity, (int)newChunk.m_7697_().f_45578_, (int)newChunk.m_7697_().f_45579_, (boolean)true, (boolean)true);
                forcedUnitChunks.add((Pair<Integer, ChunkAccess>)new Pair((Object)entity.m_19879_(), (Object)newChunk));
            }
        }
        List<UnitActionItem> list = unitActionSlowQueue;
        synchronized (list) {
            UnitActionItem actionedItem = null;
            for (UnitActionItem uai : unitActionSlowQueue) {
                Unit unit;
                Entity entity;
                if (uai.getUnitIds().length <= 0 || !((entity = evt.level.m_6815_(uai.getUnitIds()[0])) instanceof Unit) || !(unit = (Unit)entity).isIdle()) continue;
                uai.action(evt.level);
                actionedItem = uai;
                break;
            }
            if (actionedItem != null) {
                unitActionSlowQueue.remove(actionedItem);
            }
        }
        list = unitActionFastQueue;
        synchronized (list) {
            for (UnitActionItem actionItem : unitActionFastQueue) {
                actionItem.action(evt.level);
            }
            unitActionFastQueue.clear();
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn evt) {
        if (!evt.getSpawnType().equals((Object)MobSpawnType.SPAWN_EGG)) {
            return;
        }
        Mob entity = evt.getEntity();
        if (evt.getEntity() instanceof Unit) {
            Vec3 pos = entity.m_20182_();
            List<Player> nearbyPlayers = MiscUtil.getEntitiesWithinRange(new Vector3d(pos.f_82479_, pos.f_82480_, pos.f_82481_), 10.0f, Player.class, evt.getEntity().m_9236_());
            float closestPlayerDist = 10.0f;
            Player closestPlayer = null;
            for (Player player : nearbyPlayers) {
                if (!(player.m_20270_((Entity)entity) < closestPlayerDist) || !PlayerServerEvents.isRTSPlayer(player.m_7755_().getString())) continue;
                closestPlayerDist = player.m_20270_((Entity)entity);
                closestPlayer = player;
            }
            if (closestPlayer != null) {
                ((Unit)entity).setOwnerName(closestPlayer.m_7755_().getString());
            }
        }
    }

    private static boolean shouldIgnoreKnockback(LivingDamageEvent evt) {
        SlimeUnit slimeUnit;
        Entity projectile = evt.getSource().m_7640_();
        Entity shooter = evt.getSource().m_7639_();
        if (shooter instanceof HeadhunterUnit) {
            HeadhunterUnit headhunterUnit = (HeadhunterUnit)shooter;
            if (projectile instanceof ThrownTrident) {
                return !ResearchServerEvents.playerHasResearch(headhunterUnit.getOwnerName(), ProductionItems.RESEARCH_HEAVY_TRIDENTS);
            }
        }
        if (shooter instanceof SlimeUnit && (slimeUnit = (SlimeUnit)shooter).m_33633_()) {
            return true;
        }
        if (projectile instanceof Fireball && shooter instanceof BlazeUnit) {
            return true;
        }
        if (projectile instanceof AbstractArrow) {
            return true;
        }
        return evt.getSource().m_269533_(DamageTypeTags.f_268731_) && evt.getSource().m_269014_() && !(shooter instanceof EvokerUnit);
    }

    public static Entity spawnMob(EntityType<? extends Mob> entityType, ServerLevel level, Vec3i pos, String ownerName) {
        ArrayList<Entity> entities = UnitServerEvents.spawnMobs(entityType, level, pos, 1, ownerName);
        if (entities.isEmpty()) {
            return null;
        }
        Entity entity = entities.get(0);
        if (entity instanceof SlimeUnit) {
            SlimeUnit slimeUnit = (SlimeUnit)entity;
            slimeUnit.m_7839_(2, true);
        }
        return entities.get(0);
    }

    public static ArrayList<Entity> spawnMobs(EntityType<? extends Mob> entityType, ServerLevel level, Vec3i pos, int qty, String ownerName) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (level != null) {
            for (int i = 0; i < qty; ++i) {
                Entity entity = entityType.m_20615_((Level)level);
                if (entity == null) continue;
                entity.m_6027_((double)(pos.m_7494_().m_123341_() + i), (double)pos.m_7494_().m_123342_(), (double)pos.m_7494_().m_123343_());
                entities.add(entity);
                if (entity instanceof Unit) {
                    Unit unit = (Unit)entity;
                    unit.setOwnerName(ownerName);
                }
                level.m_7967_(entity);
            }
        }
        return entities;
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingDamageEvent evt) {
        HeadhunterUnit headhunterUnit;
        Entity entity;
        Entity entity2;
        Entity entity3;
        Entity entity4;
        AttackerUnit attackerUnit;
        Unit unit;
        VillagerUnit vUnit;
        CreeperUnit creeperUnit;
        Entity entity5;
        if (UnitServerEvents.shouldIgnoreKnockback(evt)) {
            knockbackIgnoreIds.add(evt.getEntity().m_19879_());
        }
        if ((entity5 = evt.getSource().m_7639_()) instanceof CreeperUnit && UnitServerEvents.getUnitToEntityRelationship(creeperUnit = (CreeperUnit)entity5, (Entity)evt.getEntity()) == Relationship.FRIENDLY) {
            evt.setAmount(evt.getAmount() / 2.0f);
            if (evt.getEntity() instanceof CreeperUnit) {
                evt.setAmount(evt.getAmount() / 2.0f);
            }
        }
        if (ResourceSources.isHuntableAnimal(evt.getEntity()) && evt.getSource().m_7639_() instanceof MilitiaUnit) {
            evt.setAmount(1.0f);
            return;
        }
        if (ResourceSources.isHuntableAnimal(evt.getEntity()) && (entity5 = evt.getSource().m_7639_()) instanceof VillagerUnit && (vUnit = (VillagerUnit)entity5).getUnitProfession() == VillagerUnitProfession.HUNTER) {
            if (vUnit.isVeteran()) {
                evt.setAmount(2.0f);
            } else {
                evt.setAmount(1.5f);
            }
            return;
        }
        if (evt.getEntity() instanceof Unit && (evt.getSource() == evt.getEntity().m_269291_().m_269555_() || evt.getSource() == evt.getEntity().m_269291_().m_269325_())) {
            evt.setCanceled(true);
            return;
        }
        if (evt.getSource().m_7639_() instanceof GhastUnit && (!((entity5 = evt.getEntity()) instanceof Unit) || GarrisonableBuilding.getGarrison(unit = (Unit)entity5) == null)) {
            evt.setAmount(evt.getAmount() / 2.0f);
        }
        if (evt.getSource().m_269533_(DamageTypeTags.f_268524_) && (entity5 = evt.getSource().m_7639_()) instanceof AttackerUnit) {
            attackerUnit = (AttackerUnit)entity5;
            float dmg = attackerUnit.getUnitAttackDamage();
            LivingEntity livingEntity = evt.getEntity();
            if (livingEntity instanceof Unit) {
                Unit unit2 = (Unit)livingEntity;
                dmg *= 1.0f - unit2.getUnitPhysicalArmorPercentage();
                dmg *= 1.0f - unit2.getUnitRangedArmorPercentage();
                dmg *= 1.0f - unit2.getUnitResistPercentage();
            }
            evt.setAmount(dmg);
        }
        if (evt.getSource().m_7639_() instanceof WorkerUnit && (entity4 = evt.getSource().m_7639_()) instanceof AttackerUnit) {
            attackerUnit = (AttackerUnit)entity4;
            evt.setAmount(attackerUnit.getUnitAttackDamage());
        }
        if (evt.getSource() == evt.getEntity().m_269291_().m_269548_()) {
            if (evt.getEntity() instanceof CreeperUnit) {
                evt.setCanceled(true);
            } else {
                evt.setAmount(evt.getAmount() / 2.0f);
            }
        }
        if (evt.getSource().m_7639_() instanceof WorkerUnit && (entity3 = evt.getSource().m_7639_()) instanceof AttackerUnit) {
            attackerUnit = (AttackerUnit)entity3;
            evt.setAmount(attackerUnit.getUnitAttackDamage());
        }
        if (evt.getSource() == evt.getEntity().m_269291_().m_269548_()) {
            if (evt.getEntity() instanceof CreeperUnit) {
                evt.setCanceled(true);
            } else {
                evt.setAmount(evt.getAmount() / 2.0f);
            }
        }
        if (evt.getEntity() instanceof Unit && evt.getSource() == evt.getEntity().m_269291_().m_269318_()) {
            evt.setCanceled(true);
        }
        if (evt.getSource().m_269533_(DamageTypeTags.f_268524_) && (entity2 = evt.getSource().m_7639_()) instanceof Unit && UnitServerEvents.getUnitToEntityRelationship(unit = (Unit)entity2, (Entity)evt.getEntity()) == Relationship.FRIENDLY && unit.getTargetGoal().getTarget() != evt.getEntity()) {
            evt.setCanceled(true);
        }
        if (evt.getEntity().m_6103_() > 0.0f) {
            UnitSyncClientboundPacket.sendSyncStatsPacket(evt.getEntity());
        }
        if ((entity = evt.getSource().m_7639_()) instanceof HeadhunterUnit && (headhunterUnit = (HeadhunterUnit)entity).hasFireAspectTrident() && evt.getAmount() > 0.0f) {
            evt.getEntity().m_20254_(4);
        }
    }

    @SubscribeEvent
    public static void onLightningStrike(EntityStruckByLightningEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof CreeperUnit) {
            CreeperUnit creeperUnit = (CreeperUnit)entity;
            creeperUnit.m_20254_(0);
        }
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent evt) {
        Entity owner = evt.getProjectile().m_19749_();
        Entity hit = null;
        if (evt.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY) {
            hit = ((EntityHitResult)evt.getRayTraceResult()).m_82443_();
        }
        if (owner instanceof GhastUnit && hit != null && !(hit instanceof GhastUnit)) {
            evt.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
        }
        if (owner instanceof Unit) {
            Unit unit = (Unit)owner;
            if (hit != null && UnitServerEvents.getUnitToEntityRelationship(unit, hit) == Relationship.FRIENDLY && unit.getTargetGoal().getTarget() != hit) {
                AbstractArrow arrow;
                Projectile projectile = evt.getProjectile();
                if (projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).m_36796_() > 0) {
                    return;
                }
                evt.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent evt) {
        if (evt.getEntity() instanceof GhastUnit) {
            evt.setCanceled(true);
            return;
        }
        LivingEntity livingEntity = evt.getEntity();
        if (livingEntity instanceof BruteUnit) {
            BruteUnit bruteUnit = (BruteUnit)livingEntity;
            if (bruteUnit.isHoldingUpShield) {
                evt.setCanceled(true);
                return;
            }
        }
        if (!knockbackIgnoreIds.removeIf(i -> i.intValue() == evt.getEntity().m_19879_())) return;
        evt.setCanceled(true);
    }

    public static void debug1() {
    }

    public static void debug2() {
    }
}

