/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.registrars.MobEffectRegistrar;
import com.solegendary.reignofnether.unit.goals.RangedAttackBuildingGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class UnitCrossbowAttackGoal<T extends Monster & CrossbowAttackMob>
extends Goal {
    private final Random random = new Random();
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private int seeTime;
    private int attackCooldown;
    private int attackCooldownMax;
    private int windupTime = this.random.nextInt(0, 6);
    private static final int GARRISON_BONUS_RANGE_TO_GHASTS = 10;

    public UnitCrossbowAttackGoal(T mob, int attackCooldown) {
        this.mob = mob;
        this.attackCooldownMax = attackCooldown;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setToMaxAttackCooldown() {
        this.attackCooldown = this.attackCooldownMax;
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
    }

    public boolean m_8045_() {
        if (!this.isValidTarget() || !this.isHoldingCrossbow()) {
            return false;
        }
        return this.m_8036_() || !this.mob.m_21573_().m_26571_();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() || this.getBuildingTarget() != null;
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        this.attackCooldown = this.attackCooldownMax;
        this.windupTime = this.random.nextInt(0, 6);
    }

    private BuildingPlacement getBuildingTarget() {
        PillagerUnit pUnit;
        Object object = this.mob;
        if (object instanceof PillagerUnit && (object = (pUnit = (PillagerUnit)object).getAttackBuildingGoal()) instanceof RangedAttackBuildingGoal) {
            RangedAttackBuildingGoal rabg = (RangedAttackBuildingGoal)((Object)object);
            return rabg.getBuildingTarget();
        }
        return null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void tickChargeCrossbow() {
        int i;
        ItemStack itemstack = this.mob.m_6844_(EquipmentSlot.MAINHAND);
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            int ticks = CrossbowItem.m_40939_((ItemStack)itemstack);
            this.mob.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistrar.MINOR_MOVEMENT_SLOWDOWN.get(), ticks, 3, true, false));
            this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
            this.crossbowState = CrossbowState.CHARGING;
            ((CrossbowAttackMob)this.mob).m_6136_(true);
        } else if (this.crossbowState == CrossbowState.CHARGING && (i = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)itemstack) + this.windupTime) {
            this.mob.m_21253_();
            this.crossbowState = CrossbowState.CHARGED;
            this.attackCooldown = this.attackCooldownMax;
            ((CrossbowAttackMob)this.mob).m_6136_(false);
            this.windupTime = this.random.nextInt(0, 6);
        }
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        BuildingPlacement buildTarget = this.getBuildingTarget();
        if (target != null && target.m_6084_() || buildTarget != null) {
            boolean flag;
            GarrisonableBuilding garr = GarrisonableBuilding.getGarrison((Unit)this.mob);
            GarrisonableBuilding targetGarr = null;
            if (target instanceof Unit) {
                Unit unit = (Unit)target;
                targetGarr = GarrisonableBuilding.getGarrison(unit);
            }
            boolean isGarrisoned = garr != null;
            boolean isTargetGarrisoned = targetGarr != null;
            boolean canSeeTarget = true;
            if (target != null) {
                canSeeTarget = this.mob.m_21574_().m_148306_((Entity)target) || isGarrisoned || isTargetGarrisoned;
            }
            boolean bl = flag = this.seeTime > 0;
            if (canSeeTarget != flag) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            double distToTarget = target != null ? (double)this.mob.m_20270_((Entity)target) : Math.sqrt(this.mob.m_20275_((double)buildTarget.centrePos.m_123341_(), (double)buildTarget.centrePos.m_123342_(), (double)buildTarget.centrePos.m_123343_()));
            float attackRange = ((AttackerUnit)this.mob).getAttackRange();
            if (isGarrisoned) {
                attackRange = garr.getAttackRange();
                if (target instanceof GhastUnit) {
                    attackRange += 10.0f;
                }
            } else if (isTargetGarrisoned) {
                attackRange += (float)targetGarr.getExternalAttackRangeBonus();
            } else if (target instanceof GhastUnit) {
                GhastUnit ghastUnit = (GhastUnit)target;
                attackRange += (float)ghastUnit.getAttackerRangeBonus((Mob)this.mob);
            }
            if (!this.mob.m_20159_()) {
                if (!(!(distToTarget > (double)attackRange) && canSeeTarget || ((Unit)this.mob).getHoldPosition())) {
                    if (target != null) {
                        this.mob.m_21573_().m_5624_((Entity)target, 1.0);
                    } else {
                        this.mob.m_21573_().m_26519_((double)buildTarget.centrePos.m_123341_(), (double)buildTarget.centrePos.m_123342_(), (double)buildTarget.centrePos.m_123343_(), 1.0);
                    }
                } else {
                    this.mob.m_21573_().m_26573_();
                }
            }
            if (target != null) {
                this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                this.mob.m_21563_().m_24950_((double)buildTarget.centrePos.m_123341_(), (double)buildTarget.centrePos.m_123342_(), (double)buildTarget.centrePos.m_123343_(), 30.0f, 30.0f);
            }
            if (this.crossbowState == CrossbowState.CHARGED) {
                --this.attackCooldown;
                if (this.attackCooldown <= 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && canSeeTarget && distToTarget < (double)attackRange) {
                ((CrossbowAttackMob)this.mob).m_32336_(this.mob, 1.6f);
                ItemStack itemstack1 = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

