/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.modelling.models;

import com.solegendary.reignofnether.unit.interfaces.KeyframeAnimated;
import java.util.function.Function;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public abstract class KeyframeHierarchicalModel<E extends Entity>
extends HierarchicalModel<E> {
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();
    protected float ageInTicksOffset = 0.0f;

    public KeyframeHierarchicalModel() {
        this(RenderType::m_110458_);
    }

    public KeyframeHierarchicalModel(Function<ResourceLocation, RenderType> p_170623_) {
        super(p_170623_);
    }

    protected void m_267799_(AnimationDefinition animDef, float limbSwing, float limbSwingAmount, float limbSwingSpeed, float limbSwingAmountSpeed) {
        long i = (long)(limbSwing * 50.0f * limbSwingSpeed);
        float f = Math.min(limbSwingAmount * limbSwingAmountSpeed, 1.0f);
        KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)animDef, (long)i, (float)f, (Vector3f)ANIMATION_VECTOR_CACHE);
    }

    protected void restart(KeyframeAnimated kfa, AnimationState animState, AnimationDefinition animDef, float ageInTicks) {
        if (!animState.m_216984_()) {
            this.ageInTicksOffset = ageInTicks;
            kfa.stopAllAnimations();
            animState.m_216977_(0);
        }
    }

    protected void restartThenAnimate(KeyframeAnimated kfa, AnimationState animState, AnimationDefinition animDef, float ageInTicks) {
        this.restartThenAnimate(kfa, animState, animDef, ageInTicks, 1.0f);
    }

    protected void restartThenAnimate(KeyframeAnimated kfa, AnimationState animState, AnimationDefinition animDef, float ageInTicks, float scale) {
        this.restart(kfa, animState, animDef, ageInTicks);
        animState.m_216974_(ageInTicks - this.ageInTicksOffset, 1.0f);
        animState.m_216979_(time -> KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)animDef, (long)time.m_216981_(), (float)scale, (Vector3f)ANIMATION_VECTOR_CACHE));
    }

    protected void m_288214_(AnimationDefinition animDef) {
        KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)animDef, (long)0L, (float)1.0f, (Vector3f)ANIMATION_VECTOR_CACHE);
    }
}

