/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UnitConvertClientboundPacket {
    private final String ownerName;
    private final int[] oldUnitIds;
    private final int[] newUnitIds;

    public static void syncConvertedUnits(String ownerName, List<Integer> oldUnitIds, List<Integer> newUnitIds) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitConvertClientboundPacket(ownerName, oldUnitIds.stream().mapToInt(i -> i).toArray(), newUnitIds.stream().mapToInt(i -> i).toArray()));
    }

    public UnitConvertClientboundPacket(String ownerName, int[] oldUnitIds, int[] newUnitIds) {
        this.ownerName = ownerName;
        this.oldUnitIds = oldUnitIds;
        this.newUnitIds = newUnitIds;
    }

    public UnitConvertClientboundPacket(FriendlyByteBuf buffer) {
        this.ownerName = buffer.m_130277_();
        this.oldUnitIds = buffer.m_130100_();
        this.newUnitIds = buffer.m_130100_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.ownerName);
        buffer.m_130089_(this.oldUnitIds);
        buffer.m_130089_(this.newUnitIds);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            UnitClientEvents.syncConvertedUnits(this.ownerName, this.oldUnitIds, this.newUnitIds);
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

