/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.ability.abilities.Eject;
import com.solegendary.reignofnether.ability.abilities.SpiderClimbing;
import com.solegendary.reignofnether.ability.abilities.SpinWebs;
import com.solegendary.reignofnether.blocks.BlockServerEvents;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.ConvertableUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SpiderUnit
extends Spider
implements Unit,
AttackerUnit,
ConvertableUnit {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    private boolean shouldDiscard = false;
    public static final float attackDamage = 5.0f;
    public static final float attacksPerSecond = 0.6f;
    public static final float maxHealth = 30.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.34f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    private boolean wallClimbing = true;
    public int maxResources = 100;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private GenericTargetedSpellGoal webGoal;
    protected Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return null;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 33;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.6f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.34f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 5.0f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 30.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.SPIDER;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public boolean shouldDiscard() {
        return this.shouldDiscard;
    }

    @Override
    public void setShouldDiscard(boolean discard) {
        this.shouldDiscard = discard;
    }

    public GenericTargetedSpellGoal getWebGoal() {
        return this.webGoal;
    }

    @Nullable
    public SpinWebs getWebAbility() {
        for (Ability ability : this.getAbilities().get()) {
            if (!(ability instanceof SpinWebs)) continue;
            SpinWebs spinWebs = (SpinWebs)ability;
            return spinWebs;
        }
        return null;
    }

    public SpiderUnit(EntityType<? extends Spider> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isWallClimbing() {
        return this.wallClimbing;
    }

    public boolean toggleWallClimbing() {
        this.wallClimbing = !this.wallClimbing;
        this.f_21344_ = this.wallClimbing ? new WallClimberNavigation((Mob)this, this.m_9236_()) : new GroundPathNavigation((Mob)this, this.m_9236_());
        return this.wallClimbing;
    }

    public boolean m_33816_() {
        if (this.wallClimbing) {
            return super.m_33816_();
        }
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.34f).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22276_, 30.0);
    }

    @Override
    public void resetBehaviours() {
        this.getMoveGoal().setMoveTarget(this.m_20097_());
        if (this.getWebGoal() != null) {
            this.getWebGoal().m_8041_();
        }
    }

    public void m_8119_() {
        if (this.shouldDiscard) {
            this.m_146870_();
        } else {
            this.m_21553_(false);
            super.m_8119_();
            Unit.tick(this);
            AttackerUnit.tick(this);
            if (this.getWebGoal() != null) {
                this.getWebGoal().m_8037_();
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public Unit.SunlightEffect getSunlightEffect() {
        return Unit.SunlightEffect.SLOWNESS_II;
    }

    public void m_6074_() {
        super.m_6074_();
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.attackGoal = new MeleeAttackUnitGoal((Mob)this, false);
        this.attackBuildingGoal = new MeleeAttackBuildingGoal((Mob)this);
        this.webGoal = new GenericTargetedSpellGoal((Mob)this, 0, 8.0f, this::onEntityCastWeb, this::onGroundCastWeb, null);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(2, (Goal)this.webGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        if (super.m_7327_(pEntity)) {
            if (this.getWebAbility() != null && this.getWebAbility().isAutocasting(this)) {
                this.getWebAbility().use(this.m_9236_(), (Unit)this, pEntity.m_20097_());
            }
            return true;
        }
        return false;
    }

    public void onEntityCastWeb(LivingEntity targetEntity) {
        this.onGroundCastWeb(targetEntity.m_20097_());
    }

    public void onGroundCastWeb(BlockPos targetBp) {
        SpinWebs spinWebs = this.getWebAbility();
        if (spinWebs == null) {
            return;
        }
        if (!this.m_9236_().m_5776_() && !this.m_20160_()) {
            BlockPos limitedBp = MyMath.getXZRangeLimitedBlockPos(this.m_20097_(), targetBp, spinWebs.range);
            BlockPos originBp = MiscUtil.getHighestNonAirBlock(this.m_9236_(), limitedBp, true);
            List<Vec2> vec2s = List.of(new Vec2(0.0f, 0.0f), new Vec2(1.0f, 1.0f), new Vec2(-1.0f, -1.0f), new Vec2(1.0f, -1.0f), new Vec2(-1.0f, 1.0f));
            for (Vec2 vec2 : vec2s) {
                BlockPos bp = MiscUtil.getHighestNonAirBlock(this.m_9236_(), limitedBp.m_7918_((int)vec2.f_82470_, 0, (int)vec2.f_82471_), true);
                if (!(this.m_20238_(Vec3.m_82512_((Vec3i)bp)) < (double)(spinWebs.range * 2.0f * (spinWebs.range * 2.0f)))) continue;
                BlockServerEvents.addTempBlock((ServerLevel)this.m_9236_(), bp.m_7494_().m_7494_(), Blocks.f_50033_.m_49966_(), Blocks.f_50016_.m_49966_(), 120);
            }
            this.resetBehaviours();
        } else if (this.m_9236_().m_5776_() && this.m_20160_()) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.spin_webs.error1", (Object[])new Object[0]));
            return;
        }
        if (!this.m_20160_()) {
            spinWebs.setToMaxCooldown(this);
            if (!this.m_9236_().m_5776_()) {
                AbilityClientboundPacket.sendSetCooldownPacket(this.m_19879_(), spinWebs.action, spinWebs.cooldownMax);
            }
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource == this.m_269291_().m_268989_()) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    static {
        ABILITIES.add(new SpiderClimbing(), Keybindings.keyQ);
        ABILITIES.add(new Eject(), Keybindings.keyW);
        ABILITIES.add(new SpinWebs(), Keybindings.keyE);
        ownerDataAccessor = SynchedEntityData.m_135353_(SpiderUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

