/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.piglins;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.Bloodlust;
import com.solegendary.reignofnether.ability.abilities.MountHoglin;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.piglins.BasaltSprings;
import com.solegendary.reignofnether.building.buildings.piglins.FlameSanctuary;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MountGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UnitBowAttackGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HeadhunterUnit
extends PiglinBrute
implements Unit,
AttackerUnit,
RangedAttackerUnit {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    public MountGoal mountGoal;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    private BlockPos attackMoveTarget = null;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    private UnitBowAttackGoal<? extends LivingEntity> attackGoal;
    public static final float attackDamage = 6.0f;
    public static final float attacksPerSecond = 0.3f;
    public static final float attackRange = 14.0f;
    public static final float aggroRange = 14.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public static final float maxHealth = 40.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.24f;
    public int maxResources = 100;
    public int bloodlustTicks = 0;
    public int fogRevealDuration = 0;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    public MountGoal getMountGoal() {
        return this.mountGoal;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public float getMovementSpeed() {
        return 0.24f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 40.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.HEADHUNTER;
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public float getAttacksPerSecond() {
        if (this.bloodlustTicks > 0) {
            return 0.48000002f;
        }
        return 0.3f;
    }

    @Override
    public float getAggroRange() {
        return 14.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 14.0f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 6.0f + (float)(this.hasFireAspectTrident() ? 1 : 0);
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public int getAttackCooldown() {
        if (this.bloodlustTicks > 0) {
            return 41;
        }
        return 66;
    }

    @Override
    public int getFogRevealDuration() {
        return this.fogRevealDuration;
    }

    @Override
    public void setFogRevealDuration(int duration) {
        this.fogRevealDuration = duration;
    }

    public HeadhunterUnit(EntityType<? extends PiglinBrute> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
    }

    @Override
    public void resetBehaviours() {
        this.mountGoal.m_8041_();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, (double)0.24f).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    public boolean m_21526_() {
        return false;
    }

    protected void m_7581_(ItemEntity pItemEntity) {
    }

    public boolean m_34666_() {
        return false;
    }

    protected void m_8024_() {
    }

    public LivingEntity m_5448_() {
        return this.targetGoal.getTarget();
    }

    public void m_8119_() {
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        this.mountGoal.m_8037_();
        if (this.bloodlustTicks > 0) {
            --this.bloodlustTicks;
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new UnitBowAttackGoal<HeadhunterUnit>(this);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.mountGoal = new MountGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.mountGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void performUnitRangedAttack(LivingEntity pTarget, float velocity) {
        ThrownTrident $$2 = new ThrownTrident(this.m_9236_(), (LivingEntity)this, new ItemStack((ItemLike)Items.f_42713_));
        double $$3 = pTarget.m_20185_() - this.m_20185_();
        double $$4 = pTarget.m_20227_(0.3333333333333333) - $$2.m_20186_();
        double $$5 = pTarget.m_20189_() - this.m_20189_();
        double $$6 = Math.sqrt($$3 * $$3 + $$5 * $$5);
        if (pTarget.m_20192_() <= 1.0f) {
            $$4 -= (double)(1.0f - pTarget.m_20192_());
        }
        $$2.m_6686_($$3, $$4 + $$6 * (double)0.2f, $$5, 1.6f, 0.0f);
        this.m_5496_(SoundEvents.f_11821_, 3.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)$$2);
        if (!this.m_9236_().m_5776_() && pTarget instanceof Unit) {
            Unit unit = (Unit)pTarget;
            FogOfWarClientboundPacket.revealRangedUnit(unit.getOwnerName(), this.m_19879_());
        }
    }

    @Override
    public void setupEquipmentAndUpgradesClient() {
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        ItemStack tridentStack = new ItemStack((ItemLike)Items.f_42713_);
        AttributeModifier mod = new AttributeModifier(UUID.randomUUID().toString(), 0.0, AttributeModifier.Operation.ADDITION);
        tridentStack.m_41643_(Attributes.f_22281_, mod, EquipmentSlot.MAINHAND);
        if (ResearchServerEvents.playerHasResearch(this.getOwnerName(), ProductionItems.RESEARCH_HEAVY_TRIDENTS)) {
            tridentStack.m_41663_(Enchantments.f_44986_, 1);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, tridentStack);
    }

    public boolean m_5825_() {
        BuildingPlacement bpl = BuildingUtils.findBuilding(this.m_9236_().m_5776_(), this.m_20097_());
        return super.m_5825_() || bpl != null && (bpl.getBuilding() instanceof FlameSanctuary || bpl.getBuilding() instanceof BasaltSprings);
    }

    public boolean hasNetheriteChestplate() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.CHEST);
        return itemStack.m_41720_() == Items.f_42481_;
    }

    public boolean hasFireAspectTrident() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemStack.getAllEnchantments().containsKey(Enchantments.f_44981_);
    }

    @Override
    public boolean canPickUpEquipment(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        ItemStack currentItemStack = this.m_6844_(HeadhunterUnit.m_147233_((ItemStack)itemStack));
        return (item == Items.f_42477_ || item == Items.f_42478_ || item == Items.f_42479_ || item == Items.f_42476_ || item == Items.f_42481_ || item == Items.f_42482_ || item == Items.f_42483_ || item == Items.f_42480_ || item == Items.f_42713_) && (currentItemStack.m_41720_() != item || !this.hasFireAspectTrident() && itemStack.m_41793_());
    }

    @Override
    public void onPickupEquipment(ItemStack itemStack) {
        if (itemStack.m_41720_() == Items.f_42713_) {
            AttributeModifier mod = new AttributeModifier(UUID.randomUUID().toString(), 0.0, AttributeModifier.Operation.ADDITION);
            itemStack.m_41643_(Attributes.f_22281_, mod, EquipmentSlot.MAINHAND);
        }
        this.m_8061_(HeadhunterUnit.m_147233_((ItemStack)itemStack), itemStack);
    }

    @Override
    public boolean hasBonusAttackSpeed() {
        return this.bloodlustTicks > 0;
    }

    @Override
    public boolean hasBonusDamage() {
        return this.hasFireAspectTrident();
    }

    static {
        ABILITIES.add(new MountHoglin(), Keybindings.keyQ);
        ABILITIES.add(new Bloodlust(), Keybindings.keyW);
        ownerDataAccessor = SynchedEntityData.m_135353_(HeadhunterUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

