/*
 * Decompiled with CFR 0.152.
 */
package net.KanasakiTechnologics.DecoBuild.Fluid;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class MoltenZincType
extends FluidType {
    private static final ResourceLocation STILL = ResourceLocation.fromNamespaceAndPath((String)"decobuild", (String)"block/molten_zinc_still");
    private static final ResourceLocation FLOWING = ResourceLocation.fromNamespaceAndPath((String)"decobuild", (String)"block/molten_zinc_flow");

    public MoltenZincType(FluidType.Properties properties) {
        super(properties.lightLevel(10).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY));
    }

    public void initializeClient(@NotNull Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(this){

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING;
            }
        });
    }

    public void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
        if (random.nextFloat() < 0.25f) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, x, y, z, 0.0, 0.02, 0.0);
        }
    }
}

