package io.github.startsmercury.visual_snowy_leaves.impl.client;

import io.github.startsmercury.visual_snowy_leaves.impl.client.extension.SnowAware;
import io.github.startsmercury.visual_snowy_leaves.impl.client.extension.SnowDataAware;
import io.github.startsmercury.visual_snowy_leaves.impl.client.extension.VisualSnowyLeavesAware;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_322;
import net.minecraft.class_8012;
import net.minecraft.class_9848;

public record SnowableBlockColor(class_322 blockColor, Int2IntMap correctionMultipliers) implements class_322 {
    private static boolean isSnowyAt(
        final @Nullable class_1920 blockAndTintGetter,
        final @Nullable class_2338 blockPos
    ) {
        return blockPos != null
            && blockAndTintGetter instanceof final SnowAware snowAware
            && snowAware.visual_snowy_leaves$coldEnoughToSnow(blockPos);
    }

    public static SnowableBlockColor setMultiplier(class_322 blockColor, final Int2IntMap multipliers) {
        while (blockColor instanceof final SnowableBlockColor snowableBlockColor) {
            blockColor = snowableBlockColor.blockColor;
        }

        return new SnowableBlockColor(blockColor, multipliers);
    }

    public SnowableBlockColor {
        Objects.requireNonNull(blockColor, "Parameter blockColor is null");
        Objects.requireNonNull(correctionMultipliers, "Parameter correctionMultipliers is null");
    }

    @Override
    public int getColor(
        final class_2680 blockState,
        final @Nullable class_1920 blockAndTintGetter,
        final @Nullable class_2338 blockPos,
        final int i
    ) {
        final var base = this.blockColor.getColor(blockState, blockAndTintGetter, blockPos, i);
        final var correctionMultiplier = this.correctionMultipliers.get(i);

        if (correctionMultiplier == class_8012.field_42973) {
            return base;
        }

        if (!(blockAndTintGetter instanceof final VisualSnowyLeavesAware vslAware)) {
            return class_9848.method_61322(base, correctionMultiplier);
        }

        final var config = vslAware.getVisualSnowyLeaves().getConfig();

        if (config.disabled() || config.requireSnowyBiomes() && !isSnowyAt(blockAndTintGetter, blockPos)) {
            return class_9848.method_61322(base, correctionMultiplier);
        }

        if (!(config.requireSnowyWeather() && blockAndTintGetter instanceof final SnowDataAware snowDataAware)) {
            return class_8012.field_42973;
        }

        final var curr = snowDataAware.visual_snowy_leaves$getSnowData().getAccumulatedTicks();
        final var max = config.transitionDuration().asTicks();

        final var r = class_9848.method_61327(correctionMultiplier) * class_9848.method_61327(base);
        final var g = class_9848.method_61329(correctionMultiplier) * class_9848.method_61329(base);
        final var b = class_9848.method_61331(correctionMultiplier) * class_9848.method_61331(base);

        return class_9848.method_61324(
            class_9848.method_61320(base),
            Integer.divideUnsigned(max * r + curr * (255 * 255 - r), 255 * max),
            Integer.divideUnsigned(max * g + curr * (255 * 255 - g), 255 * max),
            Integer.divideUnsigned(max * b + curr * (255 * 255 - b), 255 * max)
        );
    }
}
