package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components;

import io.github.startsmercury.visual_snowy_leaves.impl.client.gui.screens.TargetBlocksScreen;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4280;
import net.minecraft.class_7923;
import net.minecraft.class_8012;
import org.jetbrains.annotations.Nullable;

public class TargetBlocksList extends class_4280<TargetBlocksList.Entry> {
    private static final class_2960 SLOT_SPRITE = class_2960.method_60656("container/slot");

    public class Entry extends class_4280.class_4281<Entry> {
        @Override
        public void method_25343(
            final class_332 guiGraphics,
            final int index,
            final int rowTop,
            final int rowLeft,
            final int rowWidth,
            final int itemHeight,
            final int mouseX,
            final int mouseY,
            final boolean hovered,
            final float deltaTicks
        ) {
            final var id = TargetBlocksList.this.targets.get(index);

            class_7923.field_41175.method_17966(id).ifPresentOrElse(block -> {
                final var item = block.method_8389();
                final var stack = new class_1799(item);
                this.blitSlot(guiGraphics, rowLeft, rowTop, stack);

                final var name = item != class_1802.field_8162 ? stack.method_7964() : block.method_9518();
                final var color = stack.method_7932().method_58413().method_532();
                guiGraphics.method_27535(TargetBlocksList.this.font, name, rowLeft + 18 + 5, rowTop + 1, color == null ? class_8012.field_42973 : 0xFF000000 | color);
                guiGraphics.method_25303(TargetBlocksList.this.font, id.toString(), rowLeft + 18 + 5, rowTop + 11, class_8012.field_44941);
            }, () -> {
                this.blitSlotBg(guiGraphics, rowLeft + 1, rowTop + 1);
                final var name = new class_1799(class_1802.field_8162).method_7964();
                guiGraphics.method_27535(TargetBlocksList.this.font, name, rowLeft + 18 + 5, rowTop + 1, class_8012.field_60347);
                guiGraphics.method_25303(TargetBlocksList.this.font, id.toString(), rowLeft + 18 + 5, rowTop + 11, class_8012.field_44941);
            });
        }

        @Override
        public class_2561 method_37006() {
            final var id = TargetBlocksList.this.targets.get(TargetBlocksList.this.method_25396().indexOf(this));

            final var name = class_7923.field_41175.method_17966(id).map(block -> {
                final var item = block.method_8389();
                final var stack = new class_1799(item);

                return item != class_1802.field_8162 ? stack.method_7964() : block.method_9518();
            }).orElseGet(() -> class_2561.method_43470(id.toString()));

            return class_2561.method_43469("narrator.select", name);
        }

        @Override
        public boolean method_25404(final int keyCode, final int scanCode, final int modifiers) {
            if (keyCode != class_3675.field_31987) return false;
            return TargetBlocksList.this.removeKeyAt(this);
        }

        @Override
        public boolean method_25402(final double mouseX, final double mouseY, final int button) {
            TargetBlocksList.this.setSelected(this);
            return super.method_25402(mouseX, mouseY, button);
        }

        private void blitSlot(final class_332 guiGraphics, final int x, final int y, final class_1799 itemStack) {
            this.blitSlotBg(guiGraphics, x + 1, y + 1);
            if (itemStack.method_7960()) return;
            guiGraphics.method_51445(itemStack, x + 2, y + 2);
        }

        private void blitSlotBg(final class_332 guiGraphics, final int x, final int y) {
            guiGraphics.method_52706(class_10799.field_56883, SLOT_SPRITE, x, y, 18, 18);
        }
    }

    private final ObjectArrayList<class_2960> targets = new ObjectArrayList<>();

    private final class_327 font;

    private final TargetBlocksScreen screen;

    public TargetBlocksList(
        final TargetBlocksScreen screen,
        final class_310 minecraft,
        final class_327 font,
        final int width,
        final int height,
        final int y,
        final int itemHeight,
        final int headerHeight
    ) {
        super(minecraft, width, height, y, itemHeight, headerHeight);

        this.screen = screen;
        this.font = font;
    }

    public Set<class_2960> build() {
        return Set.copyOf(this.targets);
    }

    public boolean addKey(final class_2960 key) {
        if (this.targets.add(key)) {
            this.method_25321(new Entry());
            return true;
        } else {
            return false;
        }
    }

    public boolean removeSelectedKey() {
        final var selected = this.method_25334();
        return selected != null && this.removeKeyAt(selected);
    }

    private boolean removeKeyAt(final Entry entry) {
        entry.method_25365(false);
        return this.removeKeyAt(this.method_25396().indexOf(entry));
    }

    private boolean removeKeyAt(final int index) {
        if (index < 0) {
            return false;
        }
        this.targets.remove(index);
        this.method_25396().removeLast();

        final var n = this.method_25396().size();
        if (n == 0) {
            this.setSelected(null);
        } else {
            final var entry = method_25326(index < n ? index : index - 1);
            method_25324(entry);
            this.setSelected(entry);
        }

        return true;
    }

    @Override
    public void setSelected(final @Nullable Entry entry) {
        super.method_25313(entry);
        this.screen.updateButtonValidity();
    }
}
