package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.options;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_5676;
import org.jetbrains.annotations.Nullable;

public final class BooleanOptionEntry extends LabeledOptionEntry {
    private static final int CHECKBOX_WIDTH = 45;

    private final class_5676<Boolean> checkbox;

    public BooleanOptionEntry(
        final Context context,
        final class_2561 label,
        @Nullable final List<class_5481> tooltip,
        final String narrateDefaults,
        final Supplier<? extends Boolean> getter,
        final Consumer<? super Boolean> setter
    ) {
        super(context, label, tooltip);
        this.checkbox = class_5676.method_32613(getter.get())
            .method_32616()
            .method_32623(cycleButton -> cycleButton
                .method_32611()
                .method_27693("\n")
                .method_27693(narrateDefaults)
            )
            .method_32617(0, 0, CHECKBOX_WIDTH, PREFERRED_HEIGHT, label, (button, b) -> setter.accept(b));
        this.children.add(this.checkbox);
    }

    @Override
    protected int getRightWidth() {
        return CHECKBOX_WIDTH;
    }

    @Override
    public void method_25343(
        final class_332 guiGraphics,
        final int index,
        final int rowTop,
        final int rowLeft,
        final int rowWidth,
        final int itemHeight,
        final int mouseX,
        final int mouseY,
        final boolean hovered,
        final float deltaTicks
    ) {
        this.renderLabel(guiGraphics, rowTop, rowLeft);
        this.checkbox.method_46421(rowLeft + rowWidth - CHECKBOX_WIDTH - 2 * OptionsList.ITEM_INSET);
        this.checkbox.method_46419(rowTop);
        this.checkbox.method_25394(guiGraphics, mouseX, mouseY, deltaTicks);
    }
}
