package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.options;

import com.google.common.collect.ImmutableList;
import io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.NavigableTextWidget;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class OptionCategoryEntry extends OptionEntry {
    private static @Nullable List<class_5481> createTooltip(
        final Context context,
        final class_2561 name,
        final @Nullable class_2561 description,
        final @Nullable class_2561 details
    ) {
        if (description == null) {
            return null;
        }

        final var builder = ImmutableList.<class_5481>builder();

        builder.add(name.method_27662().method_27692(class_124.field_1054).method_30937());

        context.font().method_1728(description, 150).forEach(builder::add);

        if (details != null) {
            builder.add(details.method_30937());
        }

        return builder.build();
    }

    private final NavigableTextWidget label;

    private final class_2561 fullName;

    private final @Nullable class_2561 description;

    public OptionCategoryEntry(
        final Context context,
        final class_2561 label,
        final class_2561 fullName,
        final @Nullable class_2561 description,
        final @Nullable class_2561 details
    ) {
        super(context, createTooltip(context, fullName, description, details));

        this.label = new NavigableTextWidget(label, this.context.font());
        this.label.method_53533(OptionsList.ITEM_HEIGHT);
        this.children.add(this.label);

        this.fullName = fullName;
        this.description = description;
    }

    @Override
    public void method_25343(
        final class_332 guiGraphics,
        final int index,
        final int rowTop,
        final int rowLeft,
        final int rowWidth,
        final int itemHeight,
        final int mouseX,
        final int mouseY,
        final boolean hovered,
        final float deltaTicks
    ) {
        this.label.method_46421(rowLeft + (rowWidth - this.label.method_25368()) / 2);
        this.label.method_46419(rowTop + HALF_LINE_H);

        this.label.method_25394(guiGraphics, mouseX, mouseY, deltaTicks);
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return ImmutableList.of(new class_6379() {
            public class_6380 method_37018() {
                return OptionCategoryEntry.this.label.method_37018();
            }

            public void method_37020(final class_6382 output) {
                final var description = OptionCategoryEntry.this.description;
                output.method_37034(
                    class_6381.field_33788,
                    description == null ? fullName : OptionCategoryEntry.this
                        .fullName
                        .method_27661()
                        .method_27693("\n")
                        .method_10852(description)
                );
            }
        });
    }
}
