package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.options;

import io.github.startsmercury.visual_snowy_leaves.impl.client.config.Tick32;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.TickParseException;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.TickUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5481;
import net.minecraft.class_8012;
import org.jetbrains.annotations.Nullable;

public final class Tick32OptionEntry<T extends Tick32<T>> extends LabeledOptionEntry {
    private static final int INPUT_WIDTH = 70;

    private final class_342 input;

    public Tick32OptionEntry(
        final Context context,
        final class_2561 label,
        @Nullable final List<class_5481> tooltip,
        final String narrateDefaults,
        final Supplier<? extends T> getter,
        final Consumer<? super T> setter
    ) {
        super(context, label, tooltip);
        final var value = getter.get();

        this.input = new class_342(context.font(), 0, 0, INPUT_WIDTH, PREFERRED_HEIGHT, label.method_27661().method_27693("\n").method_27693(narrateDefaults).method_27693("\n"));
        this.input.method_1880(11);
        this.input.method_1863(string -> {
            try {
                setter.accept(value.withTicks(TickUtil.parse(string)));
                input.method_1868(class_342.field_32196);
                context.screen().clearInvalid(this);
            } catch (final TickParseException ignored) {
                input.method_1868(class_8012.field_41758);
                context.screen().markInvalid(this);
            }
        });
        this.input.method_1852(TickUtil.format(value.asTicks(), true));
        this.input.method_1870(false);

        this.children.add(this.input);
    }

    @Override
    protected int getRightWidth() {
        return INPUT_WIDTH;
    }

    @Override
    public void method_25343(
        final class_332 guiGraphics,
        final int index,
        final int rowTop,
        final int rowLeft,
        final int rowWidth,
        final int itemHeight,
        final int mouseX,
        final int mouseY,
        final boolean hovered,
        final float deltaTicks
    ) {
        this.renderLabel(guiGraphics, rowTop, rowLeft);
        this.input.method_46421(rowLeft + rowWidth - INPUT_WIDTH - 2 * OptionsList.ITEM_INSET);
        this.input.method_46419(rowTop);
        this.input.method_25394(guiGraphics, mouseX, mouseY, deltaTicks);
    }
}
