package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.screens;

import io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.suggest.InputSuggestions;
import io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.TargetBlocksList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import net.minecraft.class_7849;
import net.minecraft.class_7923;
import net.minecraft.class_8012;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

public final class TargetBlocksScreen extends class_437 {
    private static final int BUTTON_ROW_WIDTH = 308;
    private static final int BUTTON_WIDTH = 74;

    private static final class_2561 TITLE = class_2561.method_43471("visual-snowy-leaves.config.targetBlocks.title");
    private static final class_2561 ADD = class_2561.method_43471("visual-snowy-leaves.config.targetBlocks.add");
    private static final class_2561 REMOVE = class_2561.method_43471("visual-snowy-leaves.config.targetBlocks.remove");
    private static final class_2561 INPUT = class_2561.method_43471("visual-snowy-leaves.config.targetBlocks.input");

    private static final Comparator<? super class_2960> BLOCKS_BY_NAME_OR_ID = Comparator.comparing(class_2960::method_12836)
        .thenComparing(
            id -> class_7923.field_41175
                .method_17966(id)
                .map(class_2248::method_8389)
                .map(class_1799::new)
                .map(class_1799::method_7964)
                .map(class_2561::getString),
            (lhs, rhs) -> lhs.isEmpty() && rhs.isEmpty() ? 0
                : lhs.isEmpty() ? 1
                : rhs.isEmpty() ? -1
                : lhs.get().compareTo(rhs.get())
        )
        .thenComparing(class_2960::method_12832);

    private final class_8132 layout = new class_8132(this, 33, 78);

    private final Consumer<? super Set<class_2960>> callback;

    private final ConfigScreen lastScreen;

    private final class_2960[] targets;

    @Nullable
    private class_4185 addButton;

    @Nullable
    private class_342 inputEdit;

    @Nullable
    private TargetBlocksList list;

    @Nullable
    private class_4185 removeButton;

    @Nullable
    private InputSuggestions suggestions;

    public TargetBlocksScreen(
        final ConfigScreen lastScreen,
        final Set<? extends class_2960> targets,
        final Consumer<? super Set<class_2960>> callback
    ) {
        super(TITLE);

        this.callback = callback;
        this.lastScreen = lastScreen;
        this.targets = targets.toArray(class_2960[]::new);

        Arrays.sort(this.targets, BLOCKS_BY_NAME_OR_ID);
    }

    @Override
    protected void method_25426() {
        this.layout.method_57726(this.field_22785, this.field_22793);
        assert this.field_22787 != null;
        this.list = this.layout.method_48999(new TargetBlocksList(this, this.field_22787, this.field_22793, this.field_22789, this.field_22790,43, 24, 0));

        for (final var target : this.targets) {
            this.list.addKey(target);
        }

        this.inputEdit = new class_342(this.field_22793, BUTTON_ROW_WIDTH, class_4185.field_39501, INPUT) {
            protected class_5250 method_25360() {
                final var suggestions = TargetBlocksScreen.this.suggestions;
                assert suggestions != null;
                return super.method_25360().method_10852(suggestions.getNarrationMessage());
            }
        };
        this.addButton = class_4185.method_46430(ADD, button -> {
            final var id = class_2960.method_12829(inputEdit.method_1882());
            if (id == null) return;
            this.list.addKey(id);
            button.field_22763 = false;
            inputEdit.method_1852("");
        }).method_46432(BUTTON_WIDTH).method_46431();

        addButton.field_22763 = false;

        inputEdit.method_1863(this::onEdited);

        final var buttonsRow = new class_7849(BUTTON_ROW_WIDTH, class_4185.field_39501, class_7849.class_7851.field_40789);
        buttonsRow.method_46495(addButton);
        this.removeButton = buttonsRow.method_46495(class_4185.method_46430(REMOVE, button -> this.list.removeSelectedKey()).method_46432(BUTTON_WIDTH).method_46431());
        buttonsRow.method_46495(class_4185.method_46430(class_5244.field_24334, (button) -> this.onDone()).method_46432(BUTTON_WIDTH).method_46431());
        buttonsRow.method_46495(class_4185.method_46430(class_5244.field_24335, (button) -> this.method_25419()).method_46432(BUTTON_WIDTH).method_46431());

        final var rows = this.layout.method_48996(class_8667.method_52741().method_52735(4));
        rows.method_52740().method_46474();
        rows.method_52736(new class_7842(BUTTON_ROW_WIDTH, 10, INPUT, this.field_22793))
            .method_48596()
            .method_46438(class_8012.field_45073);
        rows.method_52736(inputEdit);
        rows.method_52736(buttonsRow);

        this.updateButtonValidity();
        this.layout.method_48206(this::method_37063);
        this.method_48640();

        this.suggestions = new InputSuggestions(
            this.field_22787,
            this,
            this.inputEdit,
            this.field_22793,
                0,
            7,
            true,
            0xd0000000
        );
        this.suggestions.setAllowSuggestions(true);
        this.suggestions.updateSuggestInfo();
    }

    protected class_2561 method_53870() {
        final var suggestions = this.suggestions;
        assert suggestions != null;
        return this.suggestions.isVisible()
            ? this.suggestions.getUsageNarration()
            : super.method_53870();
    }

    public void method_25410(final class_310 minecraft, final int width, final int height) {
        assert this.inputEdit != null;
        final String string = this.inputEdit.method_1882();
        this.method_25423(minecraft, width, height);
        this.inputEdit.method_1852(string);

        final var suggestions = this.suggestions;
        assert suggestions != null;
        suggestions.updateSuggestInfo();
    }

    private void onDone() {
        assert this.list != null;
        this.callback.accept(this.list.build());
        this.method_25419();
    }

    private void onEdited(final String value) {
        final var addButton = this.addButton;
        final var inputEdit = this.inputEdit;

        assert addButton != null;
        assert inputEdit != null;

        final var suggestions = this.suggestions;
        assert suggestions != null;
        addButton.field_22763 = suggestions.updateSuggestInfo();
    }

    @Override
    public boolean method_25404(final int keyCode, final int scanCode, final int modifiers) {
        final var suggestions = this.suggestions;
        assert suggestions != null;

        if (suggestions.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        } else if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        } else if (keyCode == class_3675.field_31957 || keyCode == class_3675.field_31980) {
            final var addButton = this.addButton;
            assert addButton != null;
            if (addButton.method_37303()) {
                addButton.method_25306();
                return true;
            }
        }
        return false;
    }

    public boolean method_25401(double d, double e, double f, double g) {
        final var suggestions = this.suggestions;
        assert suggestions != null;
        return suggestions.mouseScrolled(g) || super.method_25401(d, e, f, g);
    }

    public boolean method_25402(double d, double e, int i) {
        final var suggestions = this.suggestions;
        assert suggestions != null;
        return suggestions.mouseClicked(d, e, i) || super.method_25402(d, e, i);
    }

    @Override
    public void method_25419() {
        final var minecraft = this.field_22787;
        assert minecraft != null;
        minecraft.method_1507(this.lastScreen);
    }

    @Override
    protected void method_48640() {
        if (this.list != null) {
            this.list.method_57712(this.field_22789, this.layout);
        }

        this.layout.method_48222();
    }

    public void updateButtonValidity() {
        if (this.removeButton != null) {
            this.removeButton.field_22763 = this.hasValidSelection();
        }
    }

    private boolean hasValidSelection() {
        return this.list != null && this.list.method_25334() != null;
    }

    public void method_25394(
        final class_332 guiGraphics,
        final int mouseX,
        final int mouseY,
        final float deltaTicks
    ) {
        super.method_25394(guiGraphics, mouseX, mouseY, deltaTicks);

        final var inputEdit = this.inputEdit;
        assert inputEdit != null;
        inputEdit.method_25394(guiGraphics, mouseX, mouseY, deltaTicks);

        final var suggestions = this.suggestions;
        assert suggestions != null;
        suggestions.render(guiGraphics, mouseX, mouseY);
    }
}
