package io.github.startsmercury.visual_snowy_leaves.mixin.client.tint;

import com.google.gson.JsonParseException;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.JsonOps;
import io.github.startsmercury.visual_snowy_leaves.impl.client.SpriteWhitener;
import io.github.startsmercury.visual_snowy_leaves.impl.client.VslConstants;
import io.github.startsmercury.visual_snowy_leaves.impl.client.util.SequencedCompletableFuture;
import io.github.startsmercury.visual_snowy_leaves.impl.client.util.UnknownBlockStateDefinitionException;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_1059;
import net.minecraft.class_10811;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_790;

import static net.minecraft.class_9824.field_55458;

@Mixin(class_1092.class)
public abstract class ModelManagerMixin {
    @Shadow
    @Final
    private class_324 blockColors;

    @WrapOperation(
        method = "reload",
        at = @At(
            value = "INVOKE",
            target = "Ljava/util/concurrent/CompletableFuture;thenAcceptAsync(Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;",
            ordinal = 0
        )
    )
    private CompletableFuture<Void> modifySprites(
        final CompletableFuture<class_1092.class_7779> afterPreparationBarrierFuture,
        final Consumer<? super class_1092.class_7779> apply,
        final Executor applyExecutor,
        final Operation<CompletableFuture<Void>> op,
        final @Local(ordinal = 0, argsOnly = true) class_3300 resourceManager,
        final @Local(ordinal = 0, argsOnly = true) Executor executor,
        final @Local(ordinal = 2) CompletableFuture<Map<class_2960, class_1100>> unbakedModelsFuture,
        final @Local(ordinal = 5) CompletableFuture<class_1092.class_10816> modelDiscoveryFuture
    ) {
        final var blockstateResourcesFuture = CompletableFuture.supplyAsync(
            () -> field_55458.method_45116(resourceManager),
            executor
        );

        final var function = class_10811.method_68013();
        final var visualSnowyLeaves = class_310.method_1551().getVisualSnowyLeaves();
        final var logger = visualSnowyLeaves.getLogger();

        final var blockModelDefinitionsFuture = blockstateResourcesFuture.thenCompose(map -> {
            final var list = new ArrayList<
                CompletableFuture<Map.Entry<class_2960, ArrayList<class_790>>>
            >(map.size());

            for (final var entry : map.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    final var resourceLocation = field_55458.method_45115(entry.getKey());
                    final var stateDefinition = function.apply(resourceLocation);

                    if (stateDefinition == null) {
                        throw new UnknownBlockStateDefinitionException(resourceLocation);
                    }

                    final var resources = entry.getValue();
                    final var blockModelDefinitions =
                        new ArrayList<class_790>(resources.size());

                    for (final var resource : resources) {
                        try (final var reader = resource.method_43039()) {
                            final var jsonObject = class_3518.method_15255(reader);
                            final var blockModelDefinition =
                                class_790.field_56928.parse(JsonOps.INSTANCE, jsonObject).getOrThrow(JsonParseException::new);
                            blockModelDefinitions.add(blockModelDefinition);
                        } catch (final Exception exception) {
                            logger.error(
                                "Failed to load blockstate definition {} from pack {}",
                                resourceLocation,
                                resource.method_14480(),
                                exception
                            );
                        }
                    }

                    return Map.entry(resourceLocation, blockModelDefinitions);
                }, executor));
            }

            return SequencedCompletableFuture.tryFilter(list, throwable -> {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof final Error error) {
                    throw error;
                } else if (throwable instanceof final UnknownBlockStateDefinitionException cause) {
                    logger.debug(
                        "[{}] Discovered unknown block state definition {}, ignoring",
                        VslConstants.NAME,
                        cause.getResourceLocation()
                    );
                } else {
                    logger.error("[{}] Uncaught exception", VslConstants.NAME, throwable);
                }
            });
        });

        final var spriteWhitenerFuture = modelDiscoveryFuture.thenCompose(modelDiscovery -> {
            return blockModelDefinitionsFuture.thenApplyAsync(
                entries -> {
                    final var spriteWhitener = SpriteWhitener.create(visualSnowyLeaves);
                    for (final var entry : entries) {
                        for (final var blockModelDefinition : entry.getValue()) {
                            spriteWhitener.analyzeModels(entry.getKey(), blockModelDefinition);
                        }
                    }
                    return spriteWhitener;
                },
                executor
            );
        });

        final var waitForAllFuture = CompletableFuture.allOf(
            // Redundancy: already done in first `allOf`
            spriteWhitenerFuture,
            // No comment.
            afterPreparationBarrierFuture,
            // Redundancy: already done in second `allOf`
            unbakedModelsFuture
        );

        @SuppressWarnings("deprecation")
        final var atlasKey = class_1059.field_5275;

        final var modifySpritesFuture = waitForAllFuture.thenRunAsync(() -> {
            final var spriteWhitener = spriteWhitenerFuture.join();
            spriteWhitener.modifySprites(
                this.blockColors,
                unbakedModelsFuture.join(),
                afterPreparationBarrierFuture
                    .join()
                    .comp_1061()
                    .get(atlasKey)
            );
            visualSnowyLeaves.collectReports(spriteWhitener);
            final var ignored = visualSnowyLeaves.sendReportNotice();
        }, applyExecutor);

        return CompletableFuture.allOf(
            modifySpritesFuture,
            op.call(afterPreparationBarrierFuture, apply, applyExecutor)
        );
    }
}
