package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.options;

import io.github.startsmercury.visual_snowy_leaves.impl.client.gui.screens.ConfigScreen;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class CustomizeOptionEntry extends LabeledOptionEntry {
    private static final int BUTTON_WIDTH = 70;

    private static final class_2561 CUSTOMIZE =
        class_2561.method_43471("visual-snowy-leaves.config.option.advance.customize");

    private static final class_2561 BASE_NARRATION =
        class_339.method_32602(CUSTOMIZE);

    private final class_4185 button;

    public CustomizeOptionEntry(
        final Context context,
        final class_2561 label,
        @Nullable final List<class_5481> tooltip,
        final String narrateDefaults,
        final Function<ConfigScreen, ? extends class_437> screen
    ) {
        super(context, label, tooltip);

        this.button = class_4185.method_46430(CUSTOMIZE, button ->
            context.minecraft().method_1507(screen.apply(context.screen()))
        ).method_46432(BUTTON_WIDTH)
            .method_46435(supplier -> label
                .method_27661()
                .method_27693("\n")
                .method_10852(supplier.get())
                .method_27693("\n")
                .method_27693(narrateDefaults)
            )
            .method_46431();
        this.children.add(this.button);
    }


    @Override
    protected int getRightWidth() {
        return BUTTON_WIDTH;
    }

    @Override
    public void method_25343(
        final class_332 guiGraphics,
        final int mouseX,
        final int mouseY,
        final boolean hovered,
        final float deltaTicks
    ) {
        this.renderLabel(guiGraphics, this.method_73382(), this.method_73380());
        this.button.method_46421(this.method_73389() - BUTTON_WIDTH);
        this.button.method_46419(this.method_73382());
        this.button.method_25394(guiGraphics, mouseX, mouseY, deltaTicks);
    }
}
