package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.suggest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.startsmercury.visual_snowy_leaves.impl.client.util.resource.ResourceLocationParseException;
import io.github.startsmercury.visual_snowy_leaves.impl.client.util.resource.ResourceLocationParser;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5481;
import net.minecraft.class_7923;
import net.minecraft.class_8012;
import org.jetbrains.annotations.Nullable;

public class InputSuggestions {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");

    @Nullable
    private class_5481 commandUsage;
    private final class_437 screen;
    private int commandUsageWidth;

    final boolean anchorToBottom;
    final class_327 font;
    final int fillColor;
    final class_342 input;
    final class_310 minecraft;
    final int lineStartOffset;
    final int suggestionLineLimit;

    private String currentValue = "";
    private @Nullable ResourceLocationParseException currentException;
    private @Nullable CompletableFuture<Suggestions> pendingSuggestions;
    private @Nullable SuggestionsList suggestions;
    private boolean allowSuggestions;
    boolean keepSuggestions;
    private boolean allowHiding = true;

    public InputSuggestions(
        final class_310 minecraft,
        final class_437 screen,
        final class_342 input,
        final class_327 font,
        final int lineStartOffset,
        final int suggestionLineLimit,
        final boolean anchorToBottom,
        final int fillColor
    ) {
        this.anchorToBottom = anchorToBottom;
        this.fillColor = fillColor;
        this.font = font;
        this.input = input;
        this.lineStartOffset = lineStartOffset;
        this.minecraft = minecraft;
        this.screen = screen;
        this.suggestionLineLimit = suggestionLineLimit;
    }

    public void setAllowSuggestions(final boolean allowSuggestions) {
        this.allowSuggestions = allowSuggestions;

        if (!allowSuggestions) {
            this.suggestions = null;
        }
    }

    public void setAllowHiding(final boolean allowHiding) {
        this.allowHiding = allowHiding;
    }

    public boolean keyPressed(final class_11908 event) {
        if (this.suggestions != null && this.suggestions.keyPressed(event)) {
            return true;
        } else if (this.screen.method_25399() != this.input
            || !event.method_74236()
            || this.allowHiding && this.suggestions == null
        ) {
            return false;
        } else {
            this.showSuggestions(true);
            return true;
        }
    }

    public boolean mouseScrolled(final double scrollAmount) {
        return this.suggestions != null
            && this.suggestions.mouseScrolled(class_3532.method_15350(scrollAmount, -1.0D, 1.0D));
    }

    public boolean mouseClicked(final class_11909 event) {
        return this.suggestions != null
            && this.suggestions.mouseClicked((int) event.comp_4798(), (int) event.comp_4799());
    }

    public void showSuggestions(final boolean bl) {
        if (!this.input.method_25370()) return;
        if (this.pendingSuggestions == null) return;
        if (!this.pendingSuggestions.isDone()) return;

        final var suggestions = this.pendingSuggestions.join();
        if (suggestions.isEmpty()) return;

        int width = 0;
        for(final var suggestion : suggestions.getList()) {
            width = Math.max(width, this.font.method_1727(suggestion.getText()));
        }

        final int x = class_3532.method_15340(
            this.input.method_1889(suggestions.getRange().getStart()),
            0,
            this.input.method_1889(0) + this.input.method_1859() - width
        );
        final int y = this.anchorToBottom
            ? this.input.method_46427()
            : this.input.method_46427() + this.input.method_25364();

        this.suggestions =
            new SuggestionsList(this, x, y, width, this.sortSuggestions(suggestions), bl);
    }

    public boolean isVisible() {
        return this.suggestions != null;
    }

    public class_2561 getUsageNarration() {
        if (this.suggestions != null && this.suggestions.tabCycles) {
            return this.allowHiding
                ? class_2561.method_43471("narration.suggestion.usage.cycle.hidable")
                : class_2561.method_43471("narration.suggestion.usage.cycle.fixed");
        } else {
            return this.allowHiding
                ? class_2561.method_43471("narration.suggestion.usage.fill.hidable")
                : class_2561.method_43471("narration.suggestion.usage.fill.fixed");
        }
    }

    public void hide() {
        this.suggestions = null;
    }

    private List<Suggestion> sortSuggestions(final Suggestions suggestions) {
        final var cursorsLeft = this.input.method_1882().substring(0, this.input.method_1881());
        final var lastWord = cursorsLeft
            .substring(getLastWordIndex(cursorsLeft))
            .toLowerCase(Locale.ROOT);

        final var commonPrefix = Lists.<Suggestion>newArrayList();
        final var misc = Lists.<Suggestion>newArrayList();

        for (final var suggestion : suggestions.getList()) {
            if (suggestion.getText().startsWith(lastWord)
                || suggestion.getText().startsWith("minecraft:" + lastWord)
            ) {
                commonPrefix.add(suggestion);
            } else {
                misc.add(suggestion);
            }
        }

        commonPrefix.addAll(misc);
        return commonPrefix;
    }

    public boolean updateSuggestInfo() {
        final var value = this.input.method_1882();
        if (!this.currentValue.equals(value)) {
            this.currentException = null;
        }

        if (!this.keepSuggestions) {
            this.input.method_1887(null);
            this.suggestions = null;
        }

        this.commandUsage = null;

        if (this.suggestions == null || !this.keepSuggestions) {
            this.currentValue = value;

            try {
                ResourceLocationParser.parse(value);
                this.input.method_1868(class_342.field_32196);
            } catch (final ResourceLocationParseException cause) {
                this.currentException = cause;
                this.input.method_1868(class_8012.field_41758);
            }

            final var builder = new SuggestionsBuilder(value, 0);

            this.pendingSuggestions =
                class_2172.method_9270(class_7923.field_41175.method_10235(), builder);

            this.pendingSuggestions.thenAccept(this::updateUsageInfo);
        }

        return this.currentException == null;
    }

    private static int getLastWordIndex(final String string) {
        if (Strings.isNullOrEmpty(string)) return 0;

        final var matcher = WHITESPACE_PATTERN.matcher(string);
        int i = 0;

        while (matcher.find()) {
            i = matcher.end();
        }

        return i;
    }

    private void updateUsageInfo(final Suggestions suggestions) {
        if (this.currentException != null && suggestions.isEmpty()) {
            this.commandUsage = class_2561.method_43470(this.currentException.getMessage()).method_30937();
        }

        this.commandUsageWidth = this.screen.field_22789;

        this.suggestions = null;
        if (this.allowSuggestions && this.minecraft.field_1690.method_42425().method_41753()) {
            this.showSuggestions(false);
        }
    }

    public void render(final class_332 guiGraphics, final int mouseX, final int mouseY) {
        if (!this.renderSuggestions(guiGraphics, mouseX, mouseY)) {
            this.renderUsage(guiGraphics);
        }
    }

    public boolean renderSuggestions(final class_332 guiGraphics, final int mouseX, final int mouseY) {
        if (this.suggestions != null) {
            this.suggestions.render(guiGraphics, mouseX, mouseY);
            return true;
        } else {
            return false;
        }
    }

    public void renderUsage(final class_332 guiGraphics) {
        final var commandUsage = this.commandUsage;
        if (commandUsage == null) return;
        final var x = 0;
        final var y = this.anchorToBottom ? this.input.method_46427() + this.input.method_25364() : this.input.method_46427() - SuggestionsList.ITEM_HEIGHT;

        guiGraphics.method_25294(
            x - 1,
            y,
            x + this.commandUsageWidth + 1,
            y + SuggestionsList.ITEM_HEIGHT,
            this.fillColor
        );
        guiGraphics.method_35720(this.font, commandUsage, x, y + 2, class_8012.field_42973);
    }

    public class_2561 getNarrationMessage() {
        return this.suggestions != null
            ? class_5244.field_33849.method_27661().method_10852(this.suggestions.getNarrationMessage())
            : class_5244.field_39003;
    }
}
