package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.screens;

import com.google.common.collect.Sets;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.Config;
import io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.options.OptionEntry;
import io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.options.OptionsList;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

public class ConfigScreen extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43471("visual-snowy-leaves.config.title");

    private final Set<OptionEntry> invalidEntries = Sets.newHashSet();

    public final class_8132 layout = new class_8132(this);

    private final Consumer<? super Config> configCallback;

    private final Config initialConfig;

    protected final class_437 lastScreen;

    @Nullable
    private class_4185 doneButton;

    @Nullable
    private OptionsList list;

    public ConfigScreen(
        final class_437 lastScreen,
        final Config initialConfig,
        final Consumer<? super Config> configCallback
    ) {
        super(TITLE);
        this.initialConfig = initialConfig;
        this.lastScreen = lastScreen;
        this.configCallback = configCallback;
    }

    @Override
    protected void method_25426() {
        this.layout.method_57726(TITLE, this.field_22793);
        assert this.field_22787 != null;
        this.list = this.layout.method_48999(new OptionsList(
            new OptionEntry.Context(this, this.field_22787, this.field_22793),
            this.initialConfig,
            this.field_22789,
            this.layout.method_57727(),
            this.layout.method_48998()
        ));
        final var linearLayout = this.layout.method_48996(class_8667.method_52742().method_52735(8));
        this.doneButton = linearLayout.method_52736(class_4185.method_46430(class_5244.field_24334, button -> this.onDone()).method_46431());
        linearLayout.method_52736(class_4185.method_46430(class_5244.field_24335, button -> this.method_25419()).method_46431());
        this.layout.method_48206(this::method_37063);
        this.method_48640();
    }

    @Override
    protected void method_48640() {
        this.layout.method_48222();
        if (this.list != null) {
            this.list.method_57712(this.field_22789, this.layout);
        }
    }

    private void onDone() {
        assert this.list != null;
        this.configCallback.accept(this.list.build());
        this.method_25419();
    }

    @Override
    public void method_25419() {
        final var minecraft = this.field_22787;
        assert minecraft != null;
        minecraft.method_1507(this.lastScreen);
    }

    public void markInvalid(final OptionEntry ruleEntry) {
        this.invalidEntries.add(ruleEntry);
        this.updateDoneButton();
    }

    public void clearInvalid(final OptionEntry ruleEntry) {
        this.invalidEntries.remove(ruleEntry);
        this.updateDoneButton();
    }

    private void updateDoneButton() {
        if (this.doneButton != null) {
            this.doneButton.field_22763 = this.invalidEntries.isEmpty();
        }
    }

    @Override
    public void method_16014(final double mouseX, final double mouseY) {
        assert this.list != null;
        this.list.method_16014(mouseX, mouseY);
    }
}
