package io.github.startsmercury.visual_snowy_leaves.mixin.client.tint;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.startsmercury.visual_snowy_leaves.impl.client.SnowableBlockColor;
import java.util.List;
import net.minecraft.class_10396;
import net.minecraft.class_10401;
import net.minecraft.class_10430;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2361;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_8012;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_10430.class)
public abstract class BlockModelWrapperMixin {
    @Final
    @Mutable
    @Shadow
    private List<class_10401> tints;

    @Unique
    private final class_2361<class_322> blockColors = ((BlockColorsAccessor) class_310.method_1551().method_1505()).getBlockColors();

    @Inject(
        method = "update",
        at = @At(
                value = "FIELD",
                target = "Lnet/minecraft/client/renderer/item/BlockModelWrapper;tints:Ljava/util/List;",
            ordinal = 0
        )
    )
    private void captureTintLayers(
        final CallbackInfo callback,
        final @Local(ordinal = 0, argsOnly = true) class_1799 itemStack,
        final @Share("snowableBlockColor") LocalRef<SnowableBlockColor> snowableBlockColorRef
    ) {
        final var config = class_310.method_1551().getVisualSnowyLeaves().getConfig();

        if (!(itemStack.method_7909() instanceof final class_1747 blockItem)) {
            return;
        }

        final var block = blockItem.method_7711();

        if (!config.targetBlockKeys().contains(class_7923.field_41175.method_10221(block))) {
            return;
        }

        final var blockColor = this.blockColors.method_10200(class_7923.field_41175.method_10206(block));

        if ((!(blockColor instanceof final SnowableBlockColor snowableBlockColor))) {
            return;
        }

        snowableBlockColorRef.set(snowableBlockColor);

        if (this.tints.isEmpty()) {
            this.tints = List.of(new class_10396(class_8012.field_42973));
        }
    }

    @ModifyExpressionValue(method = "update", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/item/ItemStackRenderState$LayerRenderState;prepareTintLayers(I)[I"))
    private int[] captureTintLayers(
        final int[] original,
        final @Share("tintLayers") LocalRef<int[]> tintLayersRef
    ) {
        tintLayersRef.set(original);
        return original;
    }

    @Inject(method = "update", at = @At("RETURN"))
    private void modifyTintLayers(
        final CallbackInfo ci,
        final @Local(ordinal = 0, argsOnly = true) class_1799 itemStack,
        final @Local(ordinal = 0, argsOnly = true) @Nullable class_638 clientLevel,
        final @Share("tintLayers") LocalRef<int[]> tintLayersRef,
        final @Share("snowableBlockColor") LocalRef<SnowableBlockColor> snowableBlockColorRef
    ) {
        final var snowableBlockColor = snowableBlockColorRef.get();
        if (snowableBlockColor == null) {
            return;
        }

        final var tintLayers = tintLayersRef.get();
        final var multipliers = snowableBlockColor.correctionMultipliers();

        for (var i = 0; i < tintLayers.length; i++) {
            tintLayers[i] = class_9848.method_61322(tintLayers[0], multipliers.get(i));
        }
    }
}
