package io.github.startsmercury.visual_snowy_leaves.impl.client;

import io.github.startsmercury.visual_snowy_leaves.impl.client.extension.SnowAware;
import io.github.startsmercury.visual_snowy_leaves.impl.client.extension.SnowDataAware;
import io.github.startsmercury.visual_snowy_leaves.impl.client.extension.VisualSnowyLeavesAware;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_322;
import net.minecraft.class_9848;

public record SnowableBlockColor(class_322 blockColor, int correctionMultiplier) implements class_322 {
    public static final int COLOR_WHITE = 0xFFFFFFFF;

    private static boolean isSnowyAt(
        final @Nullable class_1920 blockAndTintGetter,
        final @Nullable class_2338 blockPos
    ) {
        return blockPos != null
            && blockAndTintGetter instanceof final SnowAware snowAware
            && snowAware.visual_snowy_leaves$coldEnoughToSnow(blockPos);
    }

    public static SnowableBlockColor setMultiplier(class_322 blockColor, final int multiplier) {
        while (blockColor instanceof final SnowableBlockColor snowableBlockColor) {
            blockColor = snowableBlockColor.blockColor;
        }

        return new SnowableBlockColor(blockColor, multiplier);
    }

    public SnowableBlockColor {
        Objects.requireNonNull(blockColor, "Parameter blockColor is null");
    }

    @Override
    public int getColor(
        final class_2680 blockState,
        final @Nullable class_1920 blockAndTintGetter,
        final @Nullable class_2338 blockPos,
        final int i
    ) {
        final var correctionMultiplier = this.correctionMultiplier;
        final var base = this.blockColor.getColor(blockState, blockAndTintGetter, blockPos, i);

        if (i != 0) {
            return base;
        }
        if (!(blockAndTintGetter instanceof final VisualSnowyLeavesAware vslAware)) {
            return class_9848.method_61322(base, correctionMultiplier);
        }

        final var config = vslAware.getVisualSnowyLeaves().getConfig();

        switch (config.snowyMode()) {
            case NEVER:
                return class_9848.method_61322(base, correctionMultiplier);
            case SNOWING:
                break;
            case ALWAYS:
                return COLOR_WHITE;
        }

        if (!isSnowyAt(blockAndTintGetter, blockPos)) {
            return class_9848.method_61322(base, correctionMultiplier);
        }

        if (!(blockAndTintGetter instanceof final SnowDataAware snowDataAware)) {
            return COLOR_WHITE;
        }

        final var curr = snowDataAware.visual_snowy_leaves$getSnowData().getAccumulatedTicks();
        final var max = config.transitionDuration().asTicks();

        final var r = class_9848.method_61327(correctionMultiplier) * class_9848.method_61327(base);
        final var g = class_9848.method_61329(correctionMultiplier) * class_9848.method_61329(base);
        final var b = class_9848.method_61331(correctionMultiplier) * class_9848.method_61331(base);

        return class_9848.method_61324(
            class_9848.method_61320(base),
            Integer.divideUnsigned(max * r + curr * (255 * 255 - r), 255 * max),
            Integer.divideUnsigned(max * g + curr * (255 * 255 - g), 255 * max),
            Integer.divideUnsigned(max * b + curr * (255 * 255 - b), 255 * max)
        );
    }
}
