package io.github.startsmercury.visual_snowy_leaves.impl.client.entrypoint;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

import static io.github.startsmercury.visual_snowy_leaves.impl.client.VslConstants.MODID;

public class VisualSnowyLeavesFabric implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        final var fabricLoader = FabricLoader.getInstance();
        final var visualSnowyLeaves = class_310.method_1551().getVisualSnowyLeaves();

        visualSnowyLeaves.reloadConfig();

        if (!fabricLoader.isModLoaded("fabric-resource-loader-v0")) {
            return;
        }

        ResourceManagerHelper.registerBuiltinResourcePack(
            class_2960.method_60655(MODID, "vsl-jlf"),
            fabricLoader.getModContainer(MODID).orElseThrow(() -> new AssertionError(
                "Expected this mod ("
                    + MODID
                    + ") be loaded and recognized by VisualSnowyLeavesFabric"
            )),
            class_2561.method_43470("Jungle Leaves Fix"),
            ResourcePackActivationType.NORMAL
        );
    }
}
