package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.options;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_8012;
import org.jetbrains.annotations.Nullable;

public abstract class LabeledOptionEntry extends OptionEntry {
    protected static final int SPACING = 1;

    private final List<class_5481> label;

    public LabeledOptionEntry(
        final Context context,
        final class_2561 component,
        @Nullable final List<class_5481> tooltip
    ) {
        super(context, tooltip);

        this.label = this.context.font().method_1728(component, this.getLeftWidth());
    }

    protected final int getLeftWidth() {
        return PREFERRED_WIDTH - SPACING - this.getRightWidth();
    }

    protected abstract int getRightWidth();

    protected void renderLabel(final class_332 guiGraphics, final int rowTop, final int rowLeft) {
        final var font = this.context.font();

        if (this.label.size() == 1) {
            guiGraphics.method_35720(font, this.label.getFirst(), rowLeft, rowTop + HALF_LINE_H, class_8012.field_42973);
        } else if (this.label.size() >= 2) {
            guiGraphics.method_35720(font, this.label.get(0), rowLeft, rowTop, class_8012.field_42973);
            guiGraphics.method_35720(font, this.label.get(1), rowLeft, rowTop + LINE_HEIGHT, class_8012.field_42973);
        }
    }
}
