package io.github.startsmercury.visual_snowy_leaves.impl.client.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.startsmercury.visual_snowy_leaves.impl.client.VslConstants;
import org.jetbrains.annotations.NotNull;

import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.class_7291;
import net.minecraft.class_7995;

public enum SnowyMode implements class_7291 {
    /**
     * Snow leaves disabled.
     */
    NEVER,
    /**
     * Snowy leaves when it is snowing at a block.
     */
    SNOWING,
    /**
     * Snowy leaves regardless of weather or temperature.
     */
    ALWAYS;

    private static final IntFunction<SnowyMode> BY_ID =
        class_7995.method_47914(SnowyMode::method_7362, values(), class_7995.class_7996.field_41665);

    public static final Codec<SnowyMode> CODEC = Codec.STRING.comapFlatMap(
        input -> {
            try {
                return DataResult.success(SnowyMode.valueOf(input.toUpperCase(Locale.ROOT)));
            } catch (final IllegalArgumentException cause) {
                return DataResult.error(() -> "Unrecognized snowy mode");
            }
        },
        self -> self.name().toLowerCase(Locale.ROOT)
    );

    public static SnowyMode byId(final int id) {
        return BY_ID.apply(id);
    }

    @Override
    public int method_7362() {
        return this.ordinal();
    }

    @Override
    public @NotNull String method_7359() {
        return VslConstants.MODID + ".option.snowyMode." + this.name().toLowerCase(Locale.ROOT);
    }
}
