package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.options;

import com.google.common.collect.ImmutableList;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.Config;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.RebuildInterval;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.SnowyMode;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.Tick32;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.TickUtil;
import io.github.startsmercury.visual_snowy_leaves.impl.client.config.TransitionDuration;
import io.github.startsmercury.visual_snowy_leaves.impl.client.gui.screens.TargetBlocksScreen;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5481;
import net.minecraft.class_7999;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public class OptionsList extends class_4265<OptionEntry> {
    @FunctionalInterface
    private interface EntryFactory<T> {
        LabeledOptionEntry create(
            OptionEntry.Context context,
            class_2561 label,
            @Nullable List<class_5481> tooltip,
            String narrateDefaults,
            Supplier<? extends T> getter,
            Consumer<? super T> setter
        );
    }

    public static final int ITEM_INSET = 2;
    public static final int ITEM_HEIGHT = OptionEntry.PREFERRED_HEIGHT + 2 * ITEM_INSET;

    private final OptionEntry.Context context;

    @Nullable
    private OptionEntry relevant;

    private boolean disabled;
    private RebuildInterval rebuildInterval;
    private boolean requireSnowyBiomes;
    private boolean requireSnowyWeather;
    private final SnowyMode snowyMode;
    private Set<class_2960> targetBlockKeys;
    private TransitionDuration transitionDuration;

    public OptionsList(final OptionEntry.Context context, final Config initialConfig, final int width, final int height, final int y) {
        super(class_310.method_1551(), width, height, y, ITEM_HEIGHT);

        this.context = context;

        this.disabled = initialConfig.disabled();
        this.rebuildInterval = initialConfig.rebuildInterval();
        this.requireSnowyBiomes = initialConfig.requireSnowyBiomes();
        this.requireSnowyWeather = initialConfig.requireSnowyWeather();
        this.snowyMode = initialConfig.snowyMode();
        this.targetBlockKeys = initialConfig.targetBlockKeys();
        this.transitionDuration = initialConfig.transitionDuration();

        this.addCategoryEntry("toggles", null);
        this.addEntry("disabled", Config.DEFAULT.disabled(), () -> this.disabled, b -> this.disabled = b);
        this.addEntry("requireSnowyBiomes", Config.DEFAULT.requireSnowyBiomes(), () -> this.requireSnowyBiomes, b -> this.requireSnowyBiomes = b);
        this.addEntry("requireSnowyWeather", Config.DEFAULT.requireSnowyWeather(), () -> this.requireSnowyWeather, b -> this.requireSnowyWeather = b);

        this.addCategoryEntry("time", class_2561.method_43470("h:mm:ss+tt").method_27692(class_124.field_1080));
        this.addEntry("rebuildInterval", Config.DEFAULT.rebuildInterval(), () -> this.rebuildInterval, t -> this.rebuildInterval = t);
        this.addEntry("transitionDuration", Config.DEFAULT.transitionDuration(), () -> this.transitionDuration, t -> this.transitionDuration = t);

        this.addCategoryEntry("advance", null);
        this.addEntry(
            "targetBlockKeys",
            "",
            () -> this.targetBlockKeys,
            c -> this.targetBlockKeys = c,
            (c, label, tooltip, narrateDefaults, getter, setter) -> new CustomizeOptionEntry(
                c,
                label,
                tooltip,
                narrateDefaults,
                screen -> new TargetBlocksScreen(screen, getter.get(), setter)
            )
        );
    }

    public Config build() {
        return new Config(
            Config.CURRENT_VERSION,
            this.disabled,
            this.rebuildInterval,
            this.requireSnowyBiomes,
            this.requireSnowyWeather,
            this.snowyMode,
            this.targetBlockKeys,
            this.transitionDuration
        );
    }

    @Override
    public void setSelected(final @Nullable OptionEntry entry) {
        super.method_25313(entry);

        this.relevant = this.field_22740.method_48186().method_48183() ? entry : null;
    }

    public void method_48579(
        final class_332 guiGraphics,
        final int mouseX,
        final int mouseY,
        final float deltaTicks
    ) {
        super.method_48579(guiGraphics, mouseX, mouseY, deltaTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderTooltip(
        final class_332 guiGraphics,
        final int mouseX,
        final int mouseY
    ) {
        final List<class_5481> tooltip;
        final class_8000 positioner;

        final var relevant = this.relevant;
        if (relevant != null) {
            if ((tooltip = relevant.tooltip) == null) {
                return;
            }

            positioner = new class_7999(new class_8030(
                this.method_25342(),
                method_25337(this.method_25396().indexOf(this.relevant)),
                this.method_25368(),
                this.field_62109
            ));
        } else {
            final var hovered = this.method_37019();

            if (hovered == null || (tooltip = hovered.tooltip) == null) {
                return;
            }

            positioner = class_8001.field_41687;
        }

        guiGraphics.method_51436(
            this.field_22740.field_1772,
            tooltip,
            positioner,
            mouseX,
            mouseY,
            false
        );
    }

    @Override
    public void method_25395(@Nullable final class_364 guiEventListener) {
        final var previous = this.method_25334();
        super.method_25395(guiEventListener);
        if (guiEventListener != null && this.method_25334() == null) {
            this.setSelected(previous);
        }
    }

    @Override
    public void method_16014(final double mouseX, final double mouseY) {
        this.relevant = null;
    }

    @Override
    protected boolean method_73379() {
        return true;
    }

    private void addCategoryEntry(final String id, final @Nullable class_2561 details) {
        final var labelId = "visual-snowy-leaves.config.option.category." + id;
        final var longId = labelId + ".long";
        final var descriptionId = labelId + ".description";

        this.method_25321(new OptionCategoryEntry(
            context,
            class_2561.method_43471(labelId).method_27695(class_124.field_1067, class_124.field_1054),
            class_2561.method_43471(longId),
            class_1074.method_4663(descriptionId) ? class_2561.method_43471(descriptionId) : null,
            details
        ));
    }

    private void addEntry(
        final String id,
        final boolean defaultValue,
        final BooleanSupplier getter,
        final BooleanConsumer setter
    ) {
        this.<Boolean>addEntry(id, Boolean.toString(defaultValue), getter::getAsBoolean, setter, BooleanOptionEntry::new);
    }

    private <T extends Tick32<T>> void addEntry(
        final String id,
        final T defaultValue,
        final Supplier<T> getter,
        final Consumer<T> setter
    ) {
        this.addEntry(id, TickUtil.format(defaultValue.asTicks(), true), getter, setter, Tick32OptionEntry::new);
    }

    private <T> void addEntry(
        final String id,
        final String defaultString,
        final Supplier<T> getter,
        final Consumer<? super T> setter,
        final EntryFactory<T> factory
    ) {
        final var labelId = "visual-snowy-leaves.config.option." + id;
        final var label = class_2561.method_43471(labelId);
        final var internalName = class_2561.method_43470(id).method_27692(class_124.field_1054);
        final var defaultComponent = defaultString.isEmpty() ? null :
            class_2561.method_43469("editGamerule.default", class_2561.method_43470(defaultString))
                .method_27692(class_124.field_1080);
        final var descriptionId = labelId + ".description";

        final List<class_5481> tooltip;
        final String narrateDefaults;

        if (class_1074.method_4663(descriptionId)) {
            final var builder = ImmutableList.<class_5481>builder()
                .add(internalName.method_30937());

            final var description = class_2561.method_43471(descriptionId);
            context.font().method_1728(description, 150).forEach(builder::add);

            if (defaultComponent != null) {
                tooltip = builder.add(defaultComponent.method_30937()).build();
                narrateDefaults = description.getString() + "\n" + defaultComponent.getString();
            } else {
                tooltip = builder.build();
                narrateDefaults = description.getString();
            }
        } else if (defaultComponent != null) {
            tooltip = ImmutableList.of(
                internalName.method_30937(),
                defaultComponent.method_30937()
            );
            narrateDefaults = defaultComponent.getString();
        } else {
            tooltip = ImmutableList.of();
            narrateDefaults = "";
        }

        this.method_25321(factory.create(context, label, tooltip, narrateDefaults, getter, setter));
    }
}
