package io.github.startsmercury.visual_snowy_leaves.impl.client.gui.components.suggest;

import com.mojang.brigadier.suggestion.Suggestion;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_332;
import net.minecraft.class_768;
import net.minecraft.class_8012;
import org.jetbrains.annotations.Nullable;

public class SuggestionsList {
    static final int ITEM_HEIGHT = 12;

    private final InputSuggestions suggestions;

    private final class_768 rect;
    private final String originalContents;
    private final List<Suggestion> suggestionList;
    private int offset;
    private int current;
    private class_241 lastMouse;
    boolean tabCycles;
    private int lastNarratedEntry;

    public SuggestionsList(
        final InputSuggestions suggestions,
        final int x,
        final int y,
        final int width,
        final List<Suggestion> suggestionList,
        final boolean bl
    ) {
        this.lastMouse = class_241.field_1340;
        this.lastNarratedEntry = bl ? -1 : 0;
        this.originalContents = suggestions.input.method_1882();

        final var inputBordered = suggestions.input.method_1851();
        final var height = ITEM_HEIGHT
            * Math.min(suggestionList.size(), suggestions.suggestionLineLimit);
        this.rect = new class_768(
            inputBordered ? x : x - 1,
            suggestions.anchorToBottom ? y - 3 - height : (inputBordered ? y - 1 : y),
            width + 1,
            height
        );

        this.suggestions = suggestions;
        this.suggestionList = suggestionList;
        this.select(0);
    }

    public void render(final class_332 guiGraphics, final int mouseX, final int mouseY) {
        final var visibleItems =
            Math.min(this.suggestionList.size(), this.suggestions.suggestionLineLimit);

        final var mouseMoved =
            this.lastMouse.field_1343 != (float) mouseX || this.lastMouse.field_1342 != (float) mouseY;
        if (mouseMoved) {
            this.lastMouse = new class_241((float) mouseX, (float) mouseY);
        }

        final var upperDashedLines = this.offset > 0;
        final var bottomDashedLines = this.suggestionList.size() > this.offset + visibleItems;
        if (upperDashedLines || bottomDashedLines) {
            guiGraphics.method_25294(
                this.rect.method_3321(),
                this.rect.method_3322() - 1,
                this.rect.method_3321() + this.rect.method_3319(),
                this.rect.method_3322(),
                this.suggestions.fillColor
            );
            guiGraphics.method_25294(
                this.rect.method_3321(),
                this.rect.method_3322() + this.rect.method_3320(),
                this.rect.method_3321() + this.rect.method_3319(),
                this.rect.method_3322() + this.rect.method_3320() + 1,
                this.suggestions.fillColor
            );

            if (upperDashedLines) {
                for (var i = 0; i < this.rect.method_3319(); ++i) {
                    if (i % 2 != 0) continue;
                    guiGraphics.method_25294(
                        this.rect.method_3321() + i,
                        this.rect.method_3322() - 1,
                        this.rect.method_3321() + i + 1,
                        this.rect.method_3322(),
                        class_8012.field_42973
                    );
                }
            }

            if (bottomDashedLines) {
                for (var i = 0; i < this.rect.method_3319(); ++i) {
                    if (i % 2 != 0) continue;
                    guiGraphics.method_25294(
                        this.rect.method_3321() + i,
                        this.rect.method_3322() + this.rect.method_3320(),
                        this.rect.method_3321() + i + 1,
                        this.rect.method_3322() + this.rect.method_3320() + 1,
                        class_8012.field_42973
                    );
                }
            }
        }

        var containsMouse = false;
        for (var i = 0; i < visibleItems; ++i) {
            final var suggestion = this.suggestionList.get(i + this.offset);

            final var x1 = this.rect.method_3321();
            final var y1 = this.rect.method_3322() + i * ITEM_HEIGHT;
            final var x2 = this.rect.method_3321() + this.rect.method_3319();
            final var y2 = this.rect.method_3322() + (i + 1) * ITEM_HEIGHT;

            guiGraphics.method_25294(x1, y1, x2, y2, this.suggestions.fillColor);

            if (x1 < mouseX && mouseX < x2 && y1 < mouseY && mouseY < y2) {
                if (mouseMoved) {
                    this.select(i + this.offset);
                }

                containsMouse = true;
            }

            guiGraphics.method_25303(
                this.suggestions.font,
                suggestion.getText(),
                this.rect.method_3321() + 1,
                this.rect.method_3322() + 2 + i * ITEM_HEIGHT,
                i + this.offset == this.current ? class_8012.field_46767 : 0xffaaaaaa // = ChatFormatting.GRAY | 0xff000000
            );
        }

        if (containsMouse) {
            final var message = this.suggestionList.get(this.current).getTooltip();

            if (message != null) {
                guiGraphics.method_51438(
                    this.suggestions.font,
                    class_2564.method_10883(message),
                    mouseX,
                    mouseY
                );
            }
        }
    }

    public boolean mouseClicked(final int mouseX, final int mouseY) {
        if (!this.rect.method_3318(mouseX, mouseY)) return false;

        final var i = (mouseY - this.rect.method_3322()) / ITEM_HEIGHT + this.offset;
        if (i >= 0 && i < this.suggestionList.size()) {
            this.select(i);
            this.useSuggestion();
        }

        return true;
    }

    public boolean mouseScrolled(final double scrollAmount) {
        final var minecraft = this.suggestions.minecraft;
        final var mouseHandler = minecraft.field_1729;
        final var window = minecraft.method_22683();

        final var mouseX = (int) mouseHandler.method_68879(window);
        final var mouseY = (int) mouseHandler.method_68883(window);

        if (this.rect.method_3318(mouseX, mouseY)) {
            this.setOffset((int) (this.offset - scrollAmount));
            return true;
        } else {
            return false;
        }
    }

    public boolean keyPressed(final class_11908 event) {
        if (event.method_74234()) {
            this.cycle(-1);
            this.tabCycles = false;
        } else if (event.method_74235()) {
            this.cycle(1);
            this.tabCycles = false;
        } else if (event.method_74236()) {
            if (this.tabCycles) {
                this.cycle(event.method_74239() ? -1 : 1);
            }

            this.useSuggestion();
        } else if (event.method_74231()) {
            this.suggestions.hide();
            this.suggestions.input.method_1887(null);
        } else {
            return false;
        }

        return true;
    }

    public void cycle(final int i) {
        this.select(this.current + i);

        final var j = this.offset;
        final var k = this.offset + this.suggestions.suggestionLineLimit - 1;

        if (this.current - 1 < j) {
            this.setOffset(this.current - 1);
        } else if (this.current + 1 > k) {
            this.setOffset(
                this.current
                    + this.suggestions.lineStartOffset
                    - this.suggestions.suggestionLineLimit
                    + 2
            );
        }
    }

    private void setOffset(final int offset) {
        this.offset = Math.clamp(
            offset,
            0,
            Math.max(this.suggestionList.size() - this.suggestions.suggestionLineLimit, 0)
        );
    }

    public void select(final int i) {
        this.current = i;

        if (this.current < 0) {
            this.current += this.suggestionList.size();
        }

        if (this.current >= this.suggestionList.size()) {
            this.current -= this.suggestionList.size();
        }

        final var suggestion = this.suggestionList.get(this.current);

        this.suggestions.input.method_1887(calculateSuggestionSuffix(
            this.suggestions.input.method_1882(),
            suggestion.apply(this.originalContents)
        ));

        if (this.lastNarratedEntry != this.current) {
            this.suggestions.minecraft.method_44713().method_37015(this.getNarrationMessage());
        }
    }

    @Nullable
    private static String calculateSuggestionSuffix(final String prefix, final String suggestion) {
        return suggestion.startsWith(prefix) ? suggestion.substring(prefix.length()) : null;
    }

    public void useSuggestion() {
        final var suggestion = this.suggestionList.get(this.current);
        this.suggestions.keepSuggestions = true;
        this.suggestions.input.method_1852(suggestion.apply(this.originalContents));
        final var i = suggestion.getRange().getStart() + suggestion.getText().length();
        this.suggestions.input.method_1875(i);
        this.suggestions.input.method_1884(i);
        this.select(this.current);
        this.suggestions.keepSuggestions = false;
        this.tabCycles = true;
    }

    class_2561 getNarrationMessage() {
        this.lastNarratedEntry = this.current;
        final var suggestion = this.suggestionList.get(this.current);
        final var message = suggestion.getTooltip();
        if (message != null) {
            return class_2561.method_43469(
                "narration.suggestion.tooltip",
                this.current + 1,
                this.suggestionList.size(),
                suggestion.getText(),
                class_2561.method_54155(message)
            );
        } else {
            return class_2561.method_43469(
                "narration.suggestion",
                this.current + 1,
                this.suggestionList.size(),
                suggestion.getText()
            );
        }
    }
}
