package io.github.startsmercury.visual_snowy_leaves.mixin.client.tint;

import static net.minecraft.class_9824.field_55458;

import com.google.gson.JsonParseException;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.JsonOps;
import io.github.startsmercury.visual_snowy_leaves.impl.client.SpriteWhitener;
import io.github.startsmercury.visual_snowy_leaves.impl.client.VslConstants;
import io.github.startsmercury.visual_snowy_leaves.impl.client.util.SequencedCompletableFuture;
import io.github.startsmercury.visual_snowy_leaves.impl.client.util.UnknownBlockStateDefinitionException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.class_10811;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7766;
import net.minecraft.class_790;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_1092.class)
public abstract class ModelManagerMixin {
    @Shadow
    @Final
    private class_324 blockColors;

    @ModifyVariable(method = "reload", at = @At("STORE"), ordinal = 7)
    private CompletableFuture<class_7766.class_7767> modifySprites(
        final CompletableFuture<class_7766.class_7767> spritePreparationsFuture,
        final @Local(ordinal = 0, argsOnly = true) Executor executor,
        final @Local(ordinal = 0) class_3300 resourceManager,
        final @Local(ordinal = 2) CompletableFuture<Map<class_2960, class_1100>> unbakedModelsFuture,
        final @Local(ordinal = 5) CompletableFuture<class_1092.class_10816> modelDiscoveryFuture
    ) {
        final var blockstateResourcesFuture = CompletableFuture.supplyAsync(
            () -> field_55458.method_45116(resourceManager),
            executor
        );

        final var function = class_10811.method_68013();
        final var visualSnowyLeaves = class_310.method_1551().getVisualSnowyLeaves();
        final var logger = visualSnowyLeaves.getLogger();

        final var blockModelDefinitionsFuture = blockstateResourcesFuture.thenCompose(map -> {
            final var list = new ArrayList<
                CompletableFuture<Map.Entry<class_2960, ArrayList<class_790>>>
            >(map.size());

            for (final var entry : map.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    final var resourceLocation = field_55458.method_45115(entry.getKey());
                    final var stateDefinition = function.apply(resourceLocation);

                    if (stateDefinition == null) {
                        throw new UnknownBlockStateDefinitionException(resourceLocation);
                    }

                    final var resources = entry.getValue();
                    final var blockModelDefinitions =
                        new ArrayList<class_790>(resources.size());

                    for (final var resource : resources) {
                        try (final var reader = resource.method_43039()) {
                            final var jsonObject = class_3518.method_15255(reader);
                            final var blockModelDefinition =
                                class_790.field_56928.parse(JsonOps.INSTANCE, jsonObject).getOrThrow(JsonParseException::new);
                            blockModelDefinitions.add(blockModelDefinition);
                        } catch (final Exception exception) {
                            logger.error(
                                "Failed to load blockstate definition {} from pack {}",
                                resourceLocation,
                                resource.method_14480(),
                                exception
                            );
                        }
                    }

                    return Map.entry(resourceLocation, blockModelDefinitions);
                }, executor));
            }

            return SequencedCompletableFuture.tryFilter(list, throwable -> {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof final Error error) {
                    throw error;
                } else if (throwable instanceof final UnknownBlockStateDefinitionException cause) {
                    logger.debug(
                        "[{}] Discovered unknown block state definition {}, ignoring",
                        VslConstants.NAME,
                        cause.getResourceLocation()
                    );
                } else {
                    logger.error("[{}] Uncaught exception", VslConstants.NAME, throwable);
                }
            });
        });

        final var spriteWhitenerFuture = modelDiscoveryFuture.thenCompose(modelDiscovery -> {
            return blockModelDefinitionsFuture.thenApplyAsync(
                entries -> {
                    final var spriteWhitener = SpriteWhitener.create(visualSnowyLeaves);
                    for (final var entry : entries) {
                        for (final var blockModelDefinition : entry.getValue()) {
                            spriteWhitener.analyzeModels(entry.getKey(), blockModelDefinition);
                        }
                    }
                    return spriteWhitener;
                },
                executor
            );
        });

        final var waitForAllFuture = CompletableFuture.allOf(
            // Redundancy: already done in first `allOf`
            spriteWhitenerFuture,
            // No comment.
            // afterPreparationBarrierFuture,
            spritePreparationsFuture,
            // Redundancy: already done in second `allOf`
            unbakedModelsFuture
        );

        return waitForAllFuture.thenApplyAsync(_void -> {
            final var spriteWhitener = spriteWhitenerFuture.join();
            final var spritePreparations = spritePreparationsFuture.join();
            spriteWhitener.modifySprites(
                this.blockColors,
                unbakedModelsFuture.join(),
                spritePreparations::method_73022
            );
            visualSnowyLeaves.collectReports(spriteWhitener);
            final var ignored = visualSnowyLeaves.sendReportNotice();
            return spritePreparations;
        }, executor);
    }
}
