/*
 * Decompiled with CFR 0.152.
 */
package Lifesteal.mamtak.lifestealSMP;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class LifestealSMP
extends JavaPlugin
implements Listener,
TabExecutor {
    private NamespacedKey keyType;
    private NamespacedKey keyData;
    private static final String REVIVE_GUI_TITLE = String.valueOf(ChatColor.DARK_RED) + "Revive \u00bb Choose player";
    private static final int REVIVE_GUI_SIZE = 54;

    public void onEnable() {
        this.saveDefaultConfig();
        this.keyType = new NamespacedKey((Plugin)this, "ls_type");
        this.keyData = new NamespacedKey((Plugin)this, "ls_data");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("withdraw")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("withdraw")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("lifesteal")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("lifesteal")).setTabCompleter((TabCompleter)this);
        this.registerRecipes();
        this.getLogger().info("LifeStealSMP enabled.");
    }

    public void onDisable() {
        this.saveConfig();
    }

    private FileConfiguration C() {
        return this.getConfig();
    }

    private int maxHearts() {
        return this.C().getInt("max-hearts", 20);
    }

    private int minHearts() {
        return this.C().getInt("min-hearts", 1);
    }

    private int reviveHearts() {
        return this.C().getInt("revive-hearts", 3);
    }

    private String msg(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.C().getString("messages." + path, ""));
    }

    private String cc(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private String repl(String s) {
        return s.replace("%max%", String.valueOf(this.maxHearts())).replace("%revive%", String.valueOf(this.reviveHearts()));
    }

    private List<String> ccList(List<String> list) {
        return list.stream().map(this::repl).map(this::cc).collect(Collectors.toList());
    }

    private ItemStack makeHeart(int amount) {
        ItemStack it = new ItemStack(Material.RED_DYE, Math.max(1, amount));
        ItemMeta im = it.getItemMeta();
        im.setDisplayName(this.cc(this.repl(this.C().getString("items.heart.name", "Heart"))));
        im.setLore(this.ccList(this.C().getStringList("items.heart.lore")));
        im.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, true);
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        im.getPersistentDataContainer().set(this.keyType, PersistentDataType.STRING, (Object)"HEART");
        it.setItemMeta(im);
        return it;
    }

    private ItemStack makeFragment(int amount) {
        ItemStack it = new ItemStack(Material.RED_CANDLE, Math.max(1, amount));
        ItemMeta im = it.getItemMeta();
        im.setDisplayName(this.cc(this.repl(this.C().getString("items.fragment.name", "Heart Fragment"))));
        im.setLore(this.ccList(this.C().getStringList("items.fragment.lore")));
        im.getPersistentDataContainer().set(this.keyType, PersistentDataType.STRING, (Object)"FRAGMENT");
        it.setItemMeta(im);
        return it;
    }

    private ItemStack makeReviveStar(int amount) {
        ItemStack it = new ItemStack(Material.NETHER_STAR, Math.max(1, amount));
        ItemMeta im = it.getItemMeta();
        im.setDisplayName(this.cc(this.repl(this.C().getString("items.revive.name", "Revive Star"))));
        im.setLore(this.ccList(this.C().getStringList("items.revive.lore")));
        im.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, true);
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        im.getPersistentDataContainer().set(this.keyType, PersistentDataType.STRING, (Object)"REVIVE");
        it.setItemMeta(im);
        return it;
    }

    private boolean isType(ItemStack it, String type) {
        if (it == null || it.getType().isAir() || !it.hasItemMeta()) {
            return false;
        }
        String t = (String)it.getItemMeta().getPersistentDataContainer().get(this.keyType, PersistentDataType.STRING);
        return type.equalsIgnoreCase(t);
    }

    private void registerRecipes() {
        this.removeRecipe("lifesteal_fragment");
        this.removeRecipe("lifesteal_heart");
        this.removeRecipe("lifesteal_revive");
        ShapedRecipe fragment = new ShapedRecipe(new NamespacedKey((Plugin)this, "lifesteal_fragment"), this.makeFragment(1));
        fragment.shape(new String[]{"TNT", "NRN", "TNT"});
        fragment.setIngredient('T', Material.TOTEM_OF_UNDYING);
        fragment.setIngredient('N', Material.NETHERITE_INGOT);
        fragment.setIngredient('R', Material.RED_DYE);
        Bukkit.addRecipe((Recipe)fragment);
        ShapedRecipe heart = new ShapedRecipe(new NamespacedKey((Plugin)this, "lifesteal_heart"), this.makeHeart(1));
        heart.shape(new String[]{"FTF", "TRT", "FTF"});
        heart.setIngredient('T', Material.TOTEM_OF_UNDYING);
        heart.setIngredient('R', Material.RED_DYE);
        heart.setIngredient('F', (RecipeChoice)new RecipeChoice.MaterialChoice(Material.RED_CANDLE));
        Bukkit.addRecipe((Recipe)heart);
        ShapedRecipe revive = new ShapedRecipe(new NamespacedKey((Plugin)this, "lifesteal_revive"), this.makeReviveStar(1));
        revive.shape(new String[]{"TTT", "TNT", "TTT"});
        revive.setIngredient('T', Material.TOTEM_OF_UNDYING);
        revive.setIngredient('N', Material.NETHER_STAR);
        Bukkit.addRecipe((Recipe)revive);
    }

    private void removeRecipe(String key) {
        Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            Recipe r = (Recipe)it.next();
            if (!(r instanceof Keyed) || !((Keyed)r).getKey().getKey().equalsIgnoreCase(key)) continue;
            it.remove();
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent e) {
        if (!(e.getRecipe() instanceof ShapedRecipe)) {
            return;
        }
        ShapedRecipe sr = (ShapedRecipe)e.getRecipe();
        if (!"lifesteal_heart".equalsIgnoreCase(sr.getKey().getKey())) {
            return;
        }
        ItemStack[] grid = e.getInventory().getMatrix();
        int fragments = 0;
        for (ItemStack is : grid) {
            if (is == null || is.getType().isAir() || is.getType() != Material.RED_CANDLE) continue;
            if (!this.isType(is, "FRAGMENT")) {
                e.getInventory().setResult(null);
                return;
            }
            ++fragments;
        }
        if (fragments != 4) {
            e.getInventory().setResult(null);
        }
    }

    private int getHearts(Player p) {
        AttributeInstance att = p.getAttribute(Attribute.MAX_HEALTH);
        double max = att != null ? att.getBaseValue() : 20.0;
        return (int)Math.round(max / 2.0);
    }

    private void setHearts(Player p, int hearts) {
        hearts = Math.max(1, Math.min(this.maxHearts(), hearts));
        AttributeInstance att = p.getAttribute(Attribute.MAX_HEALTH);
        if (att != null) {
            att.setBaseValue((double)hearts * 2.0);
            if (p.getHealth() > att.getBaseValue()) {
                p.setHealth(att.getBaseValue());
            }
        }
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("withdraw")) {
            int give;
            int amt;
            if (!(s instanceof Player)) {
                s.sendMessage(String.valueOf(ChatColor.RED) + "Players only.");
                return true;
            }
            Player p = (Player)s;
            if (args.length != 1) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /withdraw <amount>");
                return true;
            }
            try {
                amt = Integer.parseInt(args[0]);
            }
            catch (Exception ex) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be a number.");
                return true;
            }
            if (amt <= 0) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be positive.");
                return true;
            }
            int cur = this.getHearts(p);
            if (cur - amt < Math.max(1, this.minHearts())) {
                p.sendMessage(this.msg("withdraw-too-low").replace("%min%", String.valueOf(Math.max(1, this.minHearts()))).replace("%have%", String.valueOf(cur)));
                return true;
            }
            for (int left = amt; left > 0; left -= give) {
                give = Math.min(64, left);
                HashMap overflow = p.getInventory().addItem(new ItemStack[]{this.makeHeart(give)});
                overflow.values().forEach(item -> p.getWorld().dropItemNaturally(p.getLocation(), item));
            }
            this.setHearts(p, cur - amt);
            p.sendMessage(this.msg("withdraw-success").replace("%amount%", String.valueOf(amt)).replace("%new%", String.valueOf(this.getHearts(p))));
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("lifesteal")) {
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                if (!s.hasPermission("lifesteal.reload")) {
                    s.sendMessage(String.valueOf(ChatColor.RED) + "No permission.");
                    return true;
                }
                this.reloadConfig();
                this.registerRecipes();
                s.sendMessage(String.valueOf(ChatColor.GREEN) + "LifeSteal config reloaded.");
                return true;
            }
            s.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lifesteal reload");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender s, Command cmd, String alias, String[] args) {
        if (cmd.getName().equalsIgnoreCase("lifesteal") && args.length == 1) {
            return Collections.singletonList("reload");
        }
        return Collections.emptyList();
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        ItemStack it = e.getItem();
        if (it == null) {
            return;
        }
        if (this.isType(it, "HEART")) {
            e.setCancelled(true);
            Player p = e.getPlayer();
            if (this.getHearts(p) >= this.maxHearts()) {
                p.sendMessage(this.msg("heart-maxed").replace("%max%", String.valueOf(this.maxHearts())));
                return;
            }
            this.setHearts(p, this.getHearts(p) + 1);
            this.consumeOne(p, it);
            p.sendMessage(this.msg("heart-claimed").replace("%new%", String.valueOf(this.getHearts(p))));
            p.getWorld().spawnParticle(Particle.HEART, p.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.02);
            p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
            return;
        }
        if (this.isType(it, "REVIVE")) {
            e.setCancelled(true);
            this.openReviveGUI(e.getPlayer());
        }
    }

    private void consumeOne(Player p, ItemStack it) {
        if (it.getAmount() > 1) {
            it.setAmount(it.getAmount() - 1);
        } else if (p.getInventory().getItemInMainHand().equals((Object)it)) {
            p.getInventory().setItemInMainHand(null);
        } else if (p.getInventory().getItemInOffHand().equals((Object)it)) {
            p.getInventory().setItemInOffHand(null);
        } else {
            it.setAmount(0);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        int min;
        Player victim = e.getEntity();
        Player killer = victim.getKiller();
        int vBefore = this.getHearts(victim);
        if (vBefore <= (min = Math.max(1, this.minHearts()))) {
            this.handleLifeBanNow(victim);
            return;
        }
        this.setHearts(victim, vBefore - 1);
        int vAfter = this.getHearts(victim);
        if (killer != null && !killer.equals((Object)victim)) {
            int kHearts = this.getHearts(killer);
            if (kHearts < this.maxHearts()) {
                this.setHearts(killer, kHearts + 1);
                killer.sendMessage(String.valueOf(ChatColor.GREEN) + "You stole 1 heart! Now at " + this.getHearts(killer));
            } else {
                victim.getWorld().dropItemNaturally(victim.getLocation(), this.makeHeart(1));
                killer.sendMessage(String.valueOf(ChatColor.YELLOW) + "Max hearts reached; the victim dropped a Heart item.");
            }
        }
        victim.sendMessage(String.valueOf(ChatColor.RED) + "You lost 1 heart! Now at " + vAfter);
    }

    public void lifeBan(UUID uuid, String name) {
        ArrayList<String> list = new ArrayList<String>(this.C().getStringList("life-banned"));
        if (!list.contains(uuid.toString())) {
            list.add(uuid.toString());
            this.C().set("life-banned", list);
            this.saveConfig();
        }
        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(name, "LifeSteal death ban", null, "LifeSteal");
    }

    public void lifeUnban(UUID uuid, String name) {
        ArrayList list = new ArrayList(this.C().getStringList("life-banned"));
        list.remove(uuid.toString());
        this.C().set("life-banned", list);
        this.saveConfig();
        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(name);
    }

    private List<OfflinePlayer> getLifeBanned() {
        HashSet ids = new HashSet(this.C().getStringList("life-banned"));
        ArrayList<OfflinePlayer> res = new ArrayList<OfflinePlayer>();
        for (String id : ids) {
            try {
                res.add(Bukkit.getOfflinePlayer((UUID)UUID.fromString(id)));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return res;
    }

    private void openReviveGUI(Player opener) {
        List<OfflinePlayer> banned = this.getLifeBanned();
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)REVIVE_GUI_TITLE);
        if (banned.isEmpty()) {
            ItemStack barrier = new ItemStack(Material.BARRIER);
            ItemMeta bm = barrier.getItemMeta();
            bm.setDisplayName(String.valueOf(ChatColor.RED) + "No players to revive");
            bm.setLore(Collections.singletonList(String.valueOf(ChatColor.GRAY) + "Nobody is life-banned right now."));
            barrier.setItemMeta(bm);
            inv.setItem(22, barrier);
            opener.openInventory(inv);
            return;
        }
        int slot = 0;
        for (OfflinePlayer op : banned) {
            if (slot >= 54) break;
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta sm = (SkullMeta)head.getItemMeta();
            sm.setOwningPlayer(op);
            sm.setDisplayName(String.valueOf(ChatColor.GOLD) + (op.getName() != null ? op.getName() : op.getUniqueId().toString()));
            sm.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "Click to revive", String.valueOf(ChatColor.GRAY) + "They will return with " + this.reviveHearts() + " hearts."));
            sm.getPersistentDataContainer().set(this.keyType, PersistentDataType.STRING, (Object)"REVIVE_TARGET");
            sm.getPersistentDataContainer().set(this.keyData, PersistentDataType.STRING, (Object)op.getUniqueId().toString());
            head.setItemMeta((ItemMeta)sm);
            inv.setItem(slot++, head);
        }
        opener.openInventory(inv);
    }

    @EventHandler
    public void onReviveClick(InventoryClickEvent e) {
        UUID targetId;
        if (e.getView() == null) {
            return;
        }
        if (!REVIVE_GUI_TITLE.equals(e.getView().getTitle())) {
            return;
        }
        e.setCancelled(true);
        HumanEntity clicker = e.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player p = (Player)clicker;
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || clicked.getType().isAir() || !clicked.hasItemMeta()) {
            return;
        }
        if (clicked.getType() == Material.BARRIER) {
            return;
        }
        PersistentDataContainer pdc = clicked.getItemMeta().getPersistentDataContainer();
        String t = (String)pdc.get(this.keyType, PersistentDataType.STRING);
        if (!"REVIVE_TARGET".equalsIgnoreCase(t)) {
            return;
        }
        String uuidStr = (String)pdc.get(this.keyData, PersistentDataType.STRING);
        if (uuidStr == null) {
            return;
        }
        ItemStack hand = p.getInventory().getItemInMainHand();
        ItemStack off = p.getInventory().getItemInOffHand();
        ItemStack star = null;
        if (this.isType(hand, "REVIVE")) {
            star = hand;
        } else if (this.isType(off, "REVIVE")) {
            star = off;
        }
        if (star == null) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Hold a Revive Star to revive a player.");
            p.closeInventory();
            return;
        }
        try {
            targetId = UUID.fromString(uuidStr);
        }
        catch (Exception ex) {
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)targetId);
        String name = target.getName() != null ? target.getName() : targetId.toString();
        this.lifeUnban(targetId, name);
        ArrayList<String> pend = new ArrayList<String>(this.C().getStringList("pending-revive"));
        if (!pend.contains(targetId.toString())) {
            pend.add(targetId.toString());
        }
        this.C().set("pending-revive", pend);
        this.saveConfig();
        if (star.getAmount() > 1) {
            star.setAmount(star.getAmount() - 1);
        } else if (p.getInventory().getItemInMainHand().equals((Object)star)) {
            p.getInventory().setItemInMainHand(null);
        } else if (p.getInventory().getItemInOffHand().equals((Object)star)) {
            p.getInventory().setItemInOffHand(null);
        }
        p.sendMessage(String.valueOf(ChatColor.GREEN) + "Revived " + String.valueOf(ChatColor.GOLD) + name + String.valueOf(ChatColor.GREEN) + ". They will return with " + this.reviveHearts() + " hearts.");
        p.closeInventory();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        ArrayList pend;
        Player p = e.getPlayer();
        if (this.getHearts(p) > this.maxHearts()) {
            this.setHearts(p, this.maxHearts());
        }
        if ((pend = new ArrayList(this.C().getStringList("pending-revive"))).remove(p.getUniqueId().toString())) {
            this.setHearts(p, Math.max(1, this.reviveHearts()));
            this.C().set("pending-revive", pend);
            this.saveConfig();
            p.sendMessage(String.valueOf(ChatColor.GREEN) + "You were revived and now have " + this.reviveHearts() + " hearts.");
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
    }

    public void handleLifeBanNow(Player victim) {
        this.lifeBan(victim.getUniqueId(), victim.getName());
        victim.kickPlayer(String.valueOf(ChatColor.RED) + "You are life-banned. A Revive Star can bring you back.");
    }
}

